﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Web;
//５1ａｓpｘ
namespace DBunit
{
   public class SQLAccess
    {
        public static readonly string connstr = ConfigurationManager.AppSettings["server"];

        /// <summary>
        /// 数据阅读器查询
        /// </summary>
        /// <param name="commandText">查询语句</param>
        /// <returns>读取的结果集</returns>
        public static SqlDataReader ExecuteDataReader(string commandText)
        {
            SqlConnection conn = new SqlConnection(connstr);

            conn.Open();
            SqlCommand cmd = new SqlCommand(commandText, conn);
            SqlDataReader dr = cmd.ExecuteReader();
            dr.Read();
            return dr;
        }
        /// <summary>
        /// 执行连接信息
        /// </summary>
        /// <param name="conn">连接数据库对象</param>
        /// <param name="cmd">执行命令对象</param>
        /// <param name="commandText">命令</param>
        static void Paremerts(SqlConnection conn, SqlCommand cmd, string commandText)
        {
            if (conn.State == ConnectionState.Closed)
                conn.Open();
            cmd.Connection = conn;
            cmd.CommandText = commandText;
            cmd.CommandType = CommandType.Text;
        }

        /// <summary>
        /// 执行修改数据信息
        /// </summary>
        /// <param name="connstring">连接对象</param>
        /// <param name="commandText">执行命令</param>
        /// <returns>返回受影响的行数</returns>
        public static int ExecuteNonQuery(string commandText)
        {
            SqlCommand cmd = new SqlCommand();
            using (SqlConnection conn = new SqlConnection(connstr))
            {
                Paremerts(conn, cmd, commandText);
                int i = cmd.ExecuteNonQuery();
                cmd.Parameters.Clear();
                return i;
            }
        }

        /// <summary>
        /// 执行查询数据信息
        /// </summary>
        /// <param name="commandtext">查询命令</param>
        /// <returns>返回查询的结果</returns>
        public static DataSet ExecuteDataSet(string commandtext)
        {
            SqlCommand cmd = new SqlCommand();
            using (SqlConnection conn = new SqlConnection(connstr))
            {
                Paremerts(conn, cmd, commandtext);
                SqlDataAdapter adp = new SqlDataAdapter(cmd);
                DataSet ds = new DataSet();
                adp.Fill(ds);
                cmd.Parameters.Clear();
                return ds;
            }
        }

        /// <summary>
        /// 获取具有斧子关系的dataset
        /// </summary>
        /// <param name="commandText1">父SQL语句</param>
        /// <param name="comandText2">子SQL语句</param>
        /// <returns></returns>
        public static DataSet ExecuteDataSetTwo(string commandText1, string commandText2)
        {
            SqlCommand cmd1 = new SqlCommand();
            SqlCommand cmd2 = new SqlCommand();


            SqlConnection conn = new SqlConnection(connstr);
            try
            {
                Paremerts(conn, cmd1, commandText1);
                Paremerts(conn, cmd2, commandText2);

                SqlDataAdapter adp1 = new SqlDataAdapter(cmd1);
                SqlDataAdapter adp2 = new SqlDataAdapter(cmd2);
                DataSet ds = new DataSet();

                adp1.Fill(ds, "P");
                adp2.Fill(ds, "C");

                cmd1.Parameters.Clear();
                cmd2.Parameters.Clear();

                return ds;
            }
            catch
            {
                conn.Close();
                throw;
            }
        }
    }
}
