﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_employe_employeInfo : System.Web.UI.Page
{
    BLL.tab_emps bll_Employe = new BLL.tab_emps();
    BLL.tab_powers bll_power = new BLL.tab_powers();
    

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //清除缓存
            Response.Expires = 0;
            Response.CacheControl = "no-cache";
            //职位的绑定
            DataSet ds = bll_Employe.getAllEmploye("select * from tab_roles");
            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
            {
                this.ddlCategory.Items.Add(new ListItem(ds.Tables[0].Rows[i]["roleName"].ToString(), ds.Tables[0].Rows[i]["roleID"].ToString()));
            }
        }

        //员工信息的绑定
        DataSet dsInfo = bll_Employe.getAllEmploye("select tab_emps.*,tab_roles.roleName from tab_emps join tab_roles on tab_roles.roleID=tab_emps.roleID");
        this.Datagrid2.DataSource = dsInfo;
        this.Datagrid2.DataBind();
    }

    //删除
    protected void Datagrid2_DeleteCommand(object source, DataGridCommandEventArgs e)
    {
        if (this.Datagrid2.CurrentPageIndex != 0 && this.Datagrid2.Items.Count == 1)
        {
            this.Datagrid2.CurrentPageIndex--;
        }

        int currentid = Convert.ToInt32(this.Datagrid2.DataKeys[e.Item.ItemIndex].ToString());
                        
        #region 得到登录人的权限
        int empid = Convert.ToInt32(Session["loginEmployerId"].ToString());
        DataSet dslogin = bll_Employe.getAllEmploye("select * from tab_emps where empID=" + empid);
        DataSet dsPower = bll_power.getAllPower("select * from tab_roles where roleID=" + Convert.ToInt32(dslogin.Tables[0].Rows[0]["roleID"].ToString()));
        string roles = dsPower.Tables[0].Rows[0]["roleInfo"].ToString();
        string[] role = roles.Split('|');
        #endregion

        #region 得到要被操作人的权限
        DataSet dsloginDel = bll_Employe.getAllEmploye("select * from tab_emps where empID=" + currentid);
        DataSet dsPowerDelete = bll_power.getAllPower("select * from tab_roles where roleID=" + Convert.ToInt32(dsloginDel.Tables[0].Rows[0]["roleID"].ToString()));
        string rolesDelete = dsPowerDelete.Tables[0].Rows[0]["roleInfo"].ToString();
        string[] roleDelete = rolesDelete.Split('|');
        #endregion

        if (role.Length > roleDelete.Length)
        {
            int dele = bll_Employe.deleteEmploye(currentid);

            if (dele == 0)
            {
                //Response.Write("<script>alert('删除失败！')</script>");
                ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('删除失败')</script>");
            }
            else
            {
                //Response.Write("<script>alert('删除成功！')</script>");
                ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('删除成功')</script>");
                DataSet dsInfo = bll_Employe.getAllEmploye("select tab_emps.*,tab_roles.roleName from tab_emps join tab_roles on tab_roles.roleID=tab_emps.roleID");
                this.Datagrid2.DataSource = dsInfo;
                this.Datagrid2.DataBind();
            }
        }
        else
        {
            ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('你的权限不能进行该操作！')</script>");
        }
        
    }

    //分页
    protected void Datagrid2_PageIndexChanged(object source, DataGridPageChangedEventArgs e)
    {
        this.Datagrid2.CurrentPageIndex = e.NewPageIndex;
        DataSet dsInfo = bll_Employe.getAllEmploye("select tab_emps.*,tab_roles.roleName from tab_emps join tab_roles on tab_roles.roleID=tab_emps.roleID");
        this.Datagrid2.DataSource = dsInfo;
        this.Datagrid2.DataBind();
    }


    //按职位搜索
    protected void ddlCategory_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (this.Datagrid2.CurrentPageIndex != 0)
        {
            this.Datagrid2.CurrentPageIndex = 0;
        }
        if (this.ddlCategory.SelectedItem.Text == "显示所有")
        {
            DataSet dsdd = bll_Employe.getAllEmploye("select tab_emps.*,tab_roles.roleName from tab_emps join tab_roles on tab_roles.roleID=tab_emps.roleID");
            if (dsdd.Tables[0].Rows.Count == 0)
            {
                //Response.Write("<script>alert('对不起！没有职位信息！')</script>");
                ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('对不起！没有职位信息！')</script>");
            }
            else
            {
                this.Datagrid2.DataSource = dsdd.Tables[0];
                this.Datagrid2.DataBind();
            }
        }
        else
        {
            DataSet dsdd = bll_Employe.getAllEmploye("select tab_emps.*,tab_roles.roleName from tab_emps join tab_roles on tab_roles.roleID=tab_emps.roleID  where tab_emps.roleID='" + Convert.ToInt32(this.ddlCategory.SelectedValue) + "'");
            if (dsdd.Tables[0].Rows.Count == 0)
            {
                //Response.Write("<script>alert('对不起！没有该职位！')</script>");
                ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('对不起！没有该职位！')</script>");
            }
            else
            {
                this.Datagrid2.DataSource = dsdd.Tables[0];
                this.Datagrid2.DataBind();
            }
        }
    }
    protected void Datagrid2_ItemDataBound(object sender, DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            e.Item.Attributes.Add("onMouseOver", "this.originalcolor=this.style.backgroundColor;this.style.backgroundColor='#C6DCF7';");
            e.Item.Attributes.Add("onMouseOut", "this.style.backgroundColor=this.originalcolor;");
            //e.Item.Attributes.Add("onclick", "window.open('news.aspx');");//跳转的地址
        }
    }
    protected void Datagrid2_ItemCommand(object source, DataGridCommandEventArgs e)
    {
        if (e.CommandName == "Update")
        {
            int ID = Convert.ToInt32(this.Datagrid2.DataKeys[e.Item.ItemIndex].ToString());
            
            #region 得到登录人的权限
            int empid = Convert.ToInt32(Session["loginEmployerId"].ToString());
            DataSet dslogin = bll_Employe.getAllEmploye("select * from tab_emps where empID=" + empid);
            DataSet dsPower = bll_power.getAllPower("select * from tab_roles where roleID=" + Convert.ToInt32(dslogin.Tables[0].Rows[0]["roleID"].ToString()));
            string roles = dsPower.Tables[0].Rows[0]["roleInfo"].ToString();
            string[] role = roles.Split('|');
            #endregion

            #region 得到要被操作人的权限
            DataSet dsloginDel = bll_Employe.getAllEmploye("select * from tab_emps where empID=" + ID);
            DataSet dsPowerDelete = bll_power.getAllPower("select * from tab_roles where roleID=" + Convert.ToInt32(dsloginDel.Tables[0].Rows[0]["roleID"].ToString()));
            string rolesDelete = dsPowerDelete.Tables[0].Rows[0]["roleInfo"].ToString();
            string[] roleDelete = rolesDelete.Split('|');
            #endregion

            if (role.Length > roleDelete.Length)
            {
                Response.Redirect("employeUpdate.aspx?nn="+ID);
            }
            else
            {
                ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('你的权限不能进行该操作！')</script>");
            }
        }
        
    }

    //添加
    protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("employeAdd.aspx");
    }

    //搜索
    protected void ImageButton2_Click(object sender, ImageClickEventArgs e)
    {
        if (this.txtName.Text == "")
        {
            //Response.Write("<script>alert('请输入要搜索的员工名')</script>");
            ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('请输入要搜索的员工名')</script>");
            this.txtName.Focus();
            return;
        }
        else
        {
            string proName = this.txtName.Text.Trim();
            DataSet dssousuo = bll_Employe.getAllEmploye("select tab_emps.*,tab_roles.roleName from tab_emps join tab_roles on tab_roles.roleID=tab_emps.roleID where tab_emps.empName like '%'+'" + proName + "'+'%'");
            if (dssousuo.Tables[0].Rows.Count == 0)
            {
                //Response.Write("<script>alert('对不起！没有找到您要的产品！')</script>");
                ClientScript.RegisterStartupScript(ClientScript.GetType(), "aa", "<script>alert('对不起！没有找到您要的产品！')</script>");
            }
            else
            {
                this.Datagrid2.DataSource = dssousuo.Tables[0];
                this.Datagrid2.DataBind();
            }
        }
    }
}
