﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           

            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:MemberRanks, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:MemberRanks, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:MemberRanks ID="MemberRanks" runat="server">
             <SkinTemplate>
<!-- 操作提示 -->
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

<div class="grdGroupFormList">             		

           <div class="grdHeaderStyle">
			   <ul>
			       <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Label ID="CheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>" ></asp:Label></a></li>
                   <li class="spirtLines">|</li>
                   <li class="userGroupReverseCheck"><a  href="#" onclick="CheckReverse()"><asp:Label ID="lblCheckRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                   <li class="spirtLines">|</li>
			       <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server"  Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
			   </ul>
			</div>
	        <div class="grdGroupList">
                <div class="grdGroupListLi">
                        <Hishop:CustomGridView ID="grdMemberRankList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="RankId" CssClass="GridViewStyle" GridLines="None" 
                          RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" SelectedRowStyle-BackColor="#FBFBF4">
			              <Columns>
			                  <Hishop:CheckBoxColumn ReadOnly="true"/>
			                 <asp:BoundField DataField="Name" HeaderText="<%$ Resources:MemberRanks,IDS_Header_RankName %>"/>
			                 <Hishop:YesNoImageColumn DataField="IsDefault" HeaderText="<%$ Resources:MemberRanks,IDS_Header_IsDefault %>" ></Hishop:YesNoImageColumn>
			                 <asp:BoundField DataField="Point" HeaderText="<%$ Resources:MemberRanks,IDS_Header_RankPoint %>"/>
			                 <asp:BoundField DataField="Description" HeaderText="<%$ Resources:AgentialRanks,IDS_DataField_RankDesc %>"/>
                                <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="30%">
                                    <ItemStyle/>
                                    <ItemTemplate>
			                             <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_SetProductMemberPrice",Eval("RankId"))%>' class="SmallCommonTextButton"><asp:Literal id="lblSetMemberProductPrice" runat="server" Text="<%$Resources:MemberRanks,IDS_Link_ProductPrice %>"></asp:Literal></a>
			                             <asp:LinkButton runat="server" CssClass="SmallCommonTextButton" ID="lkEdit" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit %>"/>
		                                 <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" runat="server" ID="lkDelete" CommandName="Delete"  Text="<%$ Resources:Resources, IDS_Button_Delete %>"/>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_SetProductMemberPrice",Eval("RankId"))%>' class="SmallCommonTextButton"><asp:Literal id="lblSetMemberProductPrice" runat="server" Text="<%$Resources:MemberRanks,IDS_Link_ProductPrice %>"></asp:Literal></a>
			                             <asp:LinkButton runat="server" CssClass="SmallCommonTextButton" ID="lkEdit" CommandName="Update" Text="<%$ Resources:Resources, IDS_Button_Update %>"/>
		                                 <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" runat="server" ID="lkDelete" CommandName="Cancel"  Text="<%$ Resources:Resources, IDS_Button_Cancel %>"/>
                                    </EditItemTemplate>
                                </asp:TemplateField>
			              </Columns>
			           </Hishop:CustomGridView>
			    </div>
			  </div>	

</div>

         <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
                <ul>
                    <li class="addProductTmpt">
                        <asp:Literal ID="lblMemberRankTitle" Text="<%$Resources:MemberRanks, IDS_Label_AddMemberRankTitle%>" runat="server"></asp:Literal>
                    </li>
                </ul>
            </div>  
               <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
                          <tr>
                            <td class="leftTD"><asp:Literal ID="lblRankNameTitle" Text="<%$Resources:MemberRanks,IDS_FormField_RankName%>" runat="server"></asp:Literal>：</td>
                            <td class="rightTD"><asp:TextBox ID="txtRankName" CssClass="input_short" runat="server"></asp:TextBox></td>
                            <td class="rightTD">
                                  <div id="txtRankNameTip" runat="server"></div>
                                    <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtRankName" Description="<%$Resources:MemberRanks,IDS_ErrorMessage_RankName %>" Nullable="false" FocusMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_RankName %>">
                                          <Validators>
                                              <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_RankName%>" LowerBound="1" UpperBound="50" />
                                          </Validators>
                                    </Hishop:ValidateTarget>
                            </td>
                          </tr>
                          <tr>
                            <td class="leftTD"><asp:Literal ID="lblRankPointTitle" Text="<%$Resources:MemberRanks,IDS_FormField_RankPoint%>" runat="server"></asp:Literal>：</td>
                            <td class="rightTD"><asp:TextBox ID="txtPoint" CssClass="input_short" runat="server"></asp:TextBox>&nbsp;<asp:Literal id="lblPointTitle" runat="server" Text="<%$Resources:MemberRanks,IDS_Label_Fen %>"></asp:Literal></td>
                            <td class="rightTD">
                               <div id="txtPointTip" runat="server"></div>
                               <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtPoint" Description="<%$Resources:MemberRanks,IDS_ErrorMessage_Point %>" Nullable="true" FocusMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_Point %>">
                                          <Validators>
                                              <Hishop:InputNumberClientValidator ErrorMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_Point %>" />
                                               <Hishop:NumberRangeClientValidator ErrorMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_Point %>" MinValue="0" />
                                          </Validators>
                               </Hishop:ValidateTarget>
                            </td>
                          </tr>
                          <tr>
                               <td class="leftTD"><asp:Label ID="Label1" Text='<%$Resources:MemberRanks,IDS_DataField_RankPrice%>' runat="server"></asp:Label>=</td>
                               <td class="rightTD">
                                    <Hishop:PriceTypeDropDownList ID="dropPriceType" runat="server"  />
                                    <Hishop:PriceOperationsDownList ID="dropPriceOperateions" runat="server"  />
                                    <asp:TextBox ID="txtValue" CssClass="input_short" Width="90px" runat="server" ></asp:TextBox></td>
                               <td class="rightTD">
                                 <div id="txtValueTip" runat="server"></div>
                                  <Hishop:ValidateTarget ID="ValidateTarget1" ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtValue" Description="<%$ Resources:MemberRanks,IDS_ErrorMessage_RnakPrice  %>" Nullable="false" FocusMessage="<%$ Resources:MemberRanks, IDS_ErrorMessage_RnakPrice %>">
                                     <Validators>
                                         <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:MemberRanks, IDS_ErrorMessage_RnakPrice %>" />
                                         <Hishop:MoneyRangeClientValidator MinValue="0" MaxValue="10000" ErrorMessage="<%$ Resources:MemberRanks, IDS_ErrorMessage_RnakPrice %>" />
                                     </Validators>
                                  </Hishop:ValidateTarget>		
                             </td>
                           </tr>
                          <tr>
                            <td class="leftTD"><asp:Literal ID="lblIsDefault" Text='<%$Resources:MemberRanks,IDS_FormField_IsDefault%>' runat="server"></asp:Literal>：</td>
                            <td class="rightTD"><Hishop:YesNoRadioButtonList id="chkIsDefault" runat="server"></Hishop:YesNoRadioButtonList></td>
                            <td class="rightTD">
                               <label class="msgNormal"><asp:Literal ID="IsDefault" Text="<%$Resources:MemberRanks,IDS_ErrorMessage_IsDefault %>" runat="server"></asp:Literal></label>
                            </td>
                           </tr>
                          <tr>
                            <td class="leftTD"><asp:Literal ID="lblRankDescTitle" Text='<%$Resources:MemberRanks,IDS_FormField_RankDesc%>' runat="server"></asp:Literal></td>
                            <td class="rightTD"><asp:TextBox ID="txtRankDesc" CssClass="input_short" runat="server" TextMode="MultiLine" Height="80px" Width="300px"></asp:TextBox></td>
                            <td class="rightTD">
                               <div id="txtRankDescTip" runat="server"></div>
                               <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtRankDesc" Description="<%$Resources:MemberRanks,IDS_ErrorMessage_RankDesc %>" Nullable="true" FocusMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_RankDesc %>">
                                          <Validators>
                                              <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:MemberRanks,IDS_ErrorMessage_RankDesc%>" LowerBound="1" UpperBound="200" />
                                          </Validators>
                               </Hishop:ValidateTarget>
                            </td>
                          </tr>  
                          <tr>
                           <td class="bottonLeftTD">&nbsp;</td>
                            <td class="rightTD">
                                 <asp:Button ID="btnSubmitMemberRanks" OnClientClick="return PageIsValid();" Text="<%$ Resources:Resources, IDS_Button_Confirm%>" CssClass="inp_L1" runat="server"/>
                                 <asp:Button ID="btnCanel" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1" runat="server"/>
                                 
                            </td>
                            <td class="rightTD">&nbsp;</td>    
                          </tr>                                            
                  </table>   
             </SkinTemplate>
            </Hishop:MemberRanks>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
