﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ReCharge,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ReCharge,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:ReChargeForAgent ID="ReCharge" runat="server">
            <SkinTemplate>


        <div id="updateMsg"><Hishop:StatusMessage id="Status" runat="server" Visible="False"></Hishop:StatusMessage></div>       
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
            <!--用户名-->
            <tr>
                <td class="leftTD"><asp:Literal ID="litUserName" runat="server" Text="<%$ Resources: ReCharge,IDS_FormField_UserName %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <asp:Literal ID="litUserNames" runat="server"></asp:Literal>                  
                </td>              
            </tr>
            <!--可用余额-->
            <tr>
                <td class="leftTD"><asp:Literal ID="litUseableBalances" runat="server" Text="<%$ Resources:AccountSummary,IDS_Literal_UseableBalances%>"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:FormatedMoneyLabelForAdmin ID="lblUseableBalance" runat="server" />               
                </td>
            </tr>            
            <!--充值金额-->    
            <tr>
                <td class="leftTD"><asp:Literal ID="litReCharge" runat="server" Text="<%$ Resources: ReCharge,IDS_FormField_Recharge %>"></asp:Literal>：</td>
                <td class="rightTD"><asp:TextBox ID="txtReCharge" runat="server"></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtReChargeTip" runat="server"></div>
                    <Hishop:ValidateTarget ID="ValidateReCharge"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtReCharge" Description="<%$ Resources:ReCharge, IDS_Message_ReCharge %>" Nullable="false">
                        <Validators>
                            <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:ReCharge, IDS_Message_ReCharge%>" />                          
                        </Validators>
                    </Hishop:ValidateTarget> 
                </td>
            </tr>
            <!--备注-->  
            <tr>
                <td class="leftTD"><asp:Literal ID="litRemark" runat="server" Text="<%$ Resources: ReCharge,IDS_FormField_Remark %>"></asp:Literal>：</td>
                <td class="rightTD"><asp:TextBox Width="300px" Height="110px" ID="txtRemark" runat="server" TextMode="MultiLine"></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtRemarkTip" runat="server"></div>
                    <Hishop:ValidateTarget ID="ValidateRemark"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtRemark" Description="<%$ Resources:ReCharge, IDS_Message_Remark %>" Nullable="true" >               
                    <Validators>
                        <Hishop:InputStringClientValidator LowerBound="0" UpperBound="1000" ErrorMessage="<%$ Resources:ReCharge, IDS_Message_Remark%>" />
                    </Validators>
                    </Hishop:ValidateTarget> 
                </td>
            </tr>
            <!--按钮-->
            <tr>
               <td class="bottonLeftTD">&nbsp;</td> 
               <td class="rightTD">
                <table>
                    <tr>                             
                       <td valign="top">         
                           <asp:Button ID="btnReChargeOK" OnClientClick="return PageIsValid();" runat="server" Text="<%$ Resources:ReCharge, IDS_Button_ReCharge %>"  CssClass="inp_L1"></asp:Button >
                       </td>
                        <td>
                            <div class="return_inp">        
                                <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManageAgents")%>'>
                                <asp:Literal ID="lblReturn" runat="server" Text="<%$ Resources:ReCharge, IDS_Button_Back %>"></asp:Literal></a>
                            </div>
                        </td>
                     </tr>
                 </table>                 
                </td>                                              	              
                <td class="rightTD">&nbsp;</td>                
            </tr> 
       </table> 
            </SkinTemplate>
            </Hishop:ReChargeForAgent>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>