﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:SetProductAgentPrice, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:SetProductAgentPrice, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:SetProductAgentPrice ID="SetProductAgentPrice" runat="server">
            <SkinTemplate>
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdHeaderStyle">
    <asp:Label ID="lblCurrentAgentRank" runat="server" Text="<%$Resources:SetProductAgentPrice,IDS_Label_CurrentAgentRank %>"></asp:Label>：<asp:Label
        ID="lblAgentRank" runat="server"></asp:Label>
</div>
<Hishop:ProductSearch ID="productSearch" runat="server" >
<SkinTemplate>
<fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_litSelectQuery %>"></asp:Literal></legend>
    <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSearchText" runat="server" Width="110" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox></td>
             <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblSKU" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSKU %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSKU" Width="110" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblBrandCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblBrandCategory %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:BrandCategoriesDropDownList ID="dropBrandCategories" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblPageSize %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
            </td>
            <td class="searchTableControlTD">
                <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>"
                    CssClass="inp_L1" /></td>
            <td>
            </td>
        </tr>
    </table>
</fieldset>
</SkinTemplate>
</Hishop:ProductSearch>
<script type="text/javascript">
    function validat() {
        var txtValue = $("#SetProductAgentPrice_txtValue").val();
        reg=/^[-\+]?\d+(\.\d+)?$/;
        if(!reg.test(txtValue)){ 
            alert("请输入确认的实数类型");
            return false;
        }
    }
</script>
<div class="PageTitleArea">
    <div style="color:#0066CC;font-size:12px;">
       <strong> 批量调整代理等级价格：</strong>
    </div>
    <div style="width: 80%;">
        <asp:Label ID="Label1" Text='<%$Resources:AgentialRanks,IDS_DataField_RankPrice%>' runat="server"></asp:Label>=
        <Hishop:PriceTypeDropDownList ID="dropPriceType" runat="server" />
        <Hishop:PriceOperationsDownList ID="dropPriceOperateions" runat="server"  />
        <asp:TextBox ID="txtValue" CssClass="input_short" Width="90px" runat="server" ></asp:TextBox>
        <asp:Button ID="btnSaveRank" runat="server" OnClientClick="return validat();"  CssClass="inp_L1" Text="确认调整" />
        批量调整代理等级价格会自动覆盖手工设置的商品代理价
    </div>
</div>
<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="_return"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManageAgentialRank")%>'>
                <asp:Literal ID="lblReturn" runat="server" Text="<%$ Resources:SetProductAgentPrice, IDS_Button_Back %>"></asp:Literal></a>
                <li class="spirtLines">|</li>
                <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                    <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
                <li class="spirtLines">|</li>
                <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                    <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
        </ul>
    </div>
            <Hishop:CustomGridView ID="grdProduct" runat="server" AutoGenerateColumns="false"
                ShowHeader="true" DataKeyNames="ProductId" CssClass="GridViewStyle" GridLines="None"
                AllowSorting="true" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                <Columns>
                    <Hishop:CheckBoxColumn />
                    <asp:BoundField HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_ProductName %>" DataField="ProductName" ItemStyle-Width="150" />
                    <asp:BoundField HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_SKU %>" DataField="SKU" ItemStyle-Width="150" />
                    <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_CostPrice %>"
                        DataField="CostPrice">
                    </Hishop:MoneyColumnForAdmin>
                    <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_MarketPrice %>"
                        DataField="MarketPrice">
                    </Hishop:MoneyColumnForAdmin>
                    <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_SalePrice %>"
                        DataField="SalePrice">
                    </Hishop:MoneyColumnForAdmin>
                    <asp:TemplateField HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_AgentPrice %>">
                        <itemtemplate>
                             <asp:TextBox ID="txtPrice" runat="server" Columns="10" MaxLength="15" Text='<%# Eval("RankPrice","{0:F2}") %>' OnChange="javascript:var c=this.parentNode.parentNode.getElementsByTagName('td').item(0).getElementsByTagName('input').item(0);c.checked=true;CheckChanged();" ></asp:TextBox>
                        </itemtemplate>
                    </asp:TemplateField>                  
                    <asp:TemplateField HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_Profit %>">
                        <itemtemplate>
                            <Hishop:FormatedMoneyLabelForAdmin ID="lblMoney" runat="server" Money='<%# Eval("Profit") %>' />
                        </itemtemplate>
                    </asp:TemplateField>
                </Columns>
            </Hishop:CustomGridView>
            <div class="grdGroupTabhead">
                <UI:Pager runat="server" ListToPaging="grdProduct" ID="pager" />
            </div>
</div>
    <table>
        <tr>
            <td valign="top" style="padding-left:50px">
                <asp:Button ID="btnOk" CssClass="inp_L1" runat="server" Text="<%$ Resources:SetProductMemberPrice,IDS_Button_Settings %>"/>
            </td>
            <td><div class="return_inp"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManageAgentialRank")%>'>返回</a></div></td>
        </tr>
    </table>
            </SkinTemplate>
            </Hishop:SetProductAgentPrice>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>