﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:SetProductMemberPriceForAgent, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:SetProductMemberPriceForAgent, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:SetProductMemberPriceForAgent ID="SetProductMemberPriceForAgent" runat="server">
            <SkinTemplate>
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdHeaderStyle">    
    <asp:Label ID="lblCurrentMemberRank" runat="server" Text="<%$Resources:SetProductMemberPriceForAgent,IDS_Label_CurrentMemberRank %>"></asp:Label>：<asp:Label ID="lblMemberRank" runat="server"></asp:Label>
</div>
    <Hishop:ProductSearch ID="productSearch" runat="server" >
    <SkinTemplate>
<fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_litSelectQuery %>"></asp:Literal></legend>
    <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSearchText" runat="server" Width="110" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox></td>
             <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblSKU" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSKU %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSKU" Width="110" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr>

            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblBrandCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblBrandCategory %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:BrandCategoriesDropDownList ID="dropBrandCategories" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblPageSize %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
            </td>
            <td class="searchTableControlTD">
                <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>"
                    CssClass="inp_L1" /></td>
            <td>
            </td>
        </tr>
    </table>
</fieldset>
    </SkinTemplate>
    </Hishop:ProductSearch>
<div class="grdGroupFormList">
            <asp:GridView ID="grdProduct" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                DataKeyNames="ProductId" CssClass="GridViewStyle" GridLines="None" AllowSorting="true"
                RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                <Columns>                    
                    <asp:BoundField HeaderText="<%$ Resources:SetProductMemberPriceForAgent,IDS_Header_ProductName %>"
                        DataField="ProductName" ItemStyle-Width="150" />                    
                    <asp:BoundField HeaderText="<%$ Resources:SetProductAgentPrice,IDS_Header_SKU %>" DataField="SKU" ItemStyle-Width="150" />
                    <asp:TemplateField HeaderText="<%$ Resources:SetProductMemberPriceForAgent,IDS_Header_CostPrice %>">
                        <ItemTemplate>
                            <Hishop:FormatedMoneyLabelForAdmin ID="fmlblCostPrice" runat="server" Money='<%# Eval("AgnetRankPrice") %>' >
                            </Hishop:FormatedMoneyLabelForAdmin>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:SetProductMemberPriceForAgent,IDS_Header_MarketPrice %>"  DataField="MarketPrice" ></Hishop:MoneyColumnForAdmin>
                    <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:SetProductMemberPriceForAgent,IDS_Header_SalePrice %>" DataField ="SalePrice" ></Hishop:MoneyColumnForAdmin>                
                    <asp:TemplateField HeaderText="<%$ Resources:SetProductMemberPriceForAgent,IDS_Header_MemberPrice %>">
                        <itemtemplate>
                            <Hishop:FormatedMoneyLabelForAdmin ID="lblMoney" runat="server"  Money='<%# Eval("RankPrice") %>'></Hishop:FormatedMoneyLabelForAdmin>
                        </itemtemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Resources:SetProductMemberPriceForAgent,IDS_Header_Profit %>">
                        <itemtemplate>
                         <Hishop:FormatedMoneyLabelForAdmin ID="lblMoney" runat="server" Money='<%# Eval("Profit") %>' />
                        </itemtemplate>
                    </asp:TemplateField>
               </Columns>
            </asp:GridView>
            <div class="grdGroupTabhead">
               <UI:Pager runat="server" ListToPaging="grdProduct" ID="pager" />
            </div>
</div>
            </SkinTemplate>
            </Hishop:SetProductMemberPriceForAgent>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
