﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="FCKeditorV2" Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" media="screen" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" media="screen" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="litManagerTop" runat="server" Text="<%$ Resources:ProductForm, IDS_PageTitle %>" ></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="litManagerDisciption" runat="server" Text="<%$ Resources:ProductForm, IDS_PageDescription %>" ></asp:Literal>
            </div>
        </div>
        
        <Hishop:AddProduct runat="server" ID="AddProduct">
        <SkinTemplate>
            <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
            <UI:TabStrip runat="server" ID="tabs" Width="100%">
    <Tabs>
    <UI:TabStripTab ID="tabBaseInfo" runat="server" Title="基本信息">
        <table style="width: 60%" cellspacing="0" cellpadding="0" class="formTableList">
                <tr>
                    <td class="leftTD" style="width:130px;">商品分类：</td>
                    <td class="rightTD" ><Hishop:ProductCategoriesDropDownList runat="server" onchange="CategoryChanged(this.value);" ID="dropCategories" /></td>
                    <td class="leftTD" style="width:70px;">商品类型：</td>
                    <td class="rightTD"><Hishop:ProductTypeDownList runat="server" onchange="ProductTypeChanged(this.value);" ID="dropProductTypes" /></td>
                </tr>
            </table>
            
            <table cellspacing="0" cellpadding="0">
                <tr>
                    <td>
                        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    排序：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="NumberText" runat="server" ID="txtDisplaySequence" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_ProductName %>" />：</td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="SingleText" runat="server" ID="txtProductName" Width="280px" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_SKU %>" />：</td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="SingleText" runat="server" ID="txtSKU" /></td>
                            </tr>
                            <tr runat="server" id="tblrCategorey">
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_BrandCategory %>" />：
                                </td>
                                <td class="rightTD">
                                    <Hishop:BrandCategoriesDropDownList runat="server" ID="dropBrandCategories" />
                                </td>
                            </tr>
                            <tr id="tblrSuppliers" runat="server">
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Supplier %>" />：
                                </td>
                                <td class="rightTD">
                                    <Hishop:SupplierDropDownList runat="server" ID="dropSuppliers" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Unit %>" />：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="NumberText" runat="server" ID="txtUnit" />
                                </td>
                            </tr>
                            <tr runat="server" id="tblrWeight">
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Weight %>" />：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="NumberText" runat="server" ID="txtWeight" /><span class="RequiredFieldTag">(
                                        <asp:Literal ID="lblKe" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_lblKe %>"></asp:Literal>)</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal18" runat="server" Text="是否上架销售" />：
                                </td>
                                <td class="rightTD">
                                    <UI:YesNoRadioButtonList ID="radlPublishOptions" runat="server" RepeatDirection="Horizontal" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal15" runat="server" Text="商品栏目设置" />：
                                </td>
                                <td class="rightTD">
                                    <Hishop:SaleOptionCheckBoxList RepeatDirection="Horizontal" runat="server" ID="chklSaleOptions" />
                                </td>
                            </tr>
                        </table>
                        
                        <UI:CallBack id="cbAttributes" CacheContent="false" PostState="true" runat="server">
                            <Content>
                                <Hishop:AttributeTable runat="server" ID="tblAttributes" TableStyle="width: 100%" CssClass="formTableList" TitleCellCssClass="leftTD" TitleCellStyle="width:130px;" ValueCellCssClass="rightTD" />
                            </Content>
                        </UI:CallBack>
                        
                        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal16" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_CostPrice %>" />：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="NumberText" runat="server" ID="txtCostPrice" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal17" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_MarketPrice %>" />：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="NumberText" runat="server" ID="txtMarketPrice" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="litCommonPrice" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_CommonPrice %>" />：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox CssClass="NumberText" runat="server" ID="txtSalePrice" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    <asp:Literal ID="Literal21" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Stock %>" />：</td>
                                <td class="rightTD">
                                    <asp:TextBox runat="server" CssClass="NumberText" ID="txtStock" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    每次最大购买数量：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox runat="server" CssClass="NumberText" ID="txtQuantityLimit" />
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD" style="width:130px;">
                                    每次最小购买数量：
                                </td>
                                <td class="rightTD">
                                    <asp:TextBox runat="server" CssClass="NumberText" ID="txtMinQuantity" />
                                </td>
                            </tr>
                        </table>
                    </td>
                     <td style="width:10px;border-right:solid 1px #eeeeee;"></td>
                     <td style="vertical-align:top; padding-left:10px; padding-top:10px;">
                        <UI:CallBack id="cbUpload" CacheContent="false" PostState="true" runat="server">
                            <Content>
                                <UI:ImageUpload 
                                ID="uploader" PreviewBoxStyle="width:180px;height:180px;border:solid 2px #999999;text-align:center;vertical-align:baseline;padding:10px 10px 10px 10px" 
                                runat="server" PostUrl="admin/upload.aspx" PreviewBoxWidth="170px"  PreviewBoxHeight="170px"
                                 ListItemHeight="40px" ListItemWidth="40px"
                                ListItemStyle="width:45px;height:45px;border:solid 1px #EEEEEE;text-align:center;vertical-align:baseline;padding:5px 5px 5px 5px"
                                />
                            </Content>
                        </UI:CallBack>
                        <div style="width:180px;text-align:center;padding-top:5px;">
                            <a href="javascript:void(0);" style="background-image:url(../images/btn_upload.gif);background-repeat: no-repeat; background-position:left top;text-align:center;" class="files" id="fileContents"></a>
                            <img id="uploadProcess" style="display: none;" src="../images/loading.gif" />
                        </div>
                     </td>
                </tr>
            </table>
    </UI:TabStripTab>
    <UI:TabStripTab ID="tabSKU" runat="server" Title="规格">    		
		    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
		        <tr>
                        <td class="leftTD" style="width:130px;">
                            商品规格：
                        </td>
                        <td class="rightTD">
                            <UI:CallBack id="cbSkus"  CacheContent="false" PostState="true" Debug="false" runat="server">
                                <Content>
                                    <UI:SKUTable runat="server" OnClientAddClick="OpenAddSKUField();" ID="tblSkus" />
                                </Content>
                            </UI:CallBack>
                        </td>
                    </tr>
            </table>
    </UI:TabStripTab>		
    <UI:TabStripTab ID="tabDes" runat="server" Title="商品描述">        		
		    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                <tr>
                        <td class="leftTD" style="width:130px;">
                            <asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Description %>" />：
                        </td>
                        <td class="rightTD">
                            <asp:TextBox runat="server" ID="txtDescription" TextMode="MultiLine" Width="280px"
                                Height="100" />
                        </td>
                        <td class="rightTD">
                            <div id="txtDescriptionTip" runat="server">
                            </div>
                            <Hishop:ValidateTarget ID="ValidateTargetDescription" ContainerId="ValidatorContainer"
                                runat="server" Nullable="true" ControlToValidate="txtDescription" Description="<%$ Resources:ProductView, IDS_FormField_DescriptionHelp %>">
                                <Validators>
                                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:ProductView, IDS_FormField_DescriptionHelp %>"
                                        UpperBound="1000" />
                                </Validators>
                            </Hishop:ValidateTarget>
                        </td>
                    </tr>
                    <tr>
                        <td class="leftTD" style="width:130px;">
                            <asp:Literal ID="Literal10" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_LongDescription %>" />：
                        </td>
                        <td class="rightTD" colspan="2">
                            <FCKeditorV2:FCKeditor Height="400px" Width="99%" runat="server" ID="fckLongDescription"></FCKeditorV2:FCKeditor>
                        </td>
                    </tr>
                </table>
    </UI:TabStripTab>		
	<UI:TabStripTab ID="tabSearch" runat="server" Title="搜索优化">        		
		    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                <tr>
                    <td class="leftTD" style="width:130px;">
                        <asp:Literal ID="Literal11" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Title %>" />：<div>TITLE</div>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox CssClass="SingleText" runat="server" ID="txtTitle" Width="280px" />
                    </td>
                    <td class="rightTD">
                        <div id="txtTitleTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" Nullable="true" ContainerId="ValidatorContainer"
                            ControlToValidate="txtTitle" Description="<%$ Resources:ProductView, IDS_FormField_TitleHelp %>">
                            <Validators>
                                <Hishop:InputStringClientValidator UpperBound="500" ErrorMessage="<%$ Resources:ProductView, IDS_FormField_TitleHelp %>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <tr>
                    <td class="leftTD" style="width:130px;">
                        <asp:Literal ID="Literal12" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_MetaDescription %>" />：<div>META_DESCRIPTION</div>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox CssClass="SingleText" runat="server" ID="txtMetaDescription" Width="280px" />
                    </td>
                    <td class="rightTD">
                        <div id="txtMetaDescriptionTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateTargetMetaDescription" runat="server" Nullable="true"
                            ContainerId="ValidatorContainer" ControlToValidate="txtMetaDescription" Description="<%$ Resources:ProductView, IDS_FormField_MetaDescriptionHelp %>">
                            <Validators>
                                <Hishop:InputStringClientValidator UpperBound="500" ErrorMessage="<%$ Resources:ProductView, IDS_FormField_MetaDescriptionHelp %>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <tr>
                    <td class="leftTD" style="width:130px;">
                        <asp:Literal ID="Literal13" runat="server" Text="<%$ Resources:ProductView, IDS_FormField_Keywords %>" />：<div>META_KEYWORDS</div>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox CssClass="SingleText" runat="server" ID="txtMetaKeywords" Width="280px" />
                    </td>
                    <td class="rightTD">
                        <div id="txtMetaKeywordsTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateTargetMetaKeyword" runat="server" Nullable="true"
                            ContainerId="ValidatorContainer" ControlToValidate="txtMetaKeywords" Description="<%$ Resources:ProductView, IDS_FormField_KeywordHelp %>">
                            <Validators>
                                <Hishop:InputStringClientValidator UpperBound="500" ErrorMessage="<%$ Resources:ProductView, IDS_FormField_KeywordHelp %>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
            </table>
    </UI:TabStripTab>
	<UI:TabStripTab ID="tabAccessories" runat="server" Title="配件"> 
		    <script type="text/javascript">
		        function ResetPager(sender, eventArgs) {
		            CB_Pager.callback();
		        }

		        function showAccessoriesDialog() {
		            if (dialogAccessories.get_isShowing()) {
		                dialogAccessories.Close();
		            }
		            else {
		                dialogAccessories.Show();
		            }
		        }
            </script>
    		<table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
    		    <tr>
                    <td class="leftTD" style="width:130px;">
                        <img src="../images/jiaoyiIcon.gif" alt="" /><asp:Literal ID="litAccessories" runat="server" Text="配件"></asp:Literal>：</td>
                    <td class="rightTD" colspan="2">
                        <a  style="color:Blue" onclick="showAccessoriesDialog();" href="#e"><asp:Literal ID="litCheckProducts" runat="server" Text="新增配件" /></a>
                     </td>
                </tr>
             </table>
             <table style="width: 100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td  style="padding-left:25px"><asp:Literal ID="litCheckedProducts" runat="server" Text="已有配件列表" /></td>
                </tr>
                <tr>
                    <td style="padding-left:25px">
                    <asp:GridView ID="grdAccessories" runat="server" AutoGenerateColumns="False" DataKeyNames="RealSKU" Width="100%" CssClass="GridViewStyle" GridLines="None" ShowHeader="true">
                      <Columns>         
                          <asp:TemplateField HeaderText="商品名称">
                                <ItemTemplate>
                                    <asp:Label ID="lblAccessoriesProductId" runat="server" Text='<%#Eval("ProductId") %>' Visible="false" />
                                    <Hishop:SubStringLabel ID="lblPromoteSaleProductName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("ProductName") %>' Text='<%#Eval("ProductName") %>' runat="server"></Hishop:SubStringLabel>
                                    <asp:Label ID="lblAttributeValues" runat="server" Text='<%#Eval("AttributeValues") %>' />
                                </ItemTemplate>
                           </asp:TemplateField>
                           <asp:BoundField DataField="RealSKU" HeaderText="货号"  />
                           <asp:BoundField DataField="RealStock" HeaderText="库存数量"  />
                            <Hishop:MoneyColumnForAdmin DataField="CostPrice" HeaderText="成本价"  />
                            <Hishop:MoneyColumnForAdmin DataField="RealPrice" HeaderText="一口价"  />
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                <ItemTemplate>
                                    <Hishop:DeleteImageLinkButton ID="lkbDelete" runat="server"  CommandName="Delete" Text="移除" />
                                </ItemTemplate>
                           </asp:TemplateField>
                         </Columns>
                         <RowStyle CssClass="grdrow"/>
                         <HeaderStyle CssClass="GridViewHeaderStyle"/>
                    </asp:GridView>
                    
                    </td>
                </tr>
    		</table>
   </UI:TabStripTab>
	<UI:TabStripTab ID="tabRelates" runat="server" Title="相关商品"> 
            <script type="text/javascript">
                function ResetPagerRelatedProducts(sender, eventArgs) {
                    CB_Pager.callback();
                }

                function showRelatedProductDialog() {
                    if (dialogRelatedProducts.get_isShowing()) {
                        dialogRelatedProducts.Close();
                    }
                    else {
                        dialogRelatedProducts.Show();
                    }
                }
            </script>
    		<table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
    		    <tr>
                    <td class="leftTD" style="width:130px;">
                        <img src="../images/jiaoyiIcon.gif" alt="" /><asp:Literal ID="Literal1" runat="server" Text="相关商品"></asp:Literal>：</td>
                    <td class="rightTD" colspan="2">
                        <a  style="color:Blue" onclick="showRelatedProductDialog();" href="#f" ><asp:Literal ID="Literal9" runat="server" Text="新增相关商品" /></a>
                     </td>
                </tr>
             </table>
             <table style="width: 100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td  style="padding-left:25px"><asp:Literal ID="Literal14" runat="server" Text="已添加的相关商品" /></td>
                </tr>
                <tr>
                    <td style="padding-left:25px">
                    <asp:GridView ID="grdRelateds" runat="server" AutoGenerateColumns="False" DataKeyNames="ProductId" Width="100%" CssClass="GridViewStyle" GridLines="None" ShowHeader="true">
                      <Columns>         
                          <asp:TemplateField HeaderText="商品名称">
                                <ItemTemplate>
                                    <Hishop:SubStringLabel ID="lblPromoteSaleProductName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("ProductName") %>' Text='<%#Eval("ProductName") %>' runat="server"></Hishop:SubStringLabel>
                                </ItemTemplate>
                           </asp:TemplateField>
                           <asp:BoundField DataField="SKU" HeaderText="货号"  />
                           <asp:BoundField DataField="Stock" HeaderText="库存数量"  />
                            <Hishop:MoneyColumnForAdmin DataField="CostPrice" HeaderText="成本价"  />
                            <Hishop:MoneyColumnForAdmin DataField="SalePrice" HeaderText="一口价"  />
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                <ItemTemplate>
                                    <Hishop:DeleteImageLinkButton ID="lkbDelete" runat="server"  CommandName="Delete" Text="移除" />
                                </ItemTemplate>
                           </asp:TemplateField>
                         </Columns>
                         <RowStyle CssClass="grdrow"/>
                         <HeaderStyle CssClass="GridViewHeaderStyle"/>
                    </asp:GridView>
                    
                    </td>
                </tr>
    		</table>
    </UI:TabStripTab>	
   </Tabs>
</UI:TabStrip>	
            <script type="text/javascript">
                var currentTypeId = "";
                var resetFlag = false;

                function CategoryChanged(categoryId) {
                    $.ajax({
                    url: "ProductHandler.aspx?action=a1&categoryId=" + categoryId + "&timestamp=" + new Date().getTime(),
                        type: 'GET',
                        dataType: 'text',
                        timeout: 10000,
                        success: function(typeId) {
                            if (typeId == "0") typeId = "";
                            if (currentTypeId != typeId) {
                                if (currentTypeId == "" || confirm("是否自动切换到与所选分类关联的商品类型?\r\n切换商品类型会丢失当前已经编辑但是还没有保存的商品规格和属性数据")) {
                                    resetFlag = true;
                                    $("#AddProduct_dropProductTypes").val(typeId);
                                    ProductTypeChanged(typeId);
                                }
                            }
                        }
                    });
                }

                function ProductTypeChanged(typeId) {
                    if (currentTypeId == typeId)
                        return;

                    if (!resetFlag) {
                        if (!confirm("切换商品类型会丢失当前已经编辑但是还没有保存的商品规格和属性数据，确定要切换吗?")) {
                            $("#AddProduct_dropProductTypes").val(currentTypeId);
                            return;
                        }
                    }

                    currentTypeId = typeId;
                    resetFlag = false;

                    tblAttributes_Reset(typeId);
                    tblSkus_Close(false);

                    RebindFields(typeId);
                }

                function RebindFields(typeId) {
                    $("#fieldlist").empty();
                    $("#optionlist").empty();
                    
                    if (typeId) {
                        $.ajax({
                            url: "ProductHandler.aspx?action=a2&typeId=" + typeId + "&timestamp=" + new Date().getTime(),
                            type: 'GET',
                            dataType: 'json',
                            timeout: 10000,
                            success: function(resultData) {
                                $.each(resultData.Fields, function(i, item) {
                                    var itemContainer = $("<div><span style=\"cursor:pointer;display:block;\" onclick=\"selectField(this);\" value=\"" + item.AttributeId + "\" options=\"" + item.Options + "\">" + item.AttributeName + "</span></div>");
                                    $("#fieldlist").append(itemContainer);
                                });
                            }
                        });
                    }
                }

                function selectField(selectedField) {
                    $("#optionlist").empty();
                    $("#txtFieldName").val(selectedField.innerHTML);

                    var options = selectedField.attributes["options"].nodeValue.split(",");
                    $.each(options, function(i, option) {
                        if (option.length > 0) {
                            var optionContainer = $("<div><span style=\"cursor:pointer;display:block;\" onclick=\"selectOption(this);\">" + option + "</span></div>");
                            $("#optionlist").append(optionContainer);
                        }
                    });
                }

                function selectOption(selectedOption) {
                    var allOptions = "," + $("#txtOptions").val().replace(new RegExp("\r\n", "gm"), ",");
                    allOptions = allOptions.replace(new RegExp("\n", "gm"), ",");
                    
                    if (allOptions.indexOf("," + selectedOption.innerHTML + ",") < 0) {
                        $("#txtOptions").val($("#txtOptions").val() + selectedOption.innerHTML + "\r\n");
                    }
                }

                function addField() {
                    if ($("#txtFieldName").val().length == 0 || $("#txtOptions").val().length == 0) {
                        dlgSpecs.Close();
                        return;
                    }

                    var options = $("#txtOptions").val().replace(new RegExp("\r\n", "gm"), ",");
                    options = options.replace(new RegExp("\n", "gm"), ",");
                    
                    tblSkus_AddField($("#txtFieldName").val(), options);
                    dlgSpecs.Close();

                    $("#txtFieldName").val("");
                    $("#txtOptions").val("");
                }

                function OpenAddSKUField() {
                    dlgSpecs.Show();
                }
            </script>
            
            <UI:Dialog ID="dlgSpecs" Title="新增规格" Modal="true" ShowTransition="Pixelate" CloseTransition="Pixelate" AnimationDuration="200" AllowDrag="true" AllowResize="true" Alignment="MiddleCentre" runat="server" Width="510">
                <Content>
                    <table style="width: 100%" cellspacing="0" cellpadding="5">
                        <tr>
                            <td style="width:50%;vertical-align:top;">
                                <div style="background-color:#eeeeee; border:solid 1px #999999; padding:3px 3px 3px 3px;">
                                    <b>已有规格</b>
                                </div>
                                <div id="fieldlist" style="border:solid 1px #999999; padding:3px 3px 3px 3px;height:100%;">
                                </div>
                            </td>
                            <td style="width:50%;vertical-align:top;">
                                <div style="background-color:#eeeeee; border:solid 1px #999999;padding:3px 3px 3px 3px;">
                                   <b>规格可选值</b>
                                </div>
                                <div id="optionlist" style="border:solid 1px #999999; padding:3px 3px 3px 3px;height:100%;">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:center" colspan="2">
                                <table style="width:100%;">
                                    <tr>
                                        <td></td>
                                        <td style="text-align:left">您可以从上面的列表中选择，也可以手工输入</td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right;width:25%;">规格名称：</td>
                                        <td style="width:60%;"><input type="text" id="txtFieldName" style="width:100%;" /></td>
                                        <td style="width:15%;text-align:left;"></td>
                                    </tr>
                                    <tr>
                                        <td style="text-align:right;width:25%;">可选值：<br/>一行代表一个可选值</td>
                                        <td style="width:60%;"><textarea rows="5" style="width:100%;" id="txtOptions"></textarea></td>
                                        <td style="width:15%;text-align:left;"></td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:center; background-color:#eeeeee; border-top:solid 1px #999999" colspan="2">
                                <input type="button" value="确 定" onclick="addField();" />
                                <input type="button" value="取 消" onclick="dlgSpecs.Close();" />
                            </td>
                        </tr>
                    </table>
                </Content>
            </UI:Dialog>
            
            <UI:Dialog Modal="true" ShowTransition="Pixelate" CloseTransition="Pixelate" AnimationDuration="200" AllowDrag="true" AllowResize="true" Alignment="MiddleCentre" runat="server" Width="600" Title="从下面的商品列表中选择配件"
                        ID="dialogAccessories" runat="server" >
                        <Content>
                            <table style="width:100%">
                                <tr>
                                    <td class="searchTableLeftTD"><nobr><asp:Label ID="lblProductCategory" runat="server" Text="商品分类"></asp:Label>：</nobr></td>
                                    <td class="searchTableControlTD" colspan="2"><nobr><Hishop:ProductCategoriesDropDownList ID="dropAccessoriesCategories" runat="server" /> </nobr></td>
                                    <td class="searchTableLeftTD"><nobr><asp:Label ID="lblSearchText" runat="server" Text="商品名称"></asp:Label>：</nobr></td>
                                    <td class="searchTableControlTD"><asp:TextBox ID="txtSearchText" runat="server" Width="150" ></asp:TextBox></td>
                                    <td align="left"><input type="button"  value="查询" onclick="grdAccessoriesProducts_ReBindData();"  /></td>
                                </tr>
                                <tr>
                                   <td colspan="5">
                                    <UI:CallBack id="CB_AccessoriesProducts" ClientSideOnCallbackComplete="ResetPager" CacheContent="false" runat="server" PostState="true" Debug="false">
                                      <Content>
                                       <UI:Grid ID="grdAccessoriesProducts" runat="server" AutoGenerateColumns="False"  CallBackDataKey="RealSKU"
                                            CellPadding="4" GridLines="None" AllowSorting="false" 
                                            Width="100%" RunningMode="Callback" EnableCheckBox="true" >
                                            <Columns>       
                                                   <asp:BoundField DataField="RealSKU" HeaderText="货号"  />
                                                   <asp:BoundField DataField="ProductName" HeaderText="商品名称"  />
                                                   <asp:BoundField DataField="AttributeValues" HeaderText="规格值"  />
                                                   <asp:BoundField DataField="RealStock" HeaderText="库存数量"  />
                                                   <Hishop:MoneyColumnForAdmin DataField="CostPrice" HeaderText="成本价"  />
                                                    <Hishop:MoneyColumnForAdmin DataField="RealPrice" HeaderText="一口价"  />                                        
                                            </Columns>
                                            
                                       </UI:Grid>
                                      </Content>
                                   </UI:CallBack>
                                    <div style="text-align:left">
                                        <UI:CallBack id="CB_Pager" CacheContent="false" PostState="true" Debug="false" runat="server">
                                        <Content>
                                            <UI:Pager runat="server" ListToPaging="grdAccessoriesProducts" ListToCallBackID="CB_AccessoriesProducts" RunningMode="Callback" ID="pager" />
                                        </Content>
                                        </UI:CallBack>
                                    </div>
                                   </td>
                                </tr>
                             </table>
                             <div class="footer">
                               <asp:Button ID="btnAddAccessories" runat="server" Text="<%$ Resources:Resources, IDS_Button_Confirm %>" CssClass="inp_L1" />
                            </div>
                            
                        </Content>
                    </UI:Dialog>
                    
            <UI:Dialog Modal="true" ShowTransition="Pixelate" CloseTransition="Pixelate" AnimationDuration="200" AllowDrag="true" AllowResize="true" Alignment="MiddleCentre" runat="server" Width="600" Title="从已有的商品中选择相关商品"
                        ID="dialogRelatedProducts" runat="server" >
                        <Content>
                            <table style="width:100%">
                                <tr>
                                    <td class="searchTableLeftTD"><nobr><asp:Label ID="Label1" runat="server" Text="商品分类"></asp:Label>：</nobr></td>
                                    <td class="searchTableControlTD" colspan="2"><nobr><Hishop:ProductCategoriesDropDownList ID="dropRdlatedCategories" runat="server" /> </nobr></td>
                                    <td class="searchTableLeftTD"><nobr><asp:Label ID="Label2" runat="server" Text="商品名称"></asp:Label>：</nobr></td>
                                    <td class="searchTableControlTD"><asp:TextBox ID="txtRelateProductName" runat="server" Width="150" ></asp:TextBox></td>
                                    <td align="left"><input type="button"  value="查询" onclick="grdRelatedProducts_ReBindData();"  /></td>
                                </tr>
                                <tr>
                                   <td colspan="5">
                                    <UI:CallBack id="CB_grdRelatedProducts" ClientSideOnCallbackComplete="ResetPagerRelatedProducts" CacheContent="false" runat="server" PostState="true" Debug="false">
                                      <Content>
                                       <UI:Grid ID="grdRelatedProducts" runat="server" AutoGenerateColumns="False"  CallBackDataKey="ProductId"
                                            CellPadding="4"  GridLines="None" AllowSorting="false" 
                                            Width="100%" RunningMode="Callback" EnableCheckBox="true" >
                                            <Columns>          
                                                   <asp:BoundField DataField="SKU" HeaderText="货号"  />
                                                   <asp:BoundField DataField="ProductName" HeaderText="商品名称"  />
                                                   <asp:BoundField DataField="Stock" HeaderText="库存数量"  />
                                                   <Hishop:MoneyColumnForAdmin DataField="CostPrice" HeaderText="成本价"  />
                                                    <Hishop:MoneyColumnForAdmin DataField="SalePrice" HeaderText="一口价"  />                                        
                                            </Columns>
                                            
                                       </UI:Grid>
                                      </Content>
                                   </UI:CallBack>
                                    <div style="text-align:left">
                                        <UI:CallBack id="CB_pagerRelatedProducts" CacheContent="false" PostState="true" Debug="false" runat="server">
                                        <Content>
                                            <UI:Pager runat="server" ListToPaging="grdRelatedProducts" ListToCallBackID="CB_grdRelatedProducts" RunningMode="Callback" ID="pagerRelatedProducts" />
                                        </Content>
                                        </UI:CallBack>
                                    </div>
                                   </td>
                                </tr>
                             </table>
                             <div class="footer">
                               <asp:Button ID="btnAddRelateProducts" runat="server" Text="<%$ Resources:Resources, IDS_Button_Confirm %>" CssClass="inp_L1" />
                            </div>
                            
                        </Content>
                    </UI:Dialog>
                                 
            <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
		        <tr>
                        <td style="width:130px;">
                        </td>
                        <td class="rightTD">
                            <asp:Button runat="server" ID="btnAdd" Text="<%$ Resources:ProductView, IDS_Button_SubmitAdd %>" CssClass="inp_L1" OnClientClick="return SubmitAdd();" />
                        </td>
                    </tr>
            </table>
            
            <script type="text/javascript">
                function SubmitAdd() {
                    if ($("#AddProduct_dropCategories").val().length == 0) {
                        alert("请选择一个商品分类");
                        return false;
                    }

                    return PageIsValid();
                }
            </script>
            
        </SkinTemplate>
        </Hishop:AddProduct>
        
        <br />
        <div style="text-align: center">
            <hr style="width: 500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>