﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:EditProductCategory,IDS_PageTitle %>"></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:EditProductCategory,IDS_PageDesc %>"></asp:Literal>
            </div>
        </div>
        <Hishop:EditProductCategory ID="EditProductCategory" runat="server">
            <SkinTemplate>
                <!-- 操作提示 -->
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <div class="grdGroupFormList">
                    <!-------- ProductCategoryView of control -------->
                    <Hishop:ProductCategoryView ID="editProductCategory" runat="server">
                        <SkinTemplate>
                            <table style="width: 100%;" cellspacing="0" cellpadding="0" class="formTableList"
                                id="addItemsTable">
                                <tr>
                                    <td class="leftTD">
                                        <asp:Literal ID="lblCategoryName" Text='<%$Resources:ProductCategoryView,IDS_FormField_CategoryName %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <asp:TextBox ID="txtCategoryName" runat="server" CssClass="input_short"></asp:TextBox>
                                    </td>
                                    <td class="rightTD">
                                        <div id="txtCategoryNameTip" runat="server">
                                        </div>
                                        <Hishop:ValidateTarget runat="server" ControlToValidate="txtCategoryName" ContainerId="ValidatorContainer"
                                            Nullable="false" Description="<%$Resources:ProductCategoryView,IDS_ErrorMessage_CategoryName_ErrorFormat %>"
                                            FocusMessage="<%$Resources:ProductCategoryView,IDS_ErrorMessage_CategoryName_ErrorFormat %>">
                                            <Validators>
                                                <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:ProductCategoryView,IDS_ErrorMessage_CategoryName_ErrorFormat %>"
                                                    LowerBound="1" UpperBound="100" />
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <tr runat="server" id="tblrParent">
                                    <td class="leftTD">
                                        <asp:Literal ID="lblParentCategory" Text='<%$Resources:ProductCategoryView,IDS_FormField_ParentCategory %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" CssClass="inputstyle" />
                                    </td>
                                    <td class="rightTD">
                                        <label class="msgNormal">
                                            <asp:Literal ID="lblParentArticleCategory" Text="<%$Resources:ProductCategoryView,IDS_ErrorMessage_ParentCategory %>"
                                                runat="server"></asp:Literal></label>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="leftTD">
                                        <asp:Literal ID="Literal3" Text='<%$Resources:ProductCategoryView,IDS_FormField_ProductType %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <Hishop:ProductTypeDownList runat="server" ID="dropProductTypes" />
                                    </td>
                                    <td class="rightTD">
                                        <label class="msgNormal">
                                            <asp:Literal ID="Literal4" Text="<%$Resources:ProductCategoryView,IDS_Label_ProductType %>"
                                                runat="server"></asp:Literal></label>
                                    </td>
                                </tr>
                                <tr runat="server" id="tblrRewriteName">
                                    <td class="leftTD">
                                        <asp:Literal ID="Literal2" Text='<%$Resources:TopCategories,IDS_FormField_RewriteName %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <asp:TextBox ID="txtRewriteName" runat="server" CssClass="input_short"></asp:TextBox>
                                    </td>
                                    <td class="rightTD">
                                        <div id="txtRewriteNameTip" runat="server">
                                        </div>
                                        <Hishop:ValidateTarget ID="ValidateTarget5" runat="server" ControlToValidate="txtRewriteName"
                                            ContainerId="ValidatorContainer" Nullable="true" Description="<%$Resources:TopCategories,IDS_FormField_RewriteNameHelp %>"
                                            FocusMessage="<%$Resources:TopCategories,IDS_FormField_RewriteNameHelp %>">
                                            <Validators>
                                                <Hishop:InputStringClientValidator Regex="([a-zA-Z])+(([a-zA-Z_-])?)+" ErrorMessage="<%$Resources:TopCategories,IDS_ErrorMessage_RewriteNameFormat %>"
                                                    LowerBound="1" UpperBound="50" />
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="leftTD">
                                        <asp:Literal ID="lblCategoryIcon" Text='<%$Resources:ProductCategoryView,IDS_FormField_CategoryIcon %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <asp:FileUpload ID="fileUpload" CssClass="input_longest" runat="server" />
                                    </td>
                                    <td class="rightTD">
                                        <div class="msgNormal">
                                            <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="leftTD">
                                        <asp:Literal ID="lblPageKeyWords" Text='<%$Resources:ProductCategoryView,IDS_FormField_PagekeyWords %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <span>
                                            <asp:TextBox ID="txtPageKeyWords" CssClass="input_short" runat="server"></asp:TextBox></span>
                                    </td>
                                    <td class="rightTD">
                                        <div id="txtPageKeyWordsTip" runat="server">
                                        </div>
                                        <Hishop:ValidateTarget runat="server" ControlToValidate="txtPageKeyWords" ContainerId="ValidatorContainer"
                                            Description="<%$Resources:ProductCategoryView,IDS_FormField_MetaKeywords_Help %>"
                                            Nullable="true" FocusMessage="<%$Resources:ProductCategoryView,IDS_FormField_MetaKeywords_Help %>">
                                            <Validators>
                                                <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:ProductCategoryView,IDS_FormField_MetaKeywords_Help %>"
                                                    LowerBound="1" UpperBound="1000" />
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="leftTD">
                                        <asp:Literal ID="Literal1" Text='<%$Resources:ProductCategoryView,IDS_FormField_PageDesc %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD">
                                        <span>
                                            <asp:TextBox ID="txtPageDesc" CssClass="input_short" runat="server"></asp:TextBox></span>
                                    </td>
                                    <td class="rightTD">
                                        <div id="txtPageDescTip" runat="server">
                                        </div>
                                        <Hishop:ValidateTarget runat="server" ControlToValidate="txtPageDesc" ContainerId="ValidatorContainer"
                                            Description="<%$Resources:ProductCategoryView,IDS_FormField_MetaDesc_Help %>"
                                            Nullable="true" FocusMessage="<%$Resources:ProductCategoryView,IDS_FormField_MetaDesc_Help %>">
                                            <Validators>
                                                <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:ProductCategoryView,IDS_FormField_MetaDesc_Help %>"
                                                    LowerBound="1" UpperBound="1000" />
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="leftTD">
                                        <asp:Literal ID="lblBuy" Text='<%$Resources:ProductCategoryView,IDS_FormField_Buy %>'
                                            runat="server"></asp:Literal>：
                                    </td>
                                    <td class="rightTD" colspan="2">
                                        <span>
                                            <FCKeditorV2:FCKeditor ID="fckNotes" runat="server" Width="99%" EnableXHTML="true"
                                                EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="300px">
                                            </FCKeditorV2:FCKeditor>
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                    </td>
                                </tr>
                            </table>
                        </SkinTemplate>
                    </Hishop:ProductCategoryView>
                    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                        <tr>
                            <td class="bottonLeftTD">
                                &nbsp;
                            </td>
                            <td class="rightTD">
                                <table>
                                    <tr>
                                        <td valign="top">
                                            <asp:Button ID="btnSaveCategory" Text='<%$Resources:Resources,IDS_Button_Save %>'
                                                OnClientClick="return PageIsValid();" runat="server" CssClass="inp_L1" />
                                        </td>
                                        <td>
                                            <div class="return_inp">
                                                <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_TopCategories")%>'>
                                                    <asp:Label ID="lblReturn" Text='<%$Resources:EditProductCategory,IDS_Label_ReturnCategoryList %>'
                                                        runat="server" /></a></div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td class="rightTD">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                </div>
            </SkinTemplate>
        </Hishop:EditProductCategory>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>