﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:TopCategories,IDS_PageTitle %>"></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:TopCategories,IDS_PageDesc %>" />
            </div>
        </div>
        <Hishop:ManageCategories ID="TopCategories" runat="server">
            <SkinTemplate>
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <div class="grdGroupFormList">
                    <div class="grdHeaderStyle">
                        <ul>
                            <li class="addProductClass_Manage"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_AddProductCategory")%>'>
                                <asp:Literal ID="lblAdddProductCategory" runat="server" Text="<%$ Resources:ProductCategories, IDS_LinkButton_AddProductCategoryiesTitle %>"></asp:Literal></a></li>
                        </ul>
                    </div>
                    <asp:GridView ID="grdTopCategries" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                        DataKeyNames="CategoryId" CssClass="GridViewStyle" GridLines="none" RowStyle-CssClass="grdrow"
                        HeaderStyle-CssClass="GridViewHeaderStyle" ShowFooter="false" SelectedRowStyle-BackColor="#FBFBF4">
                        <Columns>
                            <asp:TemplateField HeaderText="<%$ Resources:TopCategories, IDS_Header_Name %>">
                                <ItemTemplate>
                                    <asp:Label ID="lblCategoryName" runat="server" Text='<%# Eval("Name") %>' />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField HeaderText="<%$ Resources:TopCategories, IDS_Header_RewriteName %>" HeaderStyle-Width="100px" DataField="RewriteName" />
                            <asp:BoundField HeaderText="商品类型" HeaderStyle-Width="100px" DataField="TypeName" />
                            <Hishop:SortImageColumn HeaderText="<%$Resources:Regions, IDS_Header_DisplaySequence%>" ItemStyle-Width="40px" ReadOnly="true" />
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="220px">
                                 <ItemStyle/>
                                 <ItemTemplate>
                                    <asp:HyperLink CssClass="SmallCommonTextButton" ID="HyperLink1" runat="server" Text="<%$ Resources:ProductCategories, IDS_Label_DisplaceCategory %>" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_displaceCategory",Eval("CategoryId"))%>'></asp:HyperLink>
                                    <asp:HyperLink CssClass="SmallCommonTextButton" ID="HyperLink2" runat="server" Text="<%$ Resources:ProductCategories, IDS_Label_ViewProduct %>" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_Products", "", Eval("CategoryId"), "", "", "")%>'></asp:HyperLink>
                                    <asp:HyperLink CssClass="SmallCommonTextButton" ID="lkEdit" runat="server" Text="<%$ Resources:Resources, IDS_Button_Edit %>" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_editproductCategory",Eval("CategoryId"))%>'></asp:HyperLink>
                                    <Hishop:ImageLinkButton CssClass="SmallCommonTextButton" runat="server" ID="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" OnClientClick="return confirm('删除分类会级联删除其所有子分类，确定要删除选择的分类吗？');"></Hishop:ImageLinkButton>
                                 </ItemTemplate>
                             </asp:TemplateField>  
                        </Columns>
                    </asp:GridView>
                </div>
                <!--002-->
                <!--第一层结束-->
            </SkinTemplate>
        </Hishop:ManageCategories>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
    </div>
    <br />
    </form>
</body>
</html>