﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:PriceChange, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:PriceChange,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <!-- Control Content -->
            <Hishop:PriceChange ID="PriceChange" runat="server">
            <SkinTemplate>
            

<Hishop:StatusMessage id="Status" runat="server" Visible="False"></Hishop:StatusMessage>
    
<table border="0" cellpadding="0" cellspacing="0" width="100%" class="formTableList">
    <!--商品分类-->
    <tr>
        <td class="leftTD" ><asp:Label runat="server" Text="<%$ Resources:PriceChange,IDS_Field_Category %>"></asp:Label></td>
        <td class="rightTD" style="width:200px;"><Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server"></Hishop:ProductCategoriesDropDownList></td>
        <td class="rightTD">
            <div id="dropCategoriesTip" runat="server"></div>
            <Hishop:ValidateTarget ID="validateTargetCategorie" runat="server" ControlToValidate="dropCategories"
                Description="<%$ Resources:CategorySelectorForProduct, IDS_Categories_Description %>"
                ContainerId="ValidatorContainer">
                <Validators>
                    <Hishop:DropDownListClientValidator ErrorMessage="<%$ Resources:CategorySelectorForProduct, IDS_FormField_lblCategoryHelp %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--商品市场价-->
    <tr>
        <td class="leftTD" ><asp:Label runat="server" Text="<%$ Resources:PriceChange,IDS_Field_MarketPrice %>"></asp:Label></td>
        <td class="rightTD">
            <Hishop:ArithmeticOperateDropDownList Id="dropMarketPriceOperate" runat="server" />
            <asp:TextBox runat="server" Id="txtMarketPrice"></asp:TextBox>
        </td>
        <td class="rightTD">
            <div id="txtMarketPriceTip" runat="server"></div>
            <Hishop:ValidateTarget  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtMarketPrice" 
                  Description="<%$ Resources:PriceChange,IDS_FrontMessage_MarketPrice %>" Nullable="true">
               <Validators>
                  <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Error %>" />
                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Error %>" MinValue="0" />
               </Validators>
            </Hishop:ValidateTarget> 
        </td>
    </tr>  
    <!--一口价-->         
    <tr>
        <td class="leftTD" ><asp:Label runat="server" Text="<%$ Resources:PriceChange,IDS_Field_SalePrice %>"></asp:Label></td>
        <td class="rightTD">
            <Hishop:ArithmeticOperateDropDownList Id="dropSalePriceOperate" runat="server" />
            <asp:TextBox ID="txtSalePrice" runat="server"></asp:TextBox></td>
        <td class="rightTD">
            <div id="txtSalePriceTip" runat="server"></div>
            <Hishop:ValidateTarget  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtSalePrice" 
                  Description="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Same %>" Nullable="true">
               <Validators>
                   <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Error %>" />
                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Error %>" MinValue="0" />
               </Validators>
            </Hishop:ValidateTarget> 
        </td>
    </tr>
    <!--成本价-->         
    <tr>
        <td class="leftTD" ><asp:Label runat="server" Text="<%$ Resources:PriceChange,IDS_Field_CostPrice %>"></asp:Label></td>
        <td class="rightTD">
            <Hishop:ArithmeticOperateDropDownList Id="dropCostPriceOperate" runat="server" />
            <asp:TextBox ID="txtCostPrice" runat="server"></asp:TextBox></td>
        <td class="rightTD">
            <div id="txtCostPriceTip" runat="server"></div>
            <Hishop:ValidateTarget  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtCostPrice" 
                  Description="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Same %>" Nullable="true">
               <Validators>
                    <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Error %>" />
                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Price_Error %>" MinValue="0" />
               </Validators>
            </Hishop:ValidateTarget> 
        </td>
    </tr>
    <!--备注-->
    <tr>
        <td class="leftTD"><asp:Label runat="server" Text="<%$ Resources:PriceChange,IDS_Field_Remark %>"></asp:Label></td>
        <td class="rightTD"><asp:TextBox ID="txtRemark" runat="server" Width="300" Height="100px" TextMode="MultiLine"></asp:TextBox></td>
        <td class="rightTD">
            <div id="txtRemarkTip" runat="server"></div>
            <Hishop:ValidateTarget ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtRemark" 
                  Description="<%$ Resources:PriceChange,IDS_FrontMessage_Remark %>" Nullable="true">
               <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:PriceChange,IDS_FrontMessage_Remark_Error %>"  LowerBound="1" UpperBound="2000" />
               </Validators>
            </Hishop:ValidateTarget> 
        </td>
    </tr>
    <!--按钮-->
    <tr>
        <td class="leftTD">&nbsp;</td>
        <td colspan="2" style="border-top:1px #e1e1e1 solid;">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" width="100%">
              <tr>
                <td  >
                    <table>
                        <tr>
                            <td valign="top"><asp:Button ID="btnPriceSet" OnClientClick="return PageIsValid();" runat="server" Text="<%$ Resources:PriceChange,IDS_Field_Set %>"  CssClass="inp_L1"></asp:Button ></td>
                            <td><div class="return_inp"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ProductOnSales")%>'><asp:Literal runat="server" Text="<%$ Resources:PriceChange,IDS_Field_BackProductList %>" /></a></div>
                            </td>
                        </tr>
                     </table>  
                </td>
              </tr>
            </table>
        </td>
    </tr> 
</table>


        <div class="grdHeaderStyle">
            <ul>
                <li class="userGroupAddadmin">
                    <asp:Label ID="Label1" Text="<%$ Resources:PriceChange,IDS_Field_SetTitle %>" runat="server"></asp:Label>
                </li>
            </ul>
        </div>
        
        <fieldset class="AdminSearchform">
            <legend>
                <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:Resources,Utilty_Search_Title %>"></asp:Literal></legend>
            <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
                <tr>
                    <td class="searchTableLeftTD">
                        <nobr><asp:Label ID="lblStartDate" runat="server" Text="<%$ Resources:Resources,Utilty_Search_FromDate %>"></asp:Label>：</nobr>
                    </td>
                    <td class="searchTableControlTD">
                        <Hishop:Calendar ID="calendarStartDate" runat="server" />
                    </td>
                    <td class="searchTableLeftTD">
                        <nobr><asp:Label ID="lblEndDate" runat="server" Text="<%$ Resources:Resources,Utilty_Search_ToDate %>"></asp:Label>：</nobr>
                    </td>
                    <td class="searchTableControlTD" colspan="2">
                        <Hishop:Calendar ID="calendarEndDate" runat="server" />
                    </td>  
                    <td class="searchTableLeftTD">
                        <nobr>
                            <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:Resources,Utilty_Search_PageSize %>"></asp:Label>：</nobr>
                    </td>
                    <td class="searchTableControlTD">
                        <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                    </td>
                    <td class="searchTableControlTD">
                        <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:Resources, IDS_Button_Search %>"
                            CssClass="inp_L1" /></td>
                </tr>
            </table>
        </fieldset>
        
        <div class="grdGroupListLi">
            <Hishop:CustomGridView ID="grdGroupList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="RecordId" CssClass="GridViewStyle" GridLines="None" 
                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true">
                    <SelectedRowStyle BackColor="#FBFBF4" />
                <Columns>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:PriceChange, IDS_ListField_RecordId %>" ItemStyle-Width="50">
                       <ItemTemplate>
                          <%# Eval("RecordId") %>
                       </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="<%$ Resources:PriceChange, IDS_ListField_OperateDate %>" ItemStyle-Width="130" SortExpression="OperateDate">
                       <ItemTemplate>
                           <div><asp:Literal ID="Literal1" Text='<%#Eval("OperateDate") %>' runat="server"></asp:Literal></div>
                       </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="<%$ Resources:PriceChange, IDS_ListField_Category %>" ItemStyle-Width="130">
                       <ItemTemplate>
                           <asp:Literal ID="Literal2" Text='<%#Eval("CategoryName") %>' runat="server"></asp:Literal>
                       </ItemTemplate>
                    </asp:TemplateField>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:PriceChange, IDS_ListField_Price %>" ItemStyle-Width="120">
                       <ItemTemplate>
                           <div><asp:Literal ID="Literal3" Text="<%$ Resources:PriceChange, IDS_ListField_MarketPrice %>" runat="server" Visible='<%# Convert.ToString(Eval("MarketPriceOperate")) !="" %>'></asp:Literal> <span style="color:Red;"><asp:Literal ID="Literal4" Text='<%# Eval("MarketPriceOperate") %>' runat="server" Visible='<%# Convert.ToString(Eval("MarketPriceOperate")) !="" %>'></asp:Literal><asp:Literal  ID="FormatedMoneyLabelForAdmin1" Text='<%# Eval("MarketPrice") %>' runat="server" Visible='<%# Convert.ToString(Eval("MarketPriceOperate")) !="" %>'/></span></div>
                           <div><asp:Literal ID="Literal5" Text="<%$ Resources:PriceChange, IDS_ListField_SalePrice %>" runat="server" Visible='<%# Convert.ToString(Eval("SalePriceOperate")) !="" %>'></asp:Literal> <span style="color:Red;"><asp:Literal ID="Literal6" Text='<%# Eval("SalePriceOperate") %>' runat="server" Visible='<%# Convert.ToString(Eval("SalePriceOperate")) !="" %>'></asp:Literal><asp:Literal  ID="FormatedMoneyLabelForAdmin2" Text='<%# Eval("SalePrice") %>' runat="server" Visible='<%# Convert.ToString(Eval("SalePriceOperate")) !="" %>'/></span></div>
                           <div><asp:Literal ID="Literal7" Text="<%$ Resources:PriceChange, IDS_ListField_CostPrice %>" runat="server" Visible='<%# Convert.ToString(Eval("CostPriceOperate")) !="" %>'></asp:Literal> <span style="color:Red;"><asp:Literal ID="Literal8" Text='<%# Eval("CostPriceOperate") %>' runat="server" Visible='<%# Convert.ToString(Eval("CostPriceOperate")) !="" %>'></asp:Literal><asp:Literal  ID="FormatedMoneyLabelForAdmin3" Text='<%# Eval("CostPrice") %>' runat="server" Visible='<%# Convert.ToString(Eval("CostPriceOperate")) !="" %>'/></span></div>
                       </ItemTemplate>
                    </asp:TemplateField>
                                        
                    <asp:TemplateField HeaderText="<%$ Resources:PriceChange, IDS_ListField_UserName %>" ItemStyle-Width="130">
                       <ItemTemplate>
                           <asp:Literal ID="Literal9" Text='<%#Eval("UserName") %>' runat="server"></asp:Literal>
                       </ItemTemplate>
                    </asp:TemplateField>                
                                             
                    <asp:TemplateField HeaderText="<%$ Resources:PriceChange, IDS_ListField_Remark %>">
                        <ItemTemplate>
                            <span><asp:Literal ID="Literal10" Text='<%#Eval("Remark") %>' runat="server"></asp:Literal></span>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
        </Hishop:CustomGridView>
    </div>   
    <!--分页开始-->
    <div class="grdGroupTabhead">
        <UI:Pager runat="server" ListToPaging="grdGroupList" ID="pager" />
    </div>
            </SkinTemplate>
            </Hishop:PriceChange>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>