﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Components" Assembly="Hishop.Web.Components" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ProductReviewsManage,IDS_PageTitle %>"></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ProductReviewsManage,IDS_PageDesc %>"></asp:Literal>
            </div>
        </div>
        <Hishop:ProductReviewsManage ID="ProductReviews" runat="server">
            <SkinTemplate>
                <!-- 操作提示 -->
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <!-- 商品评论查询区 -->
                <Hishop:ProductSearch runat="server" ID="productSearch">
                    <SkinTemplate>
                        <fieldset class="AdminSearchform">
                            <legend>
                                <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_litSelectQuery %>"></asp:Literal></legend>
                            <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
                                <tr>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:TextBox ID="txtSearchText" runat="server" Width="110" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox>
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblSKU" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSKU %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:TextBox ID="txtSKU" Width="110" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblBrandCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblBrandCategory %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:BrandCategoriesDropDownList ID="dropBrandCategories" runat="server" />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblPageSize %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>"
                                            CssClass="inp_L1" />
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </SkinTemplate>
                </Hishop:ProductSearch>
                <div class="grdGroupFormList" style="word-break: break-all; width: 100%;">
                    <div class="grdGroupList">
                        <asp:DataList ID="dlstPtReviews" runat="server" Width="100%" DataKeyField="ReviewId">
                            <HeaderTemplate>
                                <table class="GridViewStyle" id="GridViewTable" cellspacing="0" border="0" style="width: 100%;">
                                    <tr class="GridViewHeaderStyle">
                                        <th scope="col" style="width: 180px;">
                                            <span>
                                                <asp:Literal ID="lblChoise" Text="<%$ Resources:ProductReviewsManage,IDS_FormField_Reviewspt%>"
                                                    runat="server"></asp:Literal></span>
                                        </th>
                                        <th scope="col" style="width: 120px;">
                                            <span>
                                                <asp:Literal ID="lblOpen" Text="<%$ Resources:ProductReviewsManage,IDS_dsHead_User%>"
                                                    runat="server"></asp:Literal></span>
                                        </th>
                                        <th>
                                            <span>
                                                <asp:Literal ID="littext" runat="server" Text="<%$ Resources:ProductReviewsManage,IDS_FormField_ReviewText%>"></asp:Literal></span>
                                        </th>
                                        <th style="width: 80px;">
                                            <span>
                                                <asp:Literal ID="litRate" runat="server" Text="<%$ Resources:ProductReviewsManage,IDS_dsHead_Rate%>"></asp:Literal></span>
                                        </th>
                                        <th style="width: 130px;">
                                            <span>
                                                <asp:Literal ID="litMaxCheck" runat="server" Text="<%$ Resources:ProductReviewsManage,IDS_dsHead_Time%>"></asp:Literal></span>
                                        </th>
                                        <th style="width: 108px;">
                                            <span>
                                                <asp:Literal ID="litOpetion" runat="server" Text="<%$ Resources:Resources, IDS_Header_Options %>"></asp:Literal></span>
                                        </th>
                                    </tr>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr>
                                    <td style="text-align: left;">
                                        <a href="javascript:openDialog('<%# Globals.GetSiteUrls().UrlData.FormatUrl("ProductImages",Eval("ProductId")) %>')">
                                            <Hishop:Common_ProductThumbnail runat="server" AutoResize="true" DataField="ThumbnailsUrl" /></a>
                                        <asp:Label ID="lblThumbUrl" runat="server" Text='<%# Eval("ThumbnailsUrl") %>' Style="display: none;"></asp:Label>
                                        <asp:Label ID="lblInFocusUrl" runat="server" Text='<%# Eval("InFocusImageUrl") %>'
                                            Style="display: none;"></asp:Label>
                                        <div style="color: Blue">
                                            <%# Eval("SKU")%></div>
                                        <Hishop:ProductNavigationDetails ProductName='<%# Eval("ProductName") %>' ProductId='<%# Eval("ProductId") %>' runat="server" />
                                    </td>
                                    <!-- 评论人 -->
                                    <td>
                                        <asp:Label ID="lblUserName" runat="server" Text='<%# Eval("UserName") %>'></asp:Label>
                                    </td>
                                    <td style="text-align: left;">
                                        <asp:Literal ID="lblConsultationText" runat="server" Text='<%# Eval("ReviewText") %>'></asp:Literal>
                                    </td>
                                    <td>
                                    </td>
                                    <!-- 评论时间 -->
                                    <td>
                                        <Hishop:FormatedTimeLabel ID="ConsultationDateTime" Time='<%# Eval("ReviewDate") %>'
                                            runat="server"></Hishop:FormatedTimeLabel>
                                    </td>
                                    <!-- 按钮 -->
                                    <td style="text-align: right;">
                                        <Hishop:ImageLinkButton ID="btnReviewDelete" runat="server" CommandName="Delete"
                                            CommandArgument='<%# Eval("ReviewId")%>' CssClass="SmallCommonTextButton" OnClientClick=""
                                            Text="<%$ Resources:Resources, IDS_Button_Delete %>"></Hishop:ImageLinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </table>
                            </FooterTemplate>
                        </asp:DataList>
                    </div>
                    <!--分页开始-->
                    <div class="grdGroupTabhead">
                        <UI:Pager runat="server" ListToPaging="dlstPtReviews" ID="pager" />
                    </div>
                    <!--分页结束-->
                </div>
            </SkinTemplate>
        </Hishop:ProductReviewsManage>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
