﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:Suppliers,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:Suppliers,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:Suppliers ID="Suppliers" runat="server">
            <SkinTemplate>

        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

<div class="grdGroupFormList">

            <div class="grdHeaderStyle">
                <ul>
                    <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                        <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                        <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupDelCheck">
                        <Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server"
                            Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:DeleteImageLinkButton></li>
                </ul>
            </div>
            <div class="grdGroupList">
                <div class="grdGroupListLi">
                    <Hishop:CustomGridView ID="grdSuppliers" runat="server" AutoGenerateColumns="false"
                        ShowHeader="true" DataKeyNames="SupplierId" CssClass="GridViewStyle" GridLines="None"
                        RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" SelectedRowStyle-BackColor="#FBFBF4">
                        <Columns>
                            <Hishop:CheckBoxColumn ReadOnly="true"  />
                            <asp:TemplateField HeaderText="<%$ Resources:Suppliers,IDS_FormField_SupplierName %>" HeaderStyle-Width="20%">
                                <itemtemplate>
	                               <asp:Literal id="lblSupplierName" Text='<%#Eval("Name") %>' runat="server"></asp:Literal>
                               </itemtemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="<%$ Resources:Suppliers,IDS_FormField_Contact %>" HeaderStyle-Width="20%">
                                <itemtemplate>
                                  <Hishop:SubStringLabel ID="lblContacts" StrLength="12" StrReplace="..." Text='<%#Eval("Contact")%>' runat="server"></Hishop:SubStringLabel>
                               </itemtemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="TelPhone" HeaderText="<%$ Resources:Suppliers,IDS_FormField_TellPhone %>" />
                            <asp:BoundField DataField="CellPhone" HeaderText="<%$ Resources:Suppliers,IDS_FormField_CellPhone %>" />
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="10%">
                                <ItemStyle />
                                <ItemTemplate>
			                         <asp:LinkButton runat="server" CssClass="SmallCommonTextButton" ID="lbtnEditSupplier" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit %>" />
			                         <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" ID="DeleteImageLinkButton1" runat="server"  Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete"/>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </Hishop:CustomGridView>
                </div>
            </div>
</div>

        <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
            <ul>
                <li class="addProductTmpt">
                    <asp:Literal ID="lblSupplierTitle" Text="<%$Resources:Suppliers,IDS_Title_AddSuppliers%>"
                        runat="server"></asp:Literal>
                </li>
            </ul>
        </div>
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList"
            id="addItemsTable">
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblSupplierNames" Text="<%$Resources:Suppliers,IDS_FormField_SupplierName %>"
                        runat="server"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:HtmlDecodeTextBox ID="txtSupplierName" runat="server"></Hishop:HtmlDecodeTextBox></td>
                <td class="rightTD">
                    <div id="txtSupplierNameTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtSupplierName"  ContainerId="ValidatorContainer" Description="<%$Resources:Suppliers,IDS_ErrorMessage_SupplierName_Length %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Suppliers,IDS_ErrorMessage_SupplierName_Length %>"
                                LowerBound="1" UpperBound="50" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblContact" Text="<%$Resources:Suppliers,IDS_FormField_Contact %>"
                        runat="server"></asp:Literal>：</td>
                <td class="rightTD">
                        <Hishop:HtmlDecodeTextBox ID="txtContace" runat="server"></Hishop:HtmlDecodeTextBox></td>
                <td class="rightTD">
                    <div id="txtContaceTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtContace"   ContainerId="ValidatorContainer" Description="<%$Resources:Suppliers,IDS_ErrorMessage_Contace_length %>"
                        Nullable="true" >
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Suppliers,IDS_ErrorMessage_Contace_length %>"
                                LowerBound="1" UpperBound="50" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblTellPhone" Text="<%$Resources:Suppliers,IDS_FormField_TellPhone %>"
                        runat="server"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:HtmlDecodeTextBox ID="txtTellPhone" runat="server"></Hishop:HtmlDecodeTextBox>
                    </td>
                <td class="rightTD">
                    <div id="txtTellPhoneTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtTellPhone"  ContainerId="ValidatorContainer"  Description="<%$Resources:Suppliers,IDS_ErrorMessage_TellPhone_Length %>"
                        Nullable="true" >
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Suppliers,IDS_ErrorMessage_TellPhone_Length %>" UpperBound="20"/>
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblCellPhone" Text="<%$Resources:Suppliers,IDS_FormField_CellPhone %>"
                        runat="server"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:HtmlDecodeTextBox ID="txtCellPhone" runat="server"></Hishop:HtmlDecodeTextBox>
                    </td>
                <td class="rightTD">
                    <div id="txtCellPhoneTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtCellPhone"  ContainerId="ValidatorContainer"  Description="<%$Resources:Suppliers,IDS_ErrorMessage_CellPhone_Length %>"
                        Nullable="true" >
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Suppliers,IDS_ErrorMessage_CellPhone_Length %>"  UpperBound="20"/>
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblAddress" Text="<%$Resources:Suppliers,IDS_FormField_Address %>"
                        runat="server"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:HtmlDecodeTextBox ID="txtaddress" runat="server"></Hishop:HtmlDecodeTextBox></td>
                <td class="rightTD">
                    <div id="txtaddressTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtaddress"  ContainerId="ValidatorContainer" Description="<%$Resources:Suppliers,IDS_ErrorMessage_address_length %>"
                        Nullable="true" >
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Suppliers,IDS_ErrorMessage_address_length %>"
                                LowerBound="1" UpperBound="500" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblRemark" Text='<%$Resources:Suppliers,IDS_FormField_Remark %>'
                        runat="server"></asp:Literal>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtRemark" runat="server"  Width="300px" Height="70px"></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtRemarkTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtRemark"  ContainerId="ValidatorContainer" Description="<%$Resources:Suppliers,IDS_ErrorMessage_Remark_length %>"
                        Nullable="true">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Suppliers,IDS_ErrorMessage_Remark_length %>"
                                LowerBound="1" UpperBound="1000" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="bottonLeftTD">
                    &nbsp;</td>
                <td class="rightTD">
                    <asp:Button ID="btnSubmitSuppliers" OnClientClick="return PageIsValid();" runat="server"
                        Text="<%$ Resources:Resources, IDS_Button_Add%>" CssClass="inp_L1" />
                    <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:Resources, IDS_Button_Cancel%>"
                        CssClass="inp_L1" />
                </td>
                <td class="rightTD">
                    &nbsp;</td>
            </tr>
        </table>
            </SkinTemplate>
            </Hishop:Suppliers>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>