﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div> 
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:EditDiscount,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:EditDiscount,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:EditDiscount ID="EditDiscount" runat="server">
            <SkinTemplate>
                <div id="editDiscounts"><Hishop:StatusMessage id="Status" runat="server" Visible="False" /></div>
                <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                    <Hishop:PromoteView id="editpromoteSales" runat="server">
                        <SkinTemplate>
                        <!--促销活动名称(编号在名称前且隐藏)-->
                            <tr>
                                <td class="leftTD">
                                    <asp:Label ID="lblAddEditActivityId" Style="display: none" runat="server"></asp:Label>
                                    <asp:Literal ID="Literal1" Text='<%$Resources:PromoteView,IDS_FormField_PromoteSalesName %>' runat="server"></asp:Literal>
                                </td>
                                <td class="rightTD"><asp:TextBox ID="txtPromoteSalesName" runat="server" Width="200px"></asp:TextBox></td>
                                <td class="rightTD">
                                    <div id="txtPromoteSalesNameTip" runat="server"></div>
                                    <Hishop:ValidateTarget ID="ValidatePromoteSalesName"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtPromoteSalesName" 
                                             Description="<%$ Resources:PromoteView, IDM_help01 %>" Nullable="false">
                                        <Validators>
                                             <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:PromoteView, IDM_help01%>" LowerBound="1" UpperBound="100" />
                                        </Validators>
                                    </Hishop:ValidateTarget>
                                </td>
                            </tr>
                            <!--开始时间 --> 
                            <tr>
                                <td class="leftTD"><asp:Literal ID="Literal4" Text='<%$Resources:PromoteView,IDS_FormField_StartTime %>' runat="server"></asp:Literal></td>
                                <td class="rightTD"><Hishop:Calendar ID="calendarStart" runat="server" EnableTime="true"/></td>
                                <td class="rightTD">
                                    <div class="msgNormal">
                                        <asp:Literal ID="Literal3" runat="server" Text="<%$Resources:PromoteView,IDM_help03 %>" />
                                    </div>
                                </td>             
                                </tr>
                            <!--结束时间 -->
                            <tr>
                                <td class="leftTD"><asp:Literal ID="Literal5" Text='<%$Resources:PromoteView,IDS_FormField_EndTime %>' runat="server"></asp:Literal></td>
                                <td class="rightTD"><Hishop:Calendar ID="calendarEnd" runat="server" EnableTime="true"/></td>
                                <td class="rightTD">
                                    <div class="msgNormal">
                                            <asp:Literal ID="Literal7" runat="server" Text="<%$Resources:PromoteView,IDM_help04 %>" />
                                    </div>
                                </td>
                            </tr>
                            <!--促销活动描述 -->  
                            <tr>
                                <td class="leftTD"><asp:Literal ID="Literal6" Text='<%$Resources:PromoteView,IDS_FormField_Description %>' runat="server"></asp:Literal></td>
                                <td class="rightTD" colspan="2"><FCKeditorV2:FCKeditor ID="fckDescription" runat="server" Width="99%" EnableXHTML="true" EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="230px"></FCKeditorV2:FCKeditor></td>
                            </tr>
                        </SkinTemplate>
                    </Hishop:PromoteView>
                        <Hishop:DiscountView id="editDiscount" runat="server">
                            <SkinTemplate>
                                <!--金额-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal1" Text='<%$Resources:DiscountView,IDS_FormField_Amount %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtAmount" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtAmountTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateAmount"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtAmount" 
                                                  Description="<%$ Resources:DiscountView, IDM_help01%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:DiscountView, IDS_Message_Amount_NotMember%>" />
                                                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:DiscountView, IDS_Message_Amount_ErrorFormat%>" MinValue="0" MaxValue="9999999" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                                <!--折扣类型-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal3" Text='<%$Resources:DiscountView,IDS_FormField_ValueType %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><Hishop:DiscountValueTypeRadioButtonList id="radioValueType" runat="server"></Hishop:DiscountValueTypeRadioButtonList></td>
                                    <td class="rightTD">
                                        <div class="msgNormal">
                                            <asp:Literal ID="lblValueType" runat="server" Text="<%$Resources:DiscountView,IDM_help03 %>" />
                                        </div>
                                    </td>
                                </tr>
                                <!--折扣值-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal2" Text='<%$Resources:DiscountView,IDS_FormField_DiscountValue %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtDiscountValue" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtDiscountValueTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateDiscountValue"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtDiscountValue" 
                                                  Description="<%$ Resources:DiscountView, IDM_help02%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:DiscountView, IDS_Message_DiscountValue_NotMember%>" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                            </SkinTemplate>
                        </Hishop:DiscountView>
                    <tr>
                        <td class="bottonLeftTD">&nbsp;</td>
                        <td colspan="2" class="rightTD">
                            <table>
                                <tr>
                                    <td valign="top"><asp:Button ID="btnSaveDiscount" OnClientClick="return PageIsValid();" runat="server" Text="<%$ Resources:EditDiscount, IDS_Button_Edit %>" CssClass="inp_L1" /></td>
                                    <td><div class="return_inp"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManagePromoteSales")%>'>
                                        <asp:Literal ID="lblreturn" runat="server" Text="<%$ Resources:Resources ,IDS_Button_Back %>" /></a></div>
                                    </td>
                                </tr>
                             </table>                    
                        </td>
                        <td class="rightTD">&nbsp;</td>
                        </tr>
                </table>
            </SkinTemplate>
          </Hishop:EditDiscount>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
