﻿<%@ Page Language="C#" AutoEventWireup="false" ValidateRequest="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>         
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:EditPresent,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:EditPresent,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:EditPresent ID="editPresent" runat="server">
                <SkinTemplate>
                    <script type="text/javascript">
                        function ResetPager(sender, eventArgs) {
                            CB_Pager.callback();
                        }

                        function showDialog() {
                            if (dialogGifts.get_isShowing()) {
                                dialogGifts.Close();
                            }
                            else {
                                dialogGifts.Show();
                            }
                        }
                    </script>
                    <div id="editPresent"><Hishop:StatusMessage id="Status" runat="server" Visible="False" /></div>
                    <div>    
                    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                        <Hishop:PromoteView id="editpromoteSales" runat="server">
                          <SkinTemplate>
                        <!--促销活动名称(编号在名称前且隐藏)-->
                            <tr>
                                <td class="leftTD">
                                    <asp:Label ID="lblAddEditActivityId" Style="display: none" runat="server"></asp:Label>
                                    <asp:Literal ID="Literal1" Text='<%$Resources:PromoteView,IDS_FormField_PromoteSalesName %>' runat="server"></asp:Literal>
                                </td>
                                <td class="rightTD"><asp:TextBox ID="txtPromoteSalesName" runat="server" Width="200px"></asp:TextBox></td>
                                <td class="rightTD">
                                    <div id="txtPromoteSalesNameTip" runat="server"></div>
                                    <Hishop:ValidateTarget ID="ValidatePromoteSalesName"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtPromoteSalesName" 
                                             Description="<%$ Resources:PromoteView, IDM_help01 %>" Nullable="false">
                                        <Validators>
                                             <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:PromoteView, IDM_help01%>" LowerBound="1" UpperBound="100" />
                                        </Validators>
                                    </Hishop:ValidateTarget>
                                </td>
                            </tr>
                            <!--开始时间 --> 
                            <tr>
                                <td class="leftTD"><asp:Literal ID="Literal4" Text='<%$Resources:PromoteView,IDS_FormField_StartTime %>' runat="server"></asp:Literal></td>
                                <td class="rightTD"><Hishop:Calendar ID="calendarStart" runat="server" EnableTime="true"/></td>
                                <td class="rightTD">
                                    <div class="msgNormal">
                                        <asp:Literal ID="Literal3" runat="server" Text="<%$Resources:PromoteView,IDM_help03 %>" />
                                    </div>
                                </td>             
                                </tr>
                            <!--结束时间 -->
                            <tr>
                                <td class="leftTD"><asp:Literal ID="Literal5" Text='<%$Resources:PromoteView,IDS_FormField_EndTime %>' runat="server"></asp:Literal></td>
                                <td class="rightTD"><Hishop:Calendar ID="calendarEnd" runat="server" EnableTime="true"/></td>
                                <td class="rightTD">
                                    <div class="msgNormal">
                                            <asp:Literal ID="Literal7" runat="server" Text="<%$Resources:PromoteView,IDM_help04 %>" />
                                    </div>
                                </td>
                            </tr>
                            <!--促销活动描述 -->  
                            <tr>
                                <td class="leftTD"><asp:Literal ID="Literal6" Text='<%$Resources:PromoteView,IDS_FormField_Description %>' runat="server"></asp:Literal></td>
                                <td class="rightTD" colspan="2"><FCKeditorV2:FCKeditor ID="fckDescription" runat="server" Width="99%" EnableXHTML="true" EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="230px"></FCKeditorV2:FCKeditor></td>
                            </tr>
                          </SkinTemplate>
                        </Hishop:PromoteView>
                        <Hishop:PresentView id="editPresent" runat="server">
                            <SkinTemplate>
                                <!--金额-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal1" Text='<%$Resources:PresentView,IDS_FormField_Amount %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtAmount" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtAmountTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateAmount"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtAmount" 
                                                  Description="<%$ Resources:PresentView, IDM_help01%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:PresentView, IDS_Message_Amount_NotMember%>" />
                                                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:PresentView, IDS_Message_Amount_ErrorFormat%>" MinValue="0" MaxValue="9999999" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                            </SkinTemplate>
                        </Hishop:PresentView>
                        <tr>
                            <td class="leftTD">
                                <img src="../images/jiaoyiIcon.gif" alt="" /><asp:Literal ID="Literal2" runat="server" Text="<%$Resources:PresentView,IDS_Label_Gifts %>"></asp:Literal>：</td>
                            <td class="rightTD" colspan="2">
                                <a  style="color:Blue" onclick="showDialog();" ><asp:Label ID="lblShow" runat="server" Text="<%$Resources:PresentView,IDS_Label_CheckGifts %>" /></a>
                             </td>
                        </tr>
                        <tr>
                        <td colspan="3" style="padding-left:25px;"><asp:Label ID="lblCheckedGifts" runat="server" Text="<%$Resources:PresentView,IDS_Label_CheckedGifts %>" /></td>
                        </tr>
                        <tr>
                        <td colspan="3" style="padding-left:25px">
                        <div class="grdHeaderStyle">
                            <ul>
                                <li class="userGroupCheckAll"><a  onclick="CheckClickAll()"><asp:Label ID="SelectAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
		                        <li class="spirtLines">|</li>
		                        <li class="userGroupReverseCheck"><a   onclick="CheckReverse()"><asp:Label ID="lblRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
		                        <li class="spirtLines">|</li>
		                        <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lbtnDeleteCheck" runat="server" OnClientClick="" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li> 
	                        </ul>   
                        </div>
                        <!--促销活动礼品列表-->
                        <asp:GridView ID="grdPromoteSales" runat="server" AutoGenerateColumns="False" DataKeyNames="GiftId" Width="100%" CssClass="AlticleClassTable" GridLines="None" ShowHeader="true">
                            <Columns> 
                                <Hishop:CheckBoxColumn  ShowHead="false" Text="<%$ Resources:Resources, IDS_Header_Check %>" HeadWidth="25" />
                                <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_GiftName %>">
                                    <ItemTemplate>
                                        <Hishop:SubStringLabel ID="lblPromoteSaleGiftName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("Name") %>' Text='<%#Eval("Name") %>' runat="server"></Hishop:SubStringLabel>
                                    </ItemTemplate>
                               </asp:TemplateField>
                               <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_Stock %>">
                                    <ItemTemplate>
                                        <asp:Label ID="lblStock"  Money='<%#Eval("Stock") %>' runat="server" />
                                    </ItemTemplate>
                               </asp:TemplateField>
                               <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_CostPrice %>">
                                    <ItemTemplate>
                                        <Hishop:FormatedMoneyLabelForAdmin ID="lblCostPrice"  Money='<%#Eval("CostPrice") %>' runat="server" />
                                    </ItemTemplate>
                               </asp:TemplateField>
                               <Hishop:MoneyColumnForAdmin HeaderText="<%$Resources:PresentView,IDS_Head_SalePrice %>" DataField="SalePrice"></Hishop:MoneyColumnForAdmin>
                               <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                    <ItemTemplate>
                                        <Hishop:DeleteImageLinkButton ID="lkbDelete" runat="server"  CommandName="Delete" Text="<%$ Resources:EngagedPromoteSales, IDS_FormField_DeleteEngagedPromoteSal%>" />
                                    </ItemTemplate>
                               </asp:TemplateField>
                               </Columns>
                               <RowStyle CssClass="grdrow"/>
                               <HeaderStyle CssClass="GridViewHeaderStyle"/>
                        </asp:GridView>
                        <div style="text-align:left">
                            <UI:Pager runat="server"  RunningMode="PostBack" ID="presentPager" />
                        </div>
                        <UI:Dialog AnimationType="Live" ShowTransition="Fade" AnimationSlide="ExponentialDecelerate"
                            CloseTransition="Fade" AnimationDuration="600" Modal="false"
                            AllowDrag="true" Alignment="MiddleCentre" Title="<%$Resources:PresentView,IDS_Label_CheckGifts %>"
                            ID="dialogGifts" runat="server" Width="600">
                            <Content>
                                <table style="width:100%">
                                    <tr>
                                      <td class="searchTableLeftTD"><nobr><asp:Label ID="lblSearchText" runat="server" Text="<%$Resources:PresentView,IDS_Label_Keyword %>"></asp:Label>：</nobr></td>
                                      <td class="searchTableControlTD"><asp:TextBox ID="txtGiftName" runat="server" /></td>
                                      <td align="left"><input type="button"  value="查询" onclick="grdGifts_ReBindData();"  /></td>
                                    </tr>
                                    <tr>
                                       <td colspan="3">
                                        <UI:CallBack id="CB_cbGrdGifts" ClientSideOnCallbackComplete="ResetPager" CacheContent="false" runat="server" PostState="true" Debug="false">
                                          <Content>
                                           <UI:Grid ID="grdGifts" runat="server" AutoGenerateColumns="False" CssClass="GridNoBorder" CallBackDataKey="GiftId"
                                                CellPadding="4" ForeColor="#333333" GridLines="None" AllowSorting="false" HeaderStyle-CssClass="GridViewHeaderStyle"
                                                Width="100%" RunningMode="Callback" >
                                                <Columns>
                                                   <Hishop:CheckBoxColumn  ShowHead="false" Text="<%$ Resources:Resources, IDS_Header_Check %>" HeadWidth="25" /> 
                                                   <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_GiftName %>">
                                                        <ItemTemplate>
                                                            <Hishop:SubStringLabel ID="lblGiftName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("Name") %>' Text='<%#Eval("Name") %>' runat="server"></Hishop:SubStringLabel>
                                                        </ItemTemplate>
                                                   </asp:TemplateField>
                                                   <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_Stock %>">
                                                        <ItemTemplate>
                                                            <asp:Label ID="lblStock"  Money='<%#Eval("Stock") %>' runat="server" />
                                                        </ItemTemplate>
                                                   </asp:TemplateField>
                                                   <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_CostPrice %>">
                                                        <ItemTemplate>
                                                            <Hishop:FormatedMoneyLabelForAdmin ID="lblCostPrice"  Money='<%#Eval("CostPrice") %>' runat="server" />
                                                        </ItemTemplate>
                                                   </asp:TemplateField>
                                                   <asp:TemplateField HeaderText="<%$Resources:PresentView,IDS_Head_SalePrice %>">
                                                        <ItemTemplate>
                                                            <Hishop:FormatedMoneyLabelForAdmin ID="lblPrice"  Money='<%#Eval("SalePrice") %>' runat="server" />
                                                        </ItemTemplate>
                                                   </asp:TemplateField>
                                                </Columns>
                                                <RowStyle CssClass="grdrow"/>
                                                <HeaderStyle CssClass="GridViewHeaderStyle"/>
                                           </UI:Grid>
                                          </Content>
                                       </UI:CallBack>
                                        <div style="text-align:left">
                                            <UI:CallBack id="CB_Pager" CacheContent="false" PostState="true" Debug="false" runat="server">
                                            <Content>
                                                <UI:Pager runat="server" ListToPaging="grdGifts" ListToCallBackID="CB_cbGrdGifts" RunningMode="Callback" ID="pager" />
                                            </Content>
                                            </UI:CallBack>
                                        </div>
                                       </td>
                                    </tr>
                                 </table>
                                 <div class="footer">
                                   <asp:Button ID="btnAddGift" runat="server" Text="<%$ Resources:Resources, IDS_Button_Confirm %>" CssClass="inp_L1" />
                                </div>
                                
                            </Content>
                        </UI:Dialog>
                        </td>
                        </tr>
                        <tr>
                            <td class="bottonLeftTD">&nbsp;</td>
                            <td colspan="2" class="rightTD">
                                <table>
                                    <tr>
                                        <td valign="top"><asp:Button ID="btnEditPresent" OnClientClick="return PageIsValid();" runat="server" Text="<%$ Resources:EditPresent, IDS_Button_Edit %>" CssClass="inp_L1" /></td>
                                        <td><div class="return_inp"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManagePromoteSales")%>'>
                                            <asp:Literal ID="lblreturn" runat="server" Text="<%$ Resources:Resources ,IDS_Button_Back %>" /></a></div>
                                        </td>
                                    </tr>
                                 </table>                    
                            </td>
                            <td class="rightTD">&nbsp;</td>
                        </tr>
                    </table>
                </SkinTemplate>
            </Hishop:EditPresent>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
