﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>         

            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:OverduePromoteSales,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:OverduePromoteSales,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <div>
              <ul class="anchors clearfix">
                <li><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManagePromoteSales")%>'><img src="../images/shiyoudecuxiao.gif" alt="" /><asp:Label runat="server" id="lblEngagedPromoteSales" Text="<%$ Resources:PromoteSales, IDS_DataField_EngagedPromoteSales %>" /></a></li>
                <li class="tabs-selected"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_overduepromotesales")%>'><img src="../images/shiyoudecuxiao.gif" alt="" /><asp:Label runat="server" id="lblOverduePromoteSales" Text="<%$ Resources:PromoteSales, IDS_DataField_OverduePromoteSales %>" /></a></li>
              </ul>
            </div>
            <Hishop:OverduePromoteSales ID="OverduePromoteSales" runat="server">
                <SkinTemplate>
	                        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
                    <!--查询面板-->
                    <Hishop:PromoteSalesSearch ID="promoteSalesSearch" runat="server" >
                        <SkinTemplate>
                            <fieldset class="AdminSearchform">
                             <legend><asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:PromoteSalesSearch, IDS_FromField_SelectQuery %>"></asp:Literal></legend> 
                                <table width="50%" border="0" cellspacing="0" cellpadding="0" style="margin-left:18px">
                                    <tr>
                                        <td class="searchTableLeftTD">
                                            <nobr> <asp:Label ID="lblPromoteSalesName" runat="server" Text="<%$ Resources:PromoteSalesSearch, IDS_FromField_PromoteSalesName %>"></asp:Label></nobr>
                                        </td>
                                        <td class="searchTableControlTD">
                                           <Hishop:DefaultButtonTextBox ID="txtPromoteSalesName" runat="server" Button="btnSearchButton"></Hishop:DefaultButtonTextBox></td>
                                        <td class="searchTableLeftTD">
                                            <nobr> <asp:Label ID="lblGiftType" runat="server" Text="<%$ Resources:PromoteSalesSearch, IDS_FromField_PromoteType %>"></asp:Label></nobr>
                                            </td>
                                        <td class="searchTableControlTD">
                                         <Hishop:PromoteTypeDropDownList ID="dropPromoteType" runat="server" AllowNull="true" NullToDisplay="所有类型" />
                                        </td>
                                        <td class="searchTableLeftTD">
                                            <nobr><asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:PromoteSalesSearch, IDS_FromField_PageSize %>"></asp:Label></nobr>
                                            </td>
                                        <td class="searchTableControlTD">
                                           <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                                        </td>
                                        <td>
                                            <asp:Button ID="btnSearchButton" runat="server"  Text="<%$ Resources:PromoteSalesSearch, IDS_Button_Search %>" CssClass="inp_L1"></asp:Button>
                                       </td>
                                    </tr>
                                </table>
                            </fieldset>
                        </SkinTemplate>
                    </Hishop:PromoteSalesSearch>
                    <!--过期促销活动列表-->
                    <div class="grdGroupFormList">

                                <div class="grdHeaderStyle">
                                    <ul>
		                              <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Label ID="SelectAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
		                              <li class="spirtLines">|</li>
		                              <li class="userGroupReverseCheck"><a  href="#" onclick="CheckReverse()"><asp:Label ID="lblRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
		                              <li class="spirtLines">|</li>
		                              <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lbtnDeleteCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:DeleteImageLinkButton></li> 
	                                </ul>   
                                </div>
                                <div class="grdGroupList">
                                  <div class="grdGroupListLi">
                                    <Hishop:CustomGridView ID="grdPromoteSales" runat="server" AutoGenerateColumns="False" DataKeyNames="ActivityId" CssClass="GridViewStyle" GridLines="None" ShowHeader="true" AllowSorting="true" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" SortOrderBy="ActivityId" SortOrder="DESC">
                                        <Columns>
                                            <Hishop:CheckBoxColumn  ShowHead="false"  Text="<%$ Resources:Resources, IDS_Header_Check %>" ></Hishop:CheckBoxColumn>            
                                            <asp:TemplateField HeaderText="<%$ Resources:OverduePromoteSales, IDS_Header_PromoteSalesName %>" SortExpression="Name">
                                                <ItemTemplate>
                                                     <Hishop:SubStringLabel ID="lblPromteSalesName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("Name") %>' Text='<%#Eval("Name") %>' runat="server"></Hishop:SubStringLabel>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="<%$ Resources:OverduePromoteSales, IDS_Header_PromoteSalesType %>" SortExpression="PromoteType">
                                              <ItemTemplate>
                                                <asp:Label ID="lblPromoteType" Text='<%#Eval("PromoteType") %>' style="display:none" runat="server"></asp:Label>
                                                <asp:Label ID="lblPromoteTypeName" runat="server"></asp:Label>
                                              </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="<%$ Resources:OverduePromoteSales, IDS_Header_StartTime %>" SortExpression="StartTime">
                                                <ItemTemplate>
                                                    <Hishop:FormatedTimeLabel ID="lblStartTimes" Time='<%#Eval("StartTime") %>' runat="server" ></Hishop:FormatedTimeLabel>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="<%$ Resources:OverduePromoteSales, IDS_Header_ClosingTime %>" SortExpression="ClosingTime">
                                                <ItemTemplate>
                                                    <Hishop:FormatedTimeLabel ID="lblClosingTimes" Time='<%#Eval("ClosingTime")%>' runat="server" ></Hishop:FormatedTimeLabel>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                                <ItemStyle/>
                                                <ItemTemplate>
                                                     <asp:HyperLink ID="lnkEdit" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:OverduePromoteSales, IDS_FormField_EditEngagedPromoteSales %>"></asp:HyperLink>
                                                     <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" ID="lkbDelete" runat="server"  CommandName="Delete" Text="<%$ Resources:EngagedPromoteSales, IDS_FormField_DeleteEngagedPromoteSal%>" />
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        </Columns>
                                   </Hishop:CustomGridView>
                                   <div class="grdGroupTabhead">
                                        <UI:Pager runat="server" ListToPaging="grdPromoteSales" ID="pager" />
                                   </div>
                                </div>
                              </div>            
                    </div>
                </SkinTemplate>
            </Hishop:OverduePromoteSales>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
