﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>         

            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:EditPaymentMode, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:EditPaymentMode, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
             <Hishop:EditPaymentMode ID="EditPaymentMode" runat="server">
                <SkinTemplate>
<!-- 操作提示 -->

        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
        <Hishop:PaymentModeView ID="paymentModeView" runat="server">
            <SkinTemplate>

        <!-- 支付方式名称-->
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
            <tr>
                <td class="leftTD">
                    <asp:Label ID="lblName" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblName %>"></asp:Label></td>
                <td class="rightTD">
                    <asp:TextBox ID="txtName" runat="server" Columns="40" MaxLength="200"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtNameTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetName" runat="server" Description="<%$ Resources:PaymentModeView, IDS_Message_Name_Description %>"
                        ControlToValidate="txtName" ContainerId="ValidatorContainer">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:PaymentModeView, IDS_Message_Name_Description %>"
                                LowerBound="1" UpperBound="50" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Label ID="lblGateway" runat="server" Text="<%$ Resources:PaymentModeView,IDS_FormField_lblGateway %>"></asp:Label></td>
                <td class="rightTD">
                    <Hishop:PayInterfaceDropDownList ID="dropPayInterface" runat="server" AllowNull="true"
                        NullToDisplay="<%$ Resources:PaymentModeView, IDS_FormField_nullToDisplay %>"
                        AutoPostBack="true">
                    </Hishop:PayInterfaceDropDownList><br />
                    <asp:HyperLink ID="hlinkImage" runat="server" Target="_blank">
                        <asp:Label ID="lblimage" runat="server"></asp:Label>
                    </asp:HyperLink>
                    
                </td>
                <td class="rightTD">
                    <div id="dropPayInterfaceTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetPayInterface" runat="server" ContainerId="ValidatorContainer"
                        Description="<%$ Resources:PaymentModeView, IDS_Message_PayInterface_Description %>"
                        ControlToValidate="dropPayInterface">
                        <Validators>
                            <Hishop:DropDownListClientValidator ErrorMessage="<%$ Resources:PaymentModeView, IDS_Message_PayInterface_Description %>" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr id="tblrMerchantCode" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblMerchantCode" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblMerchantCode %>"></asp:Label></td>
                <td class="rightTD">
                    <asp:TextBox ID="txtMerchantCode" runat="server" Columns="40" MaxLength="200"></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtMerchantCodeTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetMerchantCode" runat="server" Description="<%$ Resources:PaymentModeView, IDS_Message_MerchantCode_Description %>"
                        ControlToValidate="txtMerchantCode" ContainerId="ValidatorContainer">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:PaymentModeView, IDS_Message_MerchantCode_Description %>"
                                LowerBound="1" UpperBound="300" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <!-- 显示隐藏容器 邮件地址 -->
            <tr id="tblrImage" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblEmailAddress" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblEmailAddress %>"></asp:Label></td>
                <td class="rightTD">
                    <label>
                        <asp:TextBox ID="txtEmailAddress" runat="server" Columns="40" MaxLength="200"></asp:TextBox>
                    </label>
                </td>
                <td class="rightTD">
                    &nbsp;
                </td>
            </tr>
            <!-- 显示隐藏容器 商户密钥 -->
            <tr id="tblrSecretKey" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblSecretKey" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblSecretKey %>"></asp:Label></td>
                <td class="rightTD">
                    <label>
                        <asp:TextBox ID="txtSecretKey" runat="server" Columns="40" MaxLength="200"></asp:TextBox>
                    </label>
                </td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="lblHelpSecret" runat="server" Text="<%$ Resources:PaymentModeView, IDS_PaymnetMode_SecondKey_Description %>"></asp:Literal>
                    </div>
                </td>
            </tr>
            <!-- 显示隐藏容器 第二密钥 -->
            <tr id="tblrSecondKey" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblSecondKey" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblSecondKey %>"></asp:Label></td>
                <td class="rightTD">
                    <label>
                        <asp:TextBox ID="txtSecondKey" runat="server" Columns="40" MaxLength="200"></asp:TextBox>
                    </label>
                </td>
                <td class="rightTD">
                    &nbsp;
                </td>
            </tr>
            <!-- 显示隐藏容器 商户密码 -->
            <tr id="tblrPassword" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblPassWord" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblPassWord %>"></asp:Label>
                </td>
                <td class="rightTD">
                    <label>
                        <asp:TextBox ID="txtPassword" runat="server" Columns="40" MaxLength="200" TextMode="Password"></asp:TextBox>
                    </label>
                </td>
                <td class="rightTD">
                   <div class="msgNormal">
                        <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_PassWord_Description %>"></asp:Literal>
                    </div>
                </td>
            </tr>
            <!-- 显示隐藏容器 合作伙伴 -->
            <tr id="tblrPartner" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblPartner" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblPartner %>"></asp:Label>
                </td>
                <td class="rightTD">
                    <label>
                        <asp:TextBox ID="txtPartner" runat="server" Columns="40" MaxLength="200"></asp:TextBox>
                    </label>
                </td>
                <td class="rightTD">
                    &nbsp;
                </td>
            </tr>
            <tr id="tblrCurrencys" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblCurrencys" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblCurrencys %>"></asp:Label></td>
                <td class="rightTD" style="width: 37%">
                    <label>
                        <asp:CheckBoxList ID="chkCurrencysList" runat="server" RepeatDirection="Horizontal"
                            RepeatColumns="4">
                        </asp:CheckBoxList>
                    </label>
                </td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="lblCurrencyHelp" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblCurrencyHelp %>"></asp:Literal>
                    </div>
                </td>
            </tr>
            <tr id="tblCharge" runat="server">
                <td class="leftTD">
                    <asp:Label ID="lblCharge" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblCharge %>"></asp:Label></td>
                <td class="rightTD">
                    <label>
                        <asp:TextBox ID="txtCharge" runat="server" Text="0"></asp:TextBox>
                        <asp:CheckBox ID="chkIsPercent" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_chkIsPercent %>" />
                    </label>
                </td>
                <td class="rightTD">
                    <div id="txtChargeTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetCharge" runat="server" ContainerId="ValidatorContainer"
                        ControlToValidate="txtCharge" Description="<%$ Resources:PaymentModeView, IDS_Message_Charge_Description %>">
                        <Validators>
                            <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:PaymentModeView, IDS_Message_Charge_Description %>" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Label ID="lblDisplaySequence" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblDisplaySequence %>"></asp:Label></td>
                <td class="rightTD">
                    <asp:TextBox ID="txtDisplaySequence" runat="server" Text="1" Columns="5"></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtDisplaySequenceTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetSequence" runat="server" ContainerId="ValidatorContainer"
                        ControlToValidate="txtDisplaySequence" Description="<%$ Resources:PaymentModeView, IDS_Message_DisplaySequence_Description %>">
                        <Validators>
                            <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:PaymentModeView, IDS_Message_DisplaySequence_Description %>" />
                            <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:PaymentModeView, IDS_ErrorMessage_DisplaySequence %>"
                                MinValue="1" MaxValue="65535" />
                        </Validators>
                    </Hishop:ValidateTarget>

                </td>
            </tr>
        </table>


        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
            <tr>
                <td class="leftTD">
                    <asp:Label ID="lblDescription" runat="server" Text="<%$ Resources:PaymentModeView, IDS_FormField_lblDescription %>"></asp:Label></td>
                <td class="rightTD">
                    <FCKeditorV2:FCKeditor ID="fcContent" runat="server" Width="100%" EnableXHTML="true"
                        EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="200px">
                    </FCKeditorV2:FCKeditor>
                </td>
                <td class="rightTD">
                    &nbsp;
                </td>
            </tr>
        </table>

            </SkinTemplate>
        </Hishop:PaymentModeView>

<table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
    <tr>
        <td class="bottonLeftTD">
            &nbsp;</td>
        <td class="rightTD">
            <table>
                <tr>
                    <td valign="top">
                        <asp:Button ID="btnUpdate" runat="server" Text="<%$ Resources:EditPaymentMode, IDS_Button_Update %>"
                            OnClientClick="return PageIsValid()" CssClass="inp_L1" /></td>
                    <td>
                        <div class="return_inp">
                            <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManagePaymentMode")%>'>
                                <asp:Literal ID="litReturn" runat="server" Text="<%$ Resources:EditPaymentMode, IDS_FromField_lblReturn %>"></asp:Literal>
                            </a>
                        </div>
                    </td>
                </tr>
            </table>
        </td>
        <td class="rightTD">
            &nbsp;</td>
    </tr>
</table>
                </SkinTemplate>
             </Hishop:EditPaymentMode>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
