﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
        <script type="text/javascript" src="../js/DropDonwList.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>         
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ManageOrder, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ManageOrder, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:ManageOrder ID="ManageOrder" runat="server">
                <SkinTemplate>
                    <!-- 操作提示 -->
                        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

<!--search bar-->
<fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSearchTitle" Text="<%$ Resources:ManageOrder, IDS_Literal_SearchTitle %>"
            runat="server"></asp:Literal>
    </legend>
    <table width="50%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
        <tr>
            <!--username-->
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblUserName" runat="server" Text="<%$Resources:ManageOrder,IDS_Label_UserName %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtUserName" runat="server" width="100" />
            </td>
            <!--shipto-->
            <td  align="right">
                <nobr>
                    <asp:Label ID="lblShipTo" runat="server" Text="<%$ Resources:ManageOrder,IDS_Label_Shipping %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD" >
                <asp:TextBox ID="txtShipTo" runat="server" width="100"/>
            </td>
            <!--starttime-->
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblStartDate" runat="server" Text="<%$Resources:ManageOrder,IDS_Label_StartDate %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:Calendar ID="calendarStartDate" runat="server" EnableTime="true" width="100"/>
            </td>
            <!--endtime-->
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblEndDate" runat="server" Text="<%$ Resources:ManageOrder,IDS_Label_EndDate %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD" >
                <Hishop:Calendar ID="calendarEndDate" runat="server" EnableTime="true" width="100"/>
            </td>
        </tr>
        <tr>
            <!--orderId-->
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblOrderId" runat="server" Text="<%$Resources:ManageOrder,IDS_Label_OrderId %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtOrderId" runat="server" width="100"/>
            </td>
            <!--orderStatus-->
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="litOrderStatus" runat="server" Text="<%$ Resources:ManageOrder,IDS_Label_OrderStatus %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD" >
                <Hishop:OrderStautsForSearchDropDownList ID="dropOrderStatus" AllowNull="true" NullToDisplay="646454"
                    runat="server" width="108"/>
            </td>
            <!--payment-->
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="litPayment" runat="server" Text="<%$ Resources:ManageOrder,IDS_grdPayment %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD" >
                <Hishop:PaymentDropDownList ID="dropPayment" AllowNull="true" runat="server" width="108"/>
            </td>
            <!--pageSize-->            
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ManageOrder,IDS_Label_PageSize %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD" >
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" width="108"/>
            </td>
            <td><asp:LinkButton ID="btnSearchButton" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>" runat="server" CssClass="inp_L1" width="35" height="20" /></td>
        </tr>
    </table>
</fieldset>
<div>
    <ul class="anchors clearfix">       
        <li id="anchors_0"><!--所有--><asp:HyperLink ID="hlinkAllOrder" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_All_Oreder %>"></asp:HyperLink>(<asp:Literal ID="litlAllOrder" runat="server"></asp:Literal>)</li>
        <li id="anchors_1"><!--未付款订单--><asp:HyperLink ID="hlinkNotPay" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_WAIT_BUYER_PAY %>"></asp:HyperLink>(<asp:Literal ID="litlNotPay" runat="server"></asp:Literal>)</li>
        <li id="anchors_2"><!--已付款订单--><asp:HyperLink ID="hlinkYetPay" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_Pay_Order %>"></asp:HyperLink>(<asp:Literal ID="litlYetPay" runat="server"></asp:Literal>)</li>       
        <li id="anchors_3"><!--配货中订单--><asp:HyperLink ID="hlinkSendingGoods" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_PREPARE_GOODS %>"></asp:HyperLink>(<asp:Literal ID="litlSendingGoods" runat="server"></asp:Literal>)</li>
        <li id="anchors_4"><!--已发货订单--><asp:HyperLink ID="hlinkSendedGoods" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_Delivered %>"></asp:HyperLink>(<asp:Literal ID="litlSendedGoods" runat="server"></asp:Literal>)</li>
        <li id="anchors_5"><!--已完成订单--><asp:HyperLink ID="hlinkTradeFinished" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_TRADE_FINISHED %>"></asp:HyperLink>(<asp:Literal ID="litlTradeFinished" runat="server"></asp:Literal>)</li>
        <li id="anchors_6"><!--申请退款订单--><asp:HyperLink ID="hlinkRequested" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_BUYER_Requested %>"></asp:HyperLink>(<asp:Literal ID="litlRequested" runat="server"></asp:Literal>)</li>
        <li id="anchors_7"><!--已退款订单--><asp:HyperLink ID="hlinkRefund" runat="server" Text="<%$ Resources:ManageOrder, IDS_OrderStatus_BUYER_REFUND %>"></asp:HyperLink>(<asp:Literal ID="litlRefund" runat="server"></asp:Literal>)</li>
    </ul>
</div>

<div class="grdGroupFormList">
   <div class="grdHeaderStyle">
	     <ul>
	           <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
	           <li class="spirtLines">|</li>
	           <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
	           <li class="spirtLines">|</li>
	           <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server" OnClientClick="" DeleteMsg="<%$ Resources:ManageOrder, IDS_OrderOption %>"  Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
	     </ul>
    </div>
    <div class="grdGroupListLi">
                <Hishop:CustomGridView ID="grdOrders" runat="server" SortOrderBy="OrderDate" SortOrder="DESC"
                    AutoGenerateColumns="False" DataKeyNames="OrderId" CssClass="GridViewStyle" GridLines="None"
                    ShowHeader="true" AllowSorting="true" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                    <Columns>
                        <Hishop:CheckBoxColumn ReadOnly="true"/>
                        
                        <asp:TemplateField HeaderText="<%$ Resources:ManageOrder,IDS_grdOrderId %>" SortExpression="OrderId">
                            <itemtemplate>
                            <asp:Label ID="lblOrderId" Text='<%#Eval("OrderId") %>' runat="server" ></asp:Label>
                         </itemtemplate>
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="<%$ Resources:ManageOrder, IDS_Header_OrderDate %>" SortExpression="OrderDate">
                            <itemtemplate>
                               <Hishop:FormatedTimeLabel ID="lblStartTimes" Time='<%#Eval("OrderDate") %>' runat="server" ></Hishop:FormatedTimeLabel>
                            </itemtemplate>
                        </asp:TemplateField>
                        
                         <asp:TemplateField HeaderText="<%$ Resources:ManageOrder,IDS_grdUserName %>" SortExpression="UserName">
                         <itemtemplate>                       
                            <asp:Label ID="lblParentUserName" Text='<%#Eval("UserName") %>' runat="server" ></asp:Label>
                            <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_EditAgent",Eval("ParentUserId")) %>'><img src="../images/addActing.png" alt='<%# string.Format((string)HttpContext.GetGlobalResourceObject("ManageOrder", "IDS_Label_OfAgent"),Eval("ParentUserName")) %>' visible='<%# Eval("ParentUserName")==DBNull.Value ?false:true %>' runat="server"/></a>
                         </itemtemplate> 
                         </asp:TemplateField>
                        
                        <asp:BoundField HeaderText="<%$ Resources:ManageOrder,IDS_grdShipTo %>" DataField="ShipTo" SortExpression="ShipTo" />
                        
                        
                         <asp:TemplateField HeaderText="<%$ Resources:ManageOrder, IDS_grdAmount %>" ItemStyle-Width="80px">
                         <itemtemplate>                       
                            <Hishop:FormatedMoneyLabelForAdmin Money='<%#Eval("OrderPrice") %>' runat="server" ></Hishop:FormatedMoneyLabelForAdmin>
                         </itemtemplate> 
                         </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="<%$ Resources:ManageOrder, IDS_grdPayment %>" ItemStyle-Width="80px">
                            <itemtemplate>
                                <asp:Label ID="lblOrderpayment" Text='<%#Eval("PaymentType") %>' runat="server" ></asp:Label>
                            </itemtemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="<%$ Resources:ManageOrder, IDS_grdStatusName %>" ItemStyle-Width="50px">
                            <itemtemplate>
                                <Hishop:PaymentStatusLabel ID="lblOrderPaymentStatus" Text='<%# Eval("PaymentStatus") %>' runat="server" />
                                <div><Hishop:RefundStatusLabel ID="lblOrderRefundStatus" Text='<%# Eval("RefundStatus") %>' runat="server" /></div>
                                <Hishop:ShippingStatusLabel ID="lblOrderShippingStatus" Text='<%# Eval("ShippingStatus") %>' runat="server" />
                                <div><Hishop:ActivityStatusLabel ID="lblOrderActivityStatus" Text='<%# Eval("ActivityStatus") %>' runat="server" /></div>
                            </itemtemplate>
                        </asp:TemplateField>
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                <ItemStyle/>
                                <ItemTemplate>
		                           <asp:HyperLink CssClass="SmallCommonTextButton" ID="lkbtnSearch" runat="server" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_OrderDetails", Eval("OrderId")) %>' Target="_blank" Text="<%$ Resources:ManageOrder, IDS_FormField_SearchOrder %>"></asp:HyperLink>
		                           <asp:HyperLink CssClass="SmallCommonTextButton" ID="lkbtnEdit" runat="server" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_EditOrder", Eval("OrderId")) %>'  Target="_blank" Text="<%$ Resources:ManageOrder, IDS_FormField_EditOrder %>" Visible="false"></asp:HyperLink>
                                   <Hishop:ImageLinkButton CssClass="SmallCommonTextButton" ID="lkDelete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" OnClientClick="return confirm('删除后不可恢复，您确认要删除订单吗？');" CommandName="Delete" runat="server"></Hishop:ImageLinkButton>
                                   <a href="#" class="selectHandlist" onmouseover="showmenu(this,'show','bottom')" onmouseout="showmenu(this,'hide','bottom')" style="cursor: pointer;">更多操作</a>
                                    <div class="mdiv">
                                    <ul>
                                        <li><asp:Label ID="lblIsCOD" Text='<%#Eval("IsPOD") %>' runat="server" Visible="false"></asp:Label></li>
                                        <li><asp:HyperLink ID="lkbtnBuyerRefund" runat="server" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_RefundOrder", Eval("OrderId")) %>' Target="_blank" Text="<%$ Resources:ManageOrder, IDS_FormField_BuyerRefund %>" Visible="false"></asp:HyperLink></li>
                                        <li><asp:HyperLink ID="lkbtnSendGoods" runat="server" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_SendGoods", Eval("OrderId")) %>' Target="_blank" Text="<%$ Resources:ManageOrder, IDS_FormField_SendGoods %>" Visible="false"></asp:HyperLink></li>
                                        <li><Hishop:ImageLinkButton ID="lkbOption1" runat="server" ></Hishop:ImageLinkButton></li>
                                        <li><a id="lkbAdminRemark" onclick="$.myfunction.OpenWindow(<%# Eval("OrderId") %>)" href="#">管理员备注</a></li>
                                        <li><a id="A1" onclick="$.leavewordFunction.leavewordOpenWindow(<%# Eval("OrderId") %>)" href="#">订单留言</a></li>
                                    </ul>
                                    </div>
                                </ItemTemplate>
                            </asp:TemplateField>
                    </Columns>
                </Hishop:CustomGridView>
                <div class="grdGroupTabhead">
                    <UI:Pager runat="server" ListToPaging="grdOrders" ID="pager" />
                </div>
    </div>
</div>


<!-- 管理员备注窗体内容 -->
<script type="text/javascript">
    var remark;

    $(document).ready(function() {
        jQuery.myfunction = {
            OpenWindow: function(orderId) {
                if (!dlgAdminRemark.get_isShowing()) {
                    dlgAdminRemark.Show();
                    document.getElementById("ManageOrder_txtRemarkOrderId").value = orderId;
                    CBRemarkList.callback("BindRemark");
                }
            },
            AddRemark: function() {
                if (document.getElementById("ManageOrder_txtRemark").innerHTML != "") {
                    CBRemarkList.callback("AddRemark");
                    document.getElementById("ManageOrder_txtRemark").innerHTML = "";
                }
            },
            UpdateRemark: function(remarkId) {
                if (remark != "") {
                    CBRemarkList.callback("UpdateRemark", remarkId, remark);
                }
            },
            DeleteRemark: function(remarkId) {
                CBRemarkList.callback("DeleteRemark", remarkId);
            }
        }
    });

    function getRemark(obj) {
        remark = obj.innerHTML;
    }
</script>
          <UI:Dialog AnimationType="Live" ShowTransition="Fade" AnimationSlide="ExponentialDecelerate"
            CloseTransition="Fade" AnimationDuration="600" Modal="true"
            AllowDrag="true" Alignment="MiddleCentre" Title="管理员备注"
            ID="dlgAdminRemark" runat="server" Width="500px">
            <Content>
              <asp:TextBox ID="txtRemarkOrderId" runat="server" style="display:none"></asp:TextBox>
              <asp:Panel ID="AffirmTitle" runat="server">
                    <div class="PageTitleArea" >
                        <div class="PageTitle">
                            <asp:Literal ID="lblPageTitleRemark" runat="server" Text="<%$ Resources:ManageOrder, IDS_PageTitle_Remark %>"></asp:Literal>
                        </div>
                        <div style="width: 80%;">
                            <asp:Literal ID="lblPageDescRemark" runat="server" Text="<%$ Resources:ManageOrder, IDS_PageDesc_Remark %>"></asp:Literal>
                        </div>
                    </div>
                   <asp:TextBox ID="txtRemark" Width="99%" Height="30px" TextMode="MultiLine"  runat="server" ></asp:TextBox>
                   <input type="button" onclick="$.myfunction.AddRemark();" value="添加备注" CssClass="inp_L1" />
                   <UI:CallBack id="CBRemarkList" CacheContent="false" runat="server" PostState="true" Debug="false">
                     <Content>   
                   <div >  
                        <UI:TemplatedList ID="dlstRemarkList" runat="server" Width="100%" DataKeyField="RemarkId" RunningMode="Callback">                                                                                                                                                            
                            <HeaderTemplate>
                                <table class="GridViewStyle" cellspacing="0" border="0" style=" width:100%; border-style:solid; border-width:thin;">
                            </HeaderTemplate>  
                            <ItemTemplate>
                                 <tr >
                                    <td><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_RemarkId %>"></asp:Literal>：<asp:Literal ID="Literal2" runat="server" Text='<%# Eval("RemarkId") %>'></asp:Literal></td>                                                                                  
                                    <td><asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_OperaterName %>"></asp:Literal>：<asp:Literal ID="Literal4" runat="server" Text='<%# Eval("OperaterName") %>'></asp:Literal></td>
                                    <td><asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_RemarkDate %>"></asp:Literal>：<Hishop:FormatedTimeLabel ID="FormatedTimeLabel1" Time='<%# Eval("RemarkDate") %>' runat="server" /></td>
                                    <td><asp:Literal ID="litlLastDateMsg" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_LastDate %>" Visible='<%# Convert.ToString(Eval("LastDate")) != Convert.ToString(Eval("RemarkDate")) %>'></asp:Literal><Hishop:FormatedTimeLabel ID="FormatedTimeLabel2" Time='<%# Eval("LastDate") %>' runat="server" Visible='<%# Convert.ToString(Eval("LastDate")) != Convert.ToString(Eval("RemarkDate")) %>' /></td>
                                 </tr>
                                 <tr>
                                    <td colspan="4" style="width:100%;">
                                        <div style="border-style:solid; border-width:thin; background-color:Yellow; border-color:Gray; "><asp:Literal ID="Literal6" runat="server" Text='<%# Eval("Remark") %>'></asp:Literal></div>
                                    </td>
                                 </tr>  
                                 <tr>
                                    <!-- 按钮 -->
                                    <td style="text-align:left;" colspan="4">
                                        <asp:LinkButton ID="btnRemarkEdit" runat="server"  CommandName="Edit"  CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Edit %>" Visible='<%# HiContext.Current.User.UserId == Convert.ToInt32(Eval("UserId")) %>'></asp:LinkButton>                                         
                                        <input type="button" onclick="$.myfunction.DeleteRemark(<%# Eval("RemarkId")%>);" id="btnDeleteRemark" value="删除" class="SmallCommonTextButton" />
                                    </td>
                                 </tr>                           
                            </ItemTemplate>   
                            <EditItemTemplate> 
                                 <tr >
                                    <td><asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_RemarkId %>"></asp:Literal>：<asp:Literal ID="Literal1" runat="server" Text='<%# Eval("RemarkId") %>'></asp:Literal></td>                                                                                  
                                    <td><asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_OperaterName %>"></asp:Literal>：<asp:Literal ID="Literal2" runat="server" Text='<%# Eval("OperaterName") %>'></asp:Literal></td>
                                    <td><asp:Literal ID="Literal9" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_RemarkDate %>"></asp:Literal>：<Hishop:FormatedTimeLabel ID="FormatedTimeLabel1" Time='<%# Eval("RemarkDate") %>' runat="server" /></td>
                                    <td><asp:Literal ID="litlLastDateMsg" runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_LastDate %>" Visible='<%# Convert.ToString(Eval("LastDate")) != Convert.ToString(Eval("RemarkDate")) %>'></asp:Literal><Hishop:FormatedTimeLabel ID="FormatedTimeLabel2" Time='<%# Eval("LastDate") %>' runat="server" Visible='<%# Convert.ToString(Eval("LastDate")) != Convert.ToString(Eval("RemarkDate")) %>' /></td>
                                 </tr>
                                 <tr>
                                    <td colspan="4" style="width:100%;">
                                        <textarea rows="2" cols="20" id="txtRemarkPost" style="height:30px;width:99%;" onkeyup="getRemark(this)"><%# Eval("Remark") %></textarea>
                                    </td>
                                 </tr>  
                                 <tr>
                                    <!-- 按钮 -->
                                    <td style="text-align:left;" colspan="4">
                                        <input type="button" onclick="$.myfunction.UpdateRemark(<%# Eval("RemarkId")%>);" id="btnRemarkUpdate" value="保存" class="SmallCommonTextButton" />
                                        <asp:LinkButton ID="btnRemarkCancel" runat="server"  CommandName="Cancel"  CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Cancel %>"></asp:LinkButton>                                           
                                    </td>
                                 </tr> 
                            </EditItemTemplate>
                            <FooterTemplate>
                                </table>
                            </FooterTemplate>                                            
                       </UI:TemplatedList>
                    </div>
                     </Content>
                    </UI:CallBack>
               </asp:Panel>
            </Content>
        </UI:Dialog>
        
        
      <script type="text/javascript">
          function ResetPager(sender, eventArgs) {
              CBPager.callback();
          }

          $(document).ready(function() {
              jQuery.leavewordFunction = {
                  leavewordOpenWindow: function(orderId) {
                      if (!dlgLeaveWord.get_isShowing()) {
                          dlgLeaveWord.Show();
                          document.getElementById("ManageOrder_txtRemarkOrderId").value = orderId;
                          CBLeaveWord.callback("BindLeaveWord");
                      }
                  },
                  leavewordReply: function(orderId) {
                      if (document.getElementById("ManageOrder_txtLeaveWordAdd").innerHTML != "") {
                          CBLeaveWord.callback("ReplyLeaveWord");
                          document.getElementById("ManageOrder_txtLeaveWordAdd").innerHTML = "";
                      }
                  }
              }
          });
     </script>  
<!-- 订单留言窗体内容 -->
       <UI:Dialog AnimationType="Live" ShowTransition="Fade" AnimationSlide="ExponentialDecelerate"
            CloseTransition="Fade" AnimationDuration="600" Modal="true"
            AllowDrag="true" Alignment="MiddleCentre" Title="订单留言"
            ID="dlgLeaveWord" runat="server" Width="500px">
            <Content>
               <!-- 窗口标题 -->
               <div class="PageTitleArea" >
                    <div class="PageTitle">
                        <asp:Literal runat="server" Text="<%$ Resources:ManageOrder, IDS_PageTitle_LeaveWord %>"></asp:Literal>
                    </div>
                    <div style="width: 80%;">
                        <asp:Literal runat="server" Text="<%$ Resources:ManageOrder, IDS_PageDesc_LeaveWord %>"></asp:Literal>
                    </div>
                </div>
                
                        <asp:TextBox ID="txtLeaveWordAdd" Width="99%" Height="30px" TextMode="MultiLine"  runat="server" ></asp:TextBox>
                        <input type="button" value="留言/回复" id="btnLeaveWordAdd" onclick="$.leavewordFunction.leavewordReply()" class="inp_L1" />
                        <span style="color:Red;">*</span> <span style="font-size:12px;"><asp:Literal runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_LeaveWordMsg1 %>"></asp:Literal></span>
               <UI:CallBack id="CBLeaveWord" ClientSideOnCallbackComplete="ResetPager" CacheContent="false" runat="server" PostState="true" Debug="false">
                     <Content>
                        <div >                                                            
                            <UI:TemplatedList ID="dlstLeaveWord" runat="server" Width="100%" DataKeyField="LeaveId" RunningMode="Callback">   
                                <ItemTemplate>
                                <table class="GridViewStyle" cellspacing="0" border="0" style=" width:100%; border-style:solid; border-width:thin;">
                                     <tr >
                                        <td>
                                            [<asp:Literal Id="litlUserRank" runat="server" Text='<%# Eval("UserId") %>'></asp:Literal>]                                                                                   
                                            <asp:Literal runat="server" Text='<%# Eval("UserName") %>'></asp:Literal> 
                                            <Hishop:FormatedTimeLabel Time='<%# Eval("PublishDate") %>' runat="server" /> <asp:Literal runat="server" Text="<%$ Resources:ManageOrder, IDS_Field_LeaveWordMsg2 %>"></asp:Literal>：
                                        </td>
                                     </tr>
                                     <tr>
                                        <td style="width:100%;style="border-style:solid; border-width:thin; background-color:Yellow; border-color:Gray;">
                                            <div style="word-break:break-all"><asp:Literal runat="server" Text='<%# Eval("PublishContent") %>'></asp:Literal></div>
                                        </td>
                                     </tr>   
                                </table>
                                </ItemTemplate>                                            
                            </UI:TemplatedList>                                
                        </div>
                    </Content>
                 </UI:CallBack>
                 <!--分页开始-->
                 <UI:CallBack id="CBPager" CacheContent="false" PostState="true" Debug="false" runat="server">
                    <Content>
                        <div class="grdGroupTabhead">
                            <UI:Pager runat="server" ListToPaging="dlstLeaveWord" ListToCallBackID="CBLeaveWord" RunningMode="Callback" ID="leaveWordPager" />
                        </div>
                    </Content>
                 </UI:CallBack>
                  <!--分页结束-->
              </Content>
           </UI:Dialog>



<script type="text/javascript">
     var urlLocationStr = document.location.href; 
         
     var ActivityStatusKey=/OrderStatus=/;
     var OrderPaymentStatusKey=/OrderPaymentStatus=/;
     var OrderShippingStatusKey=/OrderShippingStatus=/;
     var OrderRefundStatusKey=/OrderRefundStatus=/;
     var IsAllKey=/IsAll=/;

     ActivityStatusKey.exec(urlLocationStr); var activityStatusString = RegExp.rightContext; 
     OrderPaymentStatusKey.exec(urlLocationStr); var orderPaymentStatusString = RegExp.rightContext; 
     OrderShippingStatusKey.exec(urlLocationStr); var orderShippingStatusString = RegExp.rightContext; 
     OrderRefundStatusKey.exec(urlLocationStr); var orderRefundStatusString = RegExp.rightContext;    
     IsAllKey.exec(urlLocationStr); var isAllString = RegExp.rightContext;
     
     activityStatusSelect=activityStatusString.substr(0,activityStatusString.indexOf("&"));
     orderPaymentStatusSelect=orderPaymentStatusString.substr(0,orderPaymentStatusString.indexOf("&"));
     orderShippingStatusSelect=orderShippingStatusString.substr(0,orderShippingStatusString.indexOf("&"));
     orderRefundStatusSelect=orderRefundStatusString.substr(0,orderRefundStatusString.indexOf("&"));
     
     if (orderPaymentStatusSelect==0 && orderShippingStatusSelect==0 && isAllString=="False" )
     {
       document.getElementById("anchors_1").className = "tabs-selected";
     }
     else if (orderPaymentStatusSelect==1 && orderShippingStatusSelect==0 && isAllString=="False")
     {
       document.getElementById("anchors_2").className = "tabs-selected";
     }
     else if (orderShippingStatusSelect==2 && isAllString=="False")
     {
       document.getElementById("anchors_3").className = "tabs-selected";
     } 
     else if (orderShippingStatusSelect==1 && isAllString=="False")
     {
       document.getElementById("anchors_4").className = "tabs-selected";
     }
     else if (activityStatusSelect==7 && isAllString=="False")
     {
       document.getElementById("anchors_5").className = "tabs-selected";
     }
     else if (orderRefundStatusSelect==1 && isAllString=="False")
     {
       document.getElementById("anchors_6").className = "tabs-selected";
     }
     else if (orderRefundStatusSelect==2 && isAllString=="False")
     {
       document.getElementById("anchors_7").className = "tabs-selected";
     }
     else 
     {
       document.getElementById("anchors_0").className = "tabs-selected";
     }
</script>
                </SkinTemplate>
            </Hishop:ManageOrder>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>