﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body style="font:lighter 12px/150% Tahoma;">
    <form id="form1" runat="server">
        <div>
            <Hishop:OrderDetails ID="OrderDetails" runat="server" >
                <SkinTemplate>

<!--快捷按钮区-->
<table style="width:96%;margin:auto;text-align:right;">
    <tr><td>
        <asp:HyperLink ID="btnHlPostOrder" Text="<%$Resources:OrderDetails,IDS_btn_OrderPost%>" runat="server" Target="_blank" CssClass="btnlkbNoBlock"  />
        <asp:HyperLink ID="btnPrintOrder" runat="server" Text="<%$Resources:OrderDetails,IDS_btn_PrintOrder%>" Target="_blank" CssClass="btnlkbNoBlock"  /> 
    </td></tr> 
</table> 

<!--订单概括信息-->
<table style="width:96%;background-color:#f3f3f3;margin:auto;">
    <tr><td style="line-height:36px; padding-left:20px;">
        <strong><asp:Literal ID="lblOpen" Text="<%$Resources:OrderDetails,IDS_FormField_OrderNumber%>"
            runat="server"></asp:Literal>：</strong><asp:Literal ID="litOrderId" runat="server"></asp:Literal>
        <strong style="padding-left:20px;"><asp:Literal ID="Literal6" Text="<%$Resources:OrderDetails,IDS_FormField_OrderPrice%>"
            runat="server"></asp:Literal>：<span style="color:Red;"><Hishop:FormatedMoneyLabelForAdmin ID="litOrderPrice" runat="server" /></span></strong>
        <strong style="padding-left:20px;"><asp:Literal Text="<%$Resources:OrderDetails,IDS_FormField_OrderStatus%>" runat="server"></asp:Literal>：</strong>
            <Hishop:ActivityStatusLabel ID="lblOrderActivityStatus" runat="server" />
        <strong style="padding-left:20px;"><asp:Literal ID="Literal7" Text="<%$Resources:OrderDetails,IDS_FormField_OrderDate%>"
            runat="server"></asp:Literal>：</strong><Hishop:FormatedTimeLabel ID="litDateTime" runat="server" />
    </td></tr>
</table>     

<!--订单信息-->
        <UI:TabStrip runat="server" ID="tabs" Width="100%">
            <Tabs>
            <UI:TabStripTab ID="tabBaseInfo" runat="server" Title="订单信息">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
            <tr><td>
    <!--订单信息-->

        <!--商品区-->
        <div style="margin-top:10px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:12px;"><asp:Literal ID="litOrderItem" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_ProductInfo%>"></asp:Literal></strong>
        </div>
        <div class="grdGroupListLi" style="margin-bottom: 12px;text-align:center;">
            <!--订单的商品-->
            <asp:DataList ID="dlstOrderItems" runat="server" Width="98%" DataKeyField="ItemId">
                <HeaderTemplate>
                    <table class="GridViewStyle" id="GridViewTable" cellspacing="0" border="0" style="border-collapse: collapse; text-align:left;"
                        width="100%">
                        <tr class="GridViewHeaderStyle">
                           <th>
                                <span>
                                    <asp:Literal ID="litProcuct" runat="server"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="Literal18" runat="server" Text="<%$ Resources:OrderDetails,IDS_Header_Product %>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="lblProductPoints" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_SKU%>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="litProductQuantity" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_ProductPrice%>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="litAmount" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_Point%>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="litPoints" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_BuyNum%>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="litShipQuantity" runat="server" Text="<%$ Resources:OrderDetails,IDS_Header_ShipQuantity %>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="litAllAmount" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_XiaoJi%>"></asp:Literal></span>
                            </th>
                            <th>
                                <span>
                                    <asp:Literal ID="litRemark" runat="server" Text="<%$ Resources:OrderDetails,IDS_Header_Remartk %>"></asp:Literal></span>
                            </th>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr>
                       <td style="border-bottom: solid 1px #DDDDDD;">
                            <Hishop:Common_Link_Product ID="Common_Link_Product1" runat="server" Target="_blank">
                                <Hishop:Common_ProductThumbnail ID="Common_ProductThumbnail1" runat="server" Width="50px" DataField="ThumbnailsUrl"/>
                            </Hishop:Common_Link_Product>

                        </td>
                         <td style="border-bottom: solid 1px #DDDDDD;text-align:left;" >
                            
                            <span style="word-break:break-all;"><Hishop:ProductNavigationDetails ID="productNavigationDetails1" ProductName='<%# Eval("ItemDescription") %>'
                                ProductId='<%# Eval("ProductId") %>' runat="server" />
                            <span>

                            <asp:GridView ID="grdOrderItemValues" runat="server" AutoGenerateColumns="false"
                                GridLines="None" Width="100%" ShowHeader="false"
                                DataSource='<%# DataBinder.Eval(Container.DataItem, "LookupListItems") %>'>
                                <Columns>
                                    <asp:TemplateField >
                                        <ItemTemplate>
                                                <asp:Label ID="Label1" runat="server" Text='<%# Eval("ListDescription") %>'/>：
                                                <asp:Label ID="Label2" runat="server" Text='<%# Eval("ItemDescription") %>'/>
                                                <span style="color:red;">(<Hishop:FormatedMoneyLabelForAdmin ID="FormatedMoneyLabelForAdmin1" runat="server" Money='<%# Eval("AdjustedPrice") %>'/>)</span>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>

                        </td>
                         <td style="border-bottom: solid 1px #DDDDDD;">
                            <asp:Literal ID="Literal5" runat="server" Text='<%# Eval("sku") %>'></asp:Literal>

                        </td>
                        <td style="border-bottom: solid 1px #DDDDDD;">
                            <Hishop:FormatedMoneyLabelForAdmin ID="lblAmount" runat="server" Money='<%# Eval("ItemAdjustedPrice") %>' />
                        </td>
                        <td style="border-bottom: solid 1px #DDDDDD;">
                            <asp:Literal ID="lblProductPoints" runat="server" Text='<%# Eval("Points") %>'></asp:Literal>
                        </td>
                        <td style="border-bottom: solid 1px #DDDDDD;">
                            <asp:Literal ID="lblProductQuantity" runat="server" Text='<%# Eval("Quantity") %>'></asp:Literal>
                        </td>
                        <td style="border-bottom: solid 1px #DDDDDD;">
                            <asp:Literal ID="lblShipQuantity" runat="server" Text='<%# Eval("ShipmentQuantity") %>'></asp:Literal>
                            
                        </td>
                        <td style="border-bottom: solid 1px #DDDDDD;">
                            <Hishop:FormatedMoneyLabelForAdmin ID="FormatedMoneyLabelForAdmin2"  runat="server" Money='<%# (decimal)Eval("ItemAdjustedPrice")*(int)Eval("Quantity") %>'/>
                        </td>
                        <td style="border-bottom: solid 1px #DDDDDD; padding-right: 10px;">
                            <asp:Literal ID="lblRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Literal>
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    </table>
                </FooterTemplate>
            </asp:DataList>
            <!--订单礼品-->
            <table id="htmTblGift" runat="server" class="addOrderGifBg" cellspacing="0" border="1"  style="border-collapse:collapse; 
                margin-bottom: 12px;border-style:solid; border-width:1px; border-color:#eff1c9; background-color:#ffffe8; width:96%; text-align:left; margin-top:10px;" >
                <tr >
                    <td style="line-height:50px; padding-left:60px;">
                        <asp:GridView ID="grdOrderGift" runat="server" AutoGenerateColumns="false" ShowHeader="false"
                             GridLines="None"  DataKeyNames="GiftId" Width="100%">
                            <Columns>
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_grdGiftname %>"  HeaderStyle-HorizontalAlign="Center" ItemStyle-Width="40%">
                                    <ItemTemplate>
                                         <asp:Label ID="lblGiftName" runat="server" Text='<%#Eval("GiftName") %>'></asp:Label>
                                         <asp:Label ID="lblNotFinished" runat="server" Text="<%$ Resources:OrderDetails,IDS_Literal_NotGetGiftCard %>" Visible="false" style="display:block; margin-left:20px"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:OrderDetails,IDS_grdGiftCostPrice%>"
                                    DataField="CostPrice" RemarkText="<%$ Resources:OrderDetails,IDS_Field_CostPrice %>" ItemStyle-Width="30%" />
                                <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:OrderDetails,IDS_grdGiftAdjustedPrice %>"
                                    DataField="AdjustedPrice" RemarkText="<%$ Resources:OrderDetails,IDS_Field_AdjustedPrice %> " ItemStyle-Width="30%" />
                            </Columns>
                        </asp:GridView>
                    </td>
                </tr>
            </table>
        </div>
        <UI:TabStripTab ID="TabStripTab3" runat="server" Title="支付方式、收货和物流信息">
        <!--支付配送信息-->
        <div style="margin-top:20px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:12px;"><asp:Literal runat="server" Text="<%$Resources:OrderDetails,IDS_Field_PaymentAndShipInfo%>"></asp:Literal></strong>
        </div>
        <div style="background-color:#f9f9f9;margin:auto;margin-top:10px;width:98%; text-align:left;">
            <table style="width:100%;" >
                  <tr>
                    <td style="text-align:right;width:8%;">
                        <asp:Literal runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_ModeName%>" />：
                    </td>
                    <td style="width:25%;">
                        <asp:Literal ID="lblModeName" runat="server" />(<span style="color:Red;"><asp:Literal ID="litlShipPrice" runat="server" /></span>)
                    </td>
                    <td style="text-align:right;width:8%;">
                        <asp:Literal ID="litPaymentType" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_PaymentType%>" />：
                    </td>
                    <td style="width:25%;">
                        <asp:Literal ID="lblPaymentType" runat="server" />(<span style="color:Red;"><asp:Literal ID="litlPaymentPrice" runat="server" /></span>)
                    </td>
                    <td style="text-align:right;width:8%;">&nbsp;</td>
                    <td>&nbsp;</td>
                <tr>
                    <td style="text-align:right;">
                        <asp:Literal ID="Literal15" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_ShipOrderNumber%>" />：
                    </td>
                    <td >
                        <asp:Literal ID="litShipOrderNumber" Text="&nbsp" runat="server" />
                    </td>
                </tr>
            </table>
        </div>
        
        <!--订单选项-->
        <div style="margin-top:20px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:12px;"><asp:Literal runat="server" Text="<%$ Resources:OrderDetails,IDS_Title_OrderOption %>"></asp:Literal></strong>
        </div>
        <div style="background-color:#f9f9f9;margin:auto;margin-top:10px;width:98%;">
            <table style="width:100%;" cellspacing="0" cellpadding="0" class="GridViewStyle">
                <tr>
                    <td style="padding-bottom:5px;">
                        <asp:GridView ID="grdOrderOption" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                            CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" Width="96%">
                            <Columns>           
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_OptionListDescription %>" ItemStyle-Width="30%" HeaderStyle-HorizontalAlign="left">
                                    <ItemTemplate>
                                         <asp:Label runat="server" Text='<%#Eval("ListDescription") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_ItemDescription %>" ItemStyle-Width="20%" HeaderStyle-HorizontalAlign="left">
                                    <ItemTemplate>
                                         <asp:Label runat="server" Text='<%#Eval("ItemDescription") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <Hishop:MoneyColumn HeaderText="<%$Resources:OrderDetails, IDS_Header_Amount%>"
                                    DataField="AdjustedPrice" HeaderStyle-HorizontalAlign="Left" />
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_CustomerTitle %>" HeaderStyle-HorizontalAlign="left">
                                    <ItemTemplate>
                                         <asp:Label runat="server" Text='<%#Eval("CustomerTitle") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_CustomerDescription %>" HeaderStyle-HorizontalAlign="left">
                                    <ItemTemplate>
                                         <asp:Label runat="server" Text='<%#Eval("CustomerDescription") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </td>
                </tr>
            </table>
        </div>

        <!--退款信息-->             
        <asp:Panel Visible="false" runat="server" ID="refundPanel">
            <div class="grdHeaderStyle" style="cursor: pointer;">
            <ul>
                <li class="addProductTmpt">
                    <asp:Literal ID="Literal16" runat="server" Text="<%$ Resources:OrderDetails,IDS_Literal_RefundOrder %>"></asp:Literal>
                </li>
            </ul>
            </div>
            <table style="width: 100%; margin-bottom: 20px; border:solid 1px Gray " cellspacing="1" cellpadding="1" class="formTableList" id="Table4">
            <tr>
                <td class="leftTD" style="height: 25px;">
                    <asp:Literal ID="Literal17" runat="server" Text="<%$ Resources:OrderDetails ,IDS_Literal_RefundOrderBanlance %>" />
                </td>
                <td class="rightTD">
                    <asp:Literal ID="litTotalBalance" runat="server" />
                </td>
                <td class="leftTD">
                    <asp:Literal ID="Literal19" runat="server" Text="<%$ Resources:OrderDetails,IDS_Literal_IsAdvances %>" />：
                </td>
                <td class="rightTD">
                    <asp:Literal ID="litIsOrderRefund" runat="server" />
                </td>
                <td class="leftTD" style="height: 25px;">
                    <asp:Literal ID="Literal21" runat="server" Text="<%$ Resources:OrderDetails,IDS_Literal_RefundOrderStatus %>" />：
                </td>
                <td class="rightTD">
                    <Hishop:PaymentStatusLabel ID="lblOrderPaymentStatus" runat="server" />
                    <Hishop:ShippingStatusLabel ID="lblOrderShippingStatus" runat="server" />
                    <Hishop:RefundStatusLabel ID="lblOrderRefundStatus" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="Literal23" runat="server" Text="<%$Resources:OrderDetails ,IDS_Literal_Remark %>" />：
                </td>
                <td class="rightTD" colspan="5">
                    <asp:Literal ID="litRefundOrderRemark" runat="server" />
                </td>
            </tr>
            </table>
        </asp:Panel>

        <!--订单金额汇总--> 
        <div style="margin-top:20px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:12px;"><asp:Literal runat="server" Text="<%$Resources:OrderDetails ,IDS_Title_OrderMoney %>"></asp:Literal></strong>
        </div>
        <div style="background-color:#f9f9f9;margin:auto;margin-top:10px;width:98%; text-align:left;">
            <table class="GridViewStyle" style="width:100%;" >
            <tr>
                <td style="text-align:right;">
                    <asp:Literal ID="liter1" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Amount%>" />：
                     </td><td><span style="color:Red;"><asp:Literal ID="litAmount" runat="server" /></span>
                </td>
                <td style="text-align:right;width:8%;">
                    <asp:Literal ID="Literal5" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_GiftAmount%>" />：
                    </td><td style="width:17%;">
                    <span style="color:Red;"><asp:Literal ID="litGiftAmount" runat="server" /></span>
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="Literal9" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_DiscountValue%>" />：
                    </td><td style="width:17%;">
                    <asp:Literal ID="litDiscountActivity" Text="&nbsp;" runat="server" />
                    <span style="color:Green;"><asp:Literal ID="litDiscountValue" Text="&nbsp;" runat="server" /></span>
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="Literal8" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Freight%>" />：
                    </td><td>
                    <span style="color:Red" ><asp:Literal ID="litFreight" runat="server" /></span>
                    <asp:Literal ID="litlFreightActivity" runat="server" />
                </td>
            </tr>
            <tr>
                <td style="text-align:right;">
                    <asp:Literal ID="Literal10" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_PayCharge%>" />：
                    </td><td >
                    <span style="color:Red" ><asp:Literal ID="litPayCharge" runat="server" /></span>
                    <asp:Literal ID="litlPayChargeActivity" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_OptionPrice%>" />：
                    </td><td >
                    <span style="color:Red" ><asp:Literal ID="litOptionPrice" runat="server" /></span>
                    <asp:Literal ID="litlOptionActivity" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="Literal12" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_CouponValue%>" />：
                    </td><td>
                    <asp:Literal ID="litCouponValue" runat="server" Visible="false" />
                    <span style="color:Green;"><asp:Literal ID="litCoupon" runat="server" Text="&nbsp;" /></span>
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="Literal13" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Discount%>" />：
                    </td><td>
                    <span style="color:Green;"><asp:Literal ID="litDiscount" runat="server" /></span>
                </td>
            </tr>
            <tr>
                <td style="text-align:right;">
                    <asp:Literal ID="Literal4" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Points%>" />：
                    </td><td>
                    <asp:Literal ID="litPoints" runat="server" />
                </td>
                <td style="text-align:right;">
                    <strong><asp:Literal ID="Literal14" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_TotalPrice%>" />：</strong>
                </td>
                <td>
                    <strong style="color:Red" ><asp:Literal ID="litTotalPrice" runat="server" /></strong>
                </td>

             
            </tr>
        </table>
         </UI:TabStripTab>

        <!--收货人信息--> 
        <div style="margin-top:20px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:12px;"><asp:Literal Text="<%$Resources:OrderDetails, IDS_Title_ShippingerInfo%>" runat="server"></asp:Literal></strong>
        </div>
        <div style="background-color:#f9f9f9;margin:auto;margin-top:10px;width:98%; text-align:left;">
            <table class="GridViewStyle" style="width:100%;" >
            <tr>
                <td style="text-align:right;">
                    <asp:Literal ID="litShipTo" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_ShipTo%>" />
                </td>
                <td>
                    <asp:Literal ID="lblShipTo" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="litZipcode" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_ZipCode%>" />
                </td>
                <td>
                    <asp:Literal ID="lblZipcode" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="litTellPhone" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_TelPhone%>" />
                </td>
                <td>
                    <asp:Literal ID="lblTellPhone" runat="server" />
                </td>
            </tr>
            <tr>
                <td style="text-align:right;">
                  <asp:Literal ID="Literal3" runat="server" Text="<%$Resources:EditUserControl, IDS_FromField_lblPrivateEmail%>" />：
                </td>
                <td>
                 <asp:Literal ID="litEmailAddress" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal ID="litAddress" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_Address%>" />
                </td>
                <td>
                    <asp:Literal ID="lblRegion" runat="server" /><asp:Literal ID="lblAddress" runat="server" />
                </td>
                <td style="text-align:right;"> 
                    <asp:Literal ID="litPhone" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_CellPhone%>" />
                </td>
                <td>
                    <asp:Literal ID="lblPhone" runat="server" />
                </td>
            </tr>
            </table>

        </div>
        
        <!--购买人信息--> 
        <div style="margin-top:20px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:12px;"><asp:Literal Text="<%$Resources:OrderDetails,IDS_Field_BuyInfo%>" runat="server"></asp:Literal></strong>
        </div>
        <div style="background-color:#f9f9f9;margin:auto;margin-top:10px;width:98%; text-align:left;">
            <table class="GridViewStyle" style="width:100%;" >
            <tr>
                <td style="text-align:right;">
                    <asp:Literal runat="server" Text="<%$Resources:OrderDetails,IDS_Field_PurchaserName%>" />
                </td>
                <td>
                    <asp:Literal ID="lblPurchaser" runat="server" />
                </td>
                <td style="text-align:right;"> 
                    <asp:Literal runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_CellPhone%>" />
                </td>
                <td style="width:25%;">
                    <asp:Literal ID="lblPurchaserPhone" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_TelPhone%>" />
                </td>
                <td >
                    <asp:Literal ID="lblPurchaserTellPhone" runat="server" />
                </td>
            </tr>
            <tr>
                <td style="text-align:right;">
                  <asp:Literal runat="server" Text="<%$Resources:EditUserControl, IDS_FromField_lblPrivateEmail%>" />：
                </td>
                <td >
                 <asp:Literal ID="litPurchaserEmailAddress" runat="server" />
                </td>
                <td style="text-align:right;">
                    <asp:Literal runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_Address%>" />
                </td>
                <td >
                    <asp:Literal ID="lblPurchaserRegion" runat="server" /><asp:Literal ID="lblPurchaserAddress" runat="server" />
                </td>
                <td style="text-align:right;">&nbsp;</td>
                <td>&nbsp;</td>              
            </tr>
            <tr>
                <td style="text-align:right;">
                  <asp:Literal ID="Literal2" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Remark%>" />：
                </td>
                <td >
                    <asp:Literal ID="litRemark"  runat="server" />
                </td>
                <td style="text-align:right;">&nbsp;</td>
                <td>&nbsp;</td> 
                <td style="text-align:right;">&nbsp;</td>
                <td>&nbsp;</td>  
            </tr>
            </table>

        </div>
        </td>
        </tr>
        </table>
</UI:TabStripTab>
    
   <UI:TabStripTab ID="tabAction" runat="server" Title="订单历史操作历史">
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
            <tr><td>
        <div style="margin-top:20px; border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:Black;">
            <strong style="font-size:14px;"><asp:Literal runat="server" Text="<%$ Resources:OrderDetails,IDS_Literal_StatusActionCode %>"></asp:Literal></asp:Literal></strong>
        </div>
        <!--订单历史操作-->
        <div style="background-color:#f9f9f9;margin:auto;margin-top:10px;width:98%;">
            <table class="GridViewStyle" id="GridViewTable" style="width: 100%;" cellspacing="0" cellpadding="0" class="GridViewStyle">
                <tr>
                    <td valign="top" style="padding-bottom:5px;">
                        <asp:GridView ID="grdOrderActionHistorys" runat="server" AutoGenerateColumns="false"
                            ShowHeader="true" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow"
                            HeaderStyle-CssClass="GridViewHeaderStyle" Width="96%">
                            <Columns>
                                <asp:BoundField HeaderText="<%$ Resources:OrderDetails,IDS_grdUsername %>" DataField="Username" />
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails, IDS_grdActionCode %>"
                                    SortExpression="ActionCode">
                                    <ItemTemplate>
                                        <Hishop:OrderActionLabel ID="lblOrderAction" DataField="ActionCode" runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:OrderDetails, IDS_grdActionDate %>"
                                    SortExpression="ActionDate">
                                    <ItemTemplate>
                                        <Hishop:FormatedTimeLabel ID="lblActionDate" Time='<%#Eval("ActionDate") %>' runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </td>
                </tr>
            </table>
        </div>
       </td>
       </tr>
       </table>
 </UI:TabStripTab>
</Tabs>
        </UI:TabStrip>
 
                </SkinTemplate>
            </Hishop:OrderDetails>
        </div>
    </form>
</body>
</html>
