﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>         
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="litManagerTop" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_PageTitle %>" ></asp:Literal>
                </div>
                <div style="width: 80%;">
                     <asp:Literal ID="litManagerDisciption" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_PageDesc %>" ></asp:Literal>
                </div>
            </div>
            <Hishop:OrderLookupItems ID="OrderLookupItems" runat="server">
                <SkinTemplate>
<div class="grdHeaderStyle">
    <asp:Literal ID="lblList" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_LookupList %>"></asp:Literal>：
    <asp:Label ID="lookupListName" runat="server"></asp:Label>
</div>
<!--002 -->
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="_return"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManageOrderOptions") %>'>
                <asp:Literal ID="lblReturn" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblReturn %>"></asp:Literal>
            </a>
                <asp:LinkButton ID="lkbAddItem" runat="server"></asp:LinkButton>
            </li>
            <li class="spirtLines">|</li>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Literal ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupDelCheck">
                <Hishop:ImageLinkButton ID="lkbDelectCheck" runat="server" OnClientClick=""
                    Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:ImageLinkButton></li>
        </ul>
    </div>
            <asp:GridView ID="grdOrderLookupItems" runat="server" AutoGenerateColumns="false"
                ShowHeader="true" DataKeyNames="LookupItemId" CssClass="GridViewStyle" GridLines="None"
                RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" SelectedRowStyle-BackColor="#FBFBF4">
                <Columns>
                    <Hishop:CheckBoxColumn />
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupItems, IDS_Header_Name %>">
                        <ItemTemplate>
                            <asp:Label ID="lblLookupList" runat="server" Text='<%# Bind("Name") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupItems, IDS_Header_AppendMoeny %>">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="lblPercentageAppendMoney"></asp:Label>
                            <Hishop:FormatedMoneyLabelForAdmin ID="lblAppendMoney" runat="server" Money='<%# Bind("AppendMoney") %>'></Hishop:FormatedMoneyLabelForAdmin>
                        </ItemTemplate>
                    </asp:TemplateField>
 
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupItems, IDS_Header_UserInputTitle %>">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="lblUserInputTitle" Text='<%# Eval("UserInputTitle")%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField> 
                    
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupItems, IDS_Header_Remark %>">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="lblRemark" Text='<%# Eval("Remark")%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="30%">
                        <ItemStyle/>
                           <ItemTemplate>
                             <asp:LinkButton runat="server" CssClass="SmallCommonTextButton" ID="Edit" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit %>" />
                            <Hishop:ImageLinkButton runat="server" CssClass="SmallCommonTextButton" ID="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" OnClientClick=""></Hishop:ImageLinkButton>
                           </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
</div>
        <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
            <ul>
                <li class="addProductTmpt">
                    <asp:Literal ID="litAddLookupListItem" Text="<%$ Resources:OrderLookupItems,IDS_FromField_lblAdd %>"
                        runat="server"></asp:Literal>
                </li>
            </ul>
        </div>
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList"
            id="addItemsTable">
            <!-- 属性值名称-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblName" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblItemName %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtName" runat="server" MaxLength="64"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtNameTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetName" ContainerId="ValidatorContainer" runat="server"
                        ControlToValidate="txtName" Description="<%$ Resources:OrderLookupItems, IDS_Message_Name_Description %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OrderLookupItems, IDS_Message_Name_Description %>"
                                LowerBound="1" UpperBound="50" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <!-- 选择后是否需要用户提供信息-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblFreightCalculate" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblIsUserInputRequired %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:YesNoRadioButtonList ID="radlUserInput" runat="server" SelectedValue="false" AutoPostBack="true" />
                </td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="lblradlUserInputHelp" runat="server" Text="<%$ Resources:OrderLookupItems,IDS_FromField_lblradlUserInputHelp %>"></asp:Literal>
                    </div>
                </td>
            </tr>
            <asp:Panel ID="pnlTrue" runat="server" Visible="false">
            <!-- 用户提供信息-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblUserInputTitle" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblUserInputTitle %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtUserInputTitle" runat="server"></asp:TextBox>
                </td>
                <td class="rightTD">
                <div id="txtUserInputTitleTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTarget1" ContainerId="ValidatorContainer" runat="server"
                        ControlToValidate="txtUserInputTitle" Description="<%$ Resources:OrderLookupItems, IDS_Message_UserInputTitle_Description %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OrderLookupItems, IDS_Message_UserInputTitle_Description %>"
                                LowerBound="1" UpperBound="50" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <!-- 用户信息可否为空-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblInputNothing" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblAllowInputNothing %>"></asp:Literal>：
                </td>
                <td class="rightTD">
                    <Hishop:YesNoRadioButtonList ID="radlInputNothing" runat="server" SelectedValue="true" />
                </td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="lblInputNothingHelp" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblInputNothingHelp %>"></asp:Literal>
                    </div>
                </td>
            </tr>
            </asp:Panel>
            <!-- 附加金额-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblAppendMoneyr" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblAppendMoney %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtAppendMoney" runat="server" Text="0"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtAppendMoneyTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetAppendMoney" ContainerId="ValidatorContainer"
                        runat="server" ControlToValidate="txtAppendMoney" Description="<%$ Resources:OrderLookupItems, IDS_Message_AppendMoney_Description %>">
                        <Validators>
                            <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:OrderLookupItems, IDS_Message_AppendMoney_Description %>" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <!-- 附加金额计算方式-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblCalculateMode" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblCalculateMode %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <Hishop:CalculateModeRadioButtonList ID="radlCalculateMode" runat="server" SelectedValue="1"
                        RepeatDirection="Horizontal" />
                </td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="lblHelp06" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_CalculateModeHelp %>"></asp:Literal>
                    </div>
                </td>
            </tr>
            <!-- 选择后的显示信息-->
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="lblRemark" runat="server" Text="<%$ Resources:OrderLookupItems, IDS_FromField_lblRemark %>"></asp:Literal>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtRemark" runat="server" Width="275" Height="70" TextMode="MultiLine"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtRemarkTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetRemark" ContainerId="ValidatorContainer"
                        runat="server" ControlToValidate="txtRemark" Nullable="true" Description="<%$ Resources:OrderLookupItems, IDS_Message_Remark_Description %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OrderLookupItems, IDS_Message_Remark_Description %>" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="bottonLeftTD">
                    &nbsp;</td>
                <td class="rightTD">
                    <asp:Button ID="btnCreate" runat="server" Text="<%$ Resources:OrderLookupItems,IDS_Button_Create %>"
                        CssClass="inp_L1" OnClientClick="return PageIsValid();" />
                    <asp:Button ID="btnUpdate" runat="server" Text="<%$ Resources:OrderLookupItems,IDS_Button_Update %>"
                        CssClass="inp_L1" OnClientClick="return PageIsValid();" />
                    <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:OrderLookupItems,IDS_Button_Cancel %>"
                        CssClass="inp_L1" />
                </td>
                <td class="rightTD">
                    &nbsp;</td>
            </tr>
        </table>
                </SkinTemplate>
            </Hishop:OrderLookupItems>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
 