﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/print.css" type="text/css" media="print" />
    <link rel="stylesheet" href="../css/screen.css" type="text/css" media="screen" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script> 
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <Hishop:PrintOrder ID="PrintOrder" runat="server">
            <SkinTemplate>
                <div style="width: 96%; margin: auto; margin-top: 20px; margin-bottom: 20px;">
                    <!--订单组合信息-->
                    <table class="orderinfor" cellpadding="0" cellspacing="0" style="width: 100%">
                        <tr>
                            <th>
                                <asp:Literal ID="lblOpen" Text="<%$Resources:OrderDetails,IDS_FormField_OrderNumber%>"
                                    runat="server"></asp:Literal>：
                            </th>
                            <td>
                                <asp:Literal ID="litOrderId" runat="server" Text="--"></asp:Literal>
                            </td>
                            <th>
                                <asp:Literal ID="Literal7" Text="<%$Resources:OrderDetails,IDS_FormField_OrderDate%>"
                                    runat="server"></asp:Literal>：
                            </th>
                            <td>
                                <Hishop:FormatedTimeLabel ID="litDateTime" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal ID="Literal6" Text="<%$Resources:OrderDetails,IDS_FormField_OrderPrice%>"
                                    runat="server"></asp:Literal>：
                            </th>
                            <td>
                                <span class="price">
                                    <Hishop:FormatedMoneyLabelForAdmin ID="litOrderPrice" runat="server" /></span>
                            </td>
                            <th>
                                <asp:Literal ID="Literal4" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Points%>" />：
                            </th>
                            <td>
                                <asp:Literal ID="litPoints" runat="server" Text="--" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_ModeName%>" />：
                            </th>
                            <td>
                                <asp:Literal ID="lblModeName" runat="server" Text="--" />(<span class="price1"><asp:Literal
                                    ID="litlShipPrice" runat="server" /></span>)
                            </td>
                            <th>
                                <asp:Literal ID="litPaymentType" runat="server" Text="<%$Resources:OrderDetails, IDS_DataField_PaymentType%>" />：
                            </th>
                            <td>
                                <asp:Literal ID="lblPaymentType" runat="server" Text="--" />(<span class="price1"><asp:Literal
                                    ID="litlPaymentPrice" runat="server" /></span>)
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal ID="Literal15" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_ShipOrderNumber%>" />：
                            </th>
                            <td>
                                <asp:Literal ID="litShipOrderNumber" Text="--" runat="server" />
                            </td>
                            <th>
                                &nbsp;
                            </th>
                            <td>
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal ID="litShipTo" runat="server" Text="收货人" />：
                            </th>
                            <td>
                                <asp:Literal ID="lblShipTo" Text="--" runat="server" />
                            </td>
                            <th>
                                <asp:Literal ID="litZipcode" runat="server" Text="邮政编码" />：
                            </th>
                            <td>
                                <asp:Literal ID="lblZipcode" Text="--" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal ID="litTellPhone" runat="server" Text="电话号码" />：
                            </th>
                            <td>
                                <asp:Literal ID="lblTellPhone" Text="--" runat="server" />
                            </td>
                            <th>
                                <asp:Literal ID="litPhone" runat="server" Text="手机号码" />：
                            </th>
                            <td>
                                <asp:Literal ID="lblPhone" Text="--" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal ID="litAddress" runat="server" Text="详细地址" />：
                            </th>
                            <td colspan="3">
                                <asp:Literal ID="lblRegion" runat="server" Text="--" /><asp:Literal ID="lblAddress" runat="server" /><asp:Literal ID="litEmailAddress" runat="server" Visible="false" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal ID="Literal2" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Remark%>" />：
                            </th>
                            <td colspan="3">
                                <asp:Literal ID="litRemark" runat="server" Text="--" />
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <asp:Literal Text="<%$Resources:OrderDetails,IDS_FormField_OrderStatus%>" runat="server"></asp:Literal>：
                            </th>
                            <td colspan="3">
                                <strong>
                                    <Hishop:ActivityStatusLabel ID="lblOrderActivityStatus" runat="server" />
                                    <Hishop:PaymentStatusLabel ID="lblOrderPaymentStatus" runat="server" />
                                    <Hishop:ShippingStatusLabel ID="lblOrderShippingStatus" runat="server" />
                                    <Hishop:RefundStatusLabel ID="lblOrderRefundStatus" runat="server" /></strong>
                            </td>
                        </tr>
                    </table>
                    
                    <!--订单选项-->
                    <asp:GridView ID="grdOrderOption" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                        CssClass="shoppinglist" GridLines="None" Width="100%">
                        <Columns>
                            <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_OptionListDescription %>"
                                ItemStyle-Width="30%" HeaderStyle-HorizontalAlign="left">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%#Eval("ListDescription") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_ItemDescription %>"
                                ItemStyle-Width="20%" HeaderStyle-HorizontalAlign="left">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%#Eval("ItemDescription") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <Hishop:MoneyColumn HeaderText="<%$Resources:OrderDetails, IDS_Header_Amount%>"
                                DataField="AdjustedPrice" HeaderStyle-HorizontalAlign="Left" />
                            <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_CustomerTitle %>"
                                HeaderStyle-HorizontalAlign="left">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%#Eval("CustomerTitle") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_Header_CustomerDescription %>"
                                HeaderStyle-HorizontalAlign="left">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%#Eval("CustomerDescription") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                    
                    <!--订单的商品-->
                    <asp:DataList ID="dlstOrderItems" runat="server" Width="100%" DataKeyField="ItemId"
                        GridLines="None" CssClass="shoppinglist marginbottom" HeaderStyle-CssClass="tdliketh">
                        <HeaderTemplate >
                            <asp:Literal runat="server" Text="<%$Resources:OrderDetails,IDS_Field_SKU%>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="Literal18" runat="server" Text="<%$ Resources:OrderDetails,IDS_Header_Product %>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="litProductQuantity" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_ProductPrice%>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="litAmount" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_Point%>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="litPoints" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_BuyNum%>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="litShipQuantity" runat="server" Text="<%$ Resources:OrderDetails,IDS_Header_ShipQuantity %>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="litAllAmount" runat="server" Text="<%$Resources:OrderDetails,IDS_Field_XiaoJi%>"></asp:Literal>
                            </td>
                            <td class="tdliketh">
                                <asp:Literal ID="litRemark" runat="server" Text="<%$ Resources:OrderDetails,IDS_Header_Remartk %>"></asp:Literal>
                        </HeaderTemplate>
                        <ItemTemplate>
                            <asp:Literal ID="Literal5" runat="server" Text='<%# Convert.ToString(Eval("sku"))==""?"--":Eval("sku") %>'></asp:Literal>
                            </td>
                            <td>
                                <span style="word-break: bresak-all;">
                                    <Hishop:ProductNavigationDetails ID="productNavigationDetails1" ProductName='<%# Eval("ItemDescription") %>'
                                        ProductId='<%# Eval("ProductId") %>' runat="server" />
                                        <asp:GridView ID="grdOrderItemValues" runat="server" AutoGenerateColumns="false" CssClass="userselected"
                                            GridLines="None" Width="100%" ShowHeader="false" DataSource='<%# DataBinder.Eval(Container.DataItem, "LookupListItems") %>'>
                                            <Columns>
                                                <asp:TemplateField>
                                                    <ItemTemplate>
                                                        <asp:Label ID="Label1" runat="server" Text='<%# Eval("ListDescription") %>' />：
                                                        <asp:Label ID="Label2" runat="server" Text='<%# Eval("ItemDescription") %>' />
                                                        <span class="price1">(<Hishop:FormatedMoneyLabelForAdmin ID="FormatedMoneyLabelForAdmin1"
                                                            runat="server" Money='<%# Eval("AdjustedPrice") %>' />)
                                                    </ItemTemplate>
                                                </asp:TemplateField>
                                            </Columns>
                                        </asp:GridView>
                            </td>
                            <td>
                                <Hishop:FormatedMoneyLabelForAdmin ID="lblAmount" runat="server" Money='<%# Eval("ItemAdjustedPrice") %>' />
                            </td>
                            <td>
                                <asp:Literal ID="lblProductPoints" runat="server" Text='<%# Eval("Points") %>'></asp:Literal>
                            </td>
                            <td>
                                <asp:Literal ID="lblProductQuantity" runat="server" Text='<%# Eval("Quantity") %>'></asp:Literal>
                            </td>
                            <td>
                                <asp:Literal ID="lblShipQuantity" runat="server" Text='<%# Eval("ShipmentQuantity") %>'></asp:Literal>
                            </td>
                            <td>
                                <Hishop:FormatedMoneyLabelForAdmin ID="FormatedMoneyLabelForAdmin2" runat="server"
                                    Money='<%# (decimal)Eval("ItemAdjustedPrice")*(int)Eval("Quantity") %>' />
                            </td>
                            <td>
                                <asp:Literal ID="lblRemark" runat="server" Text='<%# Convert.ToString(Eval("Remark"))==""?"--":Eval("Remark") %>'></asp:Literal>
                        </ItemTemplate>
                    </asp:DataList>
                    
                    <div style="border:1px #000 solid;border-top:0;padding:5px;"><asp:GridView ID="grdOrderGift" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                        CssClass="giftlist" GridLines="None" DataKeyNames="GiftId" Width="100%">
                        <Columns>
                            <asp:TemplateField HeaderText="<%$ Resources:OrderDetails,IDS_grdGiftname %>" ItemStyle-Width="50%">
                                <ItemTemplate>
                                    <asp:Label ID="lblGiftName" runat="server" Text='<%#Eval("GiftName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:OrderDetails,IDS_grdGiftAdjustedPrice %>"
                                DataField="AdjustedPrice" />
                        </Columns>
                    </asp:GridView></div>
      <div style="border:1px #000 solid;border-top:0;padding:5px;">
      <ul class="pricelist">
      <li><asp:Literal ID="liter1" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Amount%>" />：<span class="pjia"><asp:Literal ID="litAmount" runat="server" /></span></li>
      <li><asp:Literal ID="Literal5" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_GiftAmount%>" />：<span class="pjia"><asp:Literal ID="litGiftAmount" runat="server" /></span></li>
      <li><asp:Literal ID="Literal9" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_DiscountValue%>" />：<asp:Literal ID="litDiscountActivity" Text="&nbsp;" runat="server" /><span class="pjian"><asp:Literal ID="litDiscountValue" Text="&nbsp;" runat="server" /></span></li>
      <li><asp:Literal ID="Literal8" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Freight%>" />：<span class="pjia"><asp:Literal ID="litFreight" runat="server" /></span><asp:Literal ID="litlFreightActivity" runat="server" /></li>
      <li><asp:Literal ID="Literal10" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_PayCharge%>" />：<span class="pjia"><asp:Literal ID="litPayCharge" runat="server" /></span><asp:Literal ID="litlPayChargeActivity" runat="server" /></li>
      <li><asp:Literal ID="Literal1" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_OptionPrice%>" />：<span class="pjia"><asp:Literal ID="litOptionPrice" runat="server" /></span><asp:Literal ID="litlOptionActivity" runat="server" /></li>
      <li><asp:Literal ID="Literal12" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_CouponValue%>" />：<asp:Literal ID="litCouponValue" runat="server" Visible="false" /><span class="pjian"><asp:Literal ID="litCoupon" runat="server" Text="--" /></span></li>
      <li><asp:Literal ID="Literal13" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_Discount%>" />：<span class="pjian"><asp:Literal ID="litDiscount" runat="server" /></span></li>
      <li><asp:Literal ID="Literal14" runat="server" Text="<%$Resources:OrderDetails, IDS_Literal_TotalPrice%>" />：<span class="price"><asp:Literal ID="litTotalPrice" runat="server" /></span></li>
      </ul><br style="clear:both;" />
</div>
                </div>
            </SkinTemplate>
        </Hishop:PrintOrder>
    </div>
    </form>
    <div class="btnbox" style="text-align: center; margin-bottom: 20px;">
        <object id="WebBrowser" classid="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2" height="0"
            width="0">
        </object>
        <input runat="server" type="button" value="<%$ Resources:OrderDetails, IDS_Field_Print %>"
            onclick="window.WebBrowser.ExecWB(6,1)" />
        <input runat="server" type="button" value="<%$ Resources:OrderDetails, IDS_Field_PrintSet %>"
            onclick="window.WebBrowser.ExecWB(8,1)" />
        <input runat="server" type="button" value="<%$ Resources:OrderDetails, IDS_Field_PrintView %>"
            onclick="window.WebBrowser.ExecWB(7,1)" />
    </div>
</body>
</html>