﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>         

            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ProductSaleRanking,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ProductSaleRanking,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:ProductSaleRanking ID="ProductSaleRanking" runat="server">
                <SkinTemplate>
                
<Hishop:SaleStatisticsSearch ID="saleStatistics" runat="Server">
    <SkinTemplate>
    <fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSearchTitle" Text="<%$ Resources:SaleStatisticsSearch, IDS_Literal_SearchTitle %>" runat="server"></asp:Literal>
    </legend>                
    <table width="60%" border="0" cellspacing="0" cellpadding="0" style="margin-left:18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblStartDate" runat="server" Text="<%$Resources:SaleStatisticsSearch,IDS_Label_StartDate %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:Calendar ID="calendarStartDate" runat="server"  />
            </td>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblEndDate" runat="server" Text="<%$ Resources:SaleStatisticsSearch,IDS_Label_EndDate %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD" colspan="2">
                <Hishop:Calendar ID="calendarEndDate" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:SaleStatisticsSearch,IDS_Label_PageSize %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server"></Hishop:PageSizeDropDownList>
            </td>            
            <td>
                <asp:Button ID="btnSearchButton" runat="server" Text="<%$ Resources:SaleStatisticsSearch,IDS_Button_Search %>" CssClass="inp_L1"/>
            </td>
            <td style="padding-left:10px;">
                <asp:Button ID="btnCreateReport" runat="server" Text="<%$ Resources:Resources ,IDS_Button_CreateReport %>" CssClass="inp_L1"/>
            </td>   
        </tr>
    </table>
</fieldset>
    </SkinTemplate>
</Hishop:SaleStatisticsSearch>

<div class="grdGroupFormList"> 

            <div class="grdGroupList">
                <Hishop:CustomGridView ID="grdProductSaleStatistics" runat="server" AutoGenerateColumns="false" ShowHeader="true" AllowSorting="true" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >                                                        
                        <Columns>       
                             <asp:TemplateField HeaderText="<%$ Resources:ProductSaleRanking,IDS_Field_IDOfSaleTotals %>" ItemStyle-Width="60">
                                <ItemTemplate>
                                    <asp:Image ID="Image1" runat="server" ImageUrl='<%# Convert.ToInt32(Eval("IDOfSaleTotals"))==1?"../images/n1.jpg":Convert.ToInt32(Eval("IDOfSaleTotals"))==2?"../images/n2.jpg":"../images/n3.jpg" %>'
                                     Visible='<%#Convert.ToInt32(Eval("IDOfSaleTotals"))<4 %>' /> <strong><%#Eval("IDOfSaleTotals")%></strong>
                                </ItemTemplate>
                            </asp:TemplateField>                                                                                                                                                                                                                                                                                                                                                           
                            <asp:BoundField HeaderText="<%$ Resources:ProductSaleRanking,IDS_Field_ProductName %>" DataField="ProductName" />   
                             <asp:TemplateField HeaderText="<%$ Resources:ProductSaleRanking,IDS_Field_SKU %>" >
                                <ItemTemplate>
                                    <asp:Label ID="lblBuyCount"  runat="Server" Text='<%# Eval("SKU") %>' />
                                </ItemTemplate>
                            </asp:TemplateField>   
                              <asp:TemplateField HeaderText="<%$ Resources:ProductSaleRanking,IDS_Field_ProductSaleCounts %>" ItemStyle-Width="20%">
                                <ItemTemplate>
                                    <asp:Label ID="lblBuyCount"  runat="Server" Text='<%# Eval("ProductSaleCounts") %>' />
                                </ItemTemplate>
                            </asp:TemplateField>  
                               <asp:TemplateField HeaderText="<%$ Resources:ProductSaleRanking,IDS_Field_ProductSaleTotals %>" ItemStyle-Width="20%">
                                <ItemTemplate>
                                    <Hishop:FormatedMoneyLabelForAdmin Money='<%#Eval("ProductSaleTotals") %>' runat="server" ></Hishop:FormatedMoneyLabelForAdmin>
                                </ItemTemplate>
                            </asp:TemplateField> 
                             <asp:TemplateField HeaderText="<%$ Resources:ProductSaleRanking,IDS_Field_ProductSaleEqualityPrice %>" ItemStyle-Width="20%">
                                <ItemTemplate>
                                    <Hishop:FormatedMoneyLabelForAdmin Money='<%# (Convert.ToDecimal(Eval("ProductSaleTotals"))/ Convert.ToDecimal(Eval("ProductSaleCounts"))) %>' runat="server" ></Hishop:FormatedMoneyLabelForAdmin>
                                </ItemTemplate>
                            </asp:TemplateField>     
                        </Columns>
                </Hishop:CustomGridView>
            </div>
            <div class="grdGroupTabhead">
                <UI:Pager runat="server" ListToPaging="grdProductSaleStatistics" ID="pager" />
            </div>

 </div> 
                </SkinTemplate>
            </Hishop:ProductSaleRanking>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
