﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>         
 
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ProductSaleStatistics,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ProductSaleStatistics,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:ProductSaleStatistics ID="productSaleStatistics" runat="server">
                <SkinTemplate>
                
<Hishop:SaleStatisticsSearch ID="saleStatistics" runat="Server">
    <SkinTemplate>
    <fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSearchTitle" Text="<%$ Resources:SaleStatisticsSearch, IDS_Literal_SearchTitle %>" runat="server"></asp:Literal>
    </legend>                
    <table width="60%" border="0" cellspacing="0" cellpadding="0" style="margin-left:18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:SaleStatisticsSearch,IDS_Label_PageSize %>"></asp:Label></nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server"></Hishop:PageSizeDropDownList>
            </td>            
            <td>
                <asp:Button ID="btnSearchButton" runat="server" Text="<%$ Resources:SaleStatisticsSearch,IDS_Button_Search %>" CssClass="inp_L1"/>
                <asp:Button ID="btnCreateReport" runat="server" Text="<%$ Resources:Resources ,IDS_Button_CreateReport %>" CssClass="inp_L1"/>
            </td>
        </tr>
    </table>
</fieldset>
    </SkinTemplate>
</Hishop:SaleStatisticsSearch>

<div class="grdGroupFormList"> 

            <div class="grdGroupList">
                <Hishop:CustomGridView ID="grdProductSaleStatistics" runat="server" AutoGenerateColumns="false" ShowHeader="true" AllowSorting="true" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >                                                        
                        <Columns>                                                                                                                                                                                                                                                                                                                                                                  
                            <asp:BoundField HeaderText="<%$ Resources:ProductSaleStatistics,IDS_grdProductName %>" DataField="ProductName" />    
                            <asp:BoundField HeaderText="<%$ Resources:ProductSaleStatistics,IDS_Field_VistiCounts %>" DataField="VistiCounts" ItemStyle-Width="25%" />
                             <asp:TemplateField HeaderText="<%$ Resources:ProductSaleStatistics,IDS_Field_BuyCount %>" ItemStyle-Width="25%">
                                <ItemTemplate>
                                    <asp:Label ID="lblBuyCount"  runat="Server" Text='<%# Eval("BuyCount") %>' />
                                </ItemTemplate>
                            </asp:TemplateField> 
                            <asp:TemplateField HeaderText="<%$ Resources:ProductSaleStatistics,IDS_Field_Percentage %>"  ItemStyle-Width="25%">
                                <ItemTemplate>
                                    <asp:Label ID="lblProductSalePercentage" Text='<%# Convert.ToDecimal(Eval("BuyPercentage")).ToString("F") %>' runat="Server"/>%
                                </ItemTemplate>
                            </asp:TemplateField>    
                        </Columns>
                </Hishop:CustomGridView>
            </div>
            <div class="grdGroupTabhead">
               <UI:Pager runat="server" ListToPaging="grdProductSaleStatistics" ID="pager" />
            </div>

 </div> 
                </SkinTemplate>
            </Hishop:ProductSaleStatistics>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
