﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
          
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:SaleList, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:SaleList, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:SaleList ID="SaleList" runat="server" >
                <SkinTemplate>
                <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

                    <div class="grdGroupFormList"> 

                        <fieldset class="AdminSearchform">
                            <legend>
                                <asp:Literal runat="server"  Text="<%$ Resources:SaleList, IDS_Title_Search %>"></asp:Literal>
                            </legend>                
                            <table width="60%" border="0" cellspacing="0" cellpadding="0" style="margin-left:18px">
                                <tr>
                                    <td class="searchTableLeftTD">
                                        <nobr><asp:Literal runat="server"  Text="<%$ Resources:SaleList, IDS_Field_DateStart %>"></asp:Literal></nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:Calendar ID="calendarStart" runat="server"  />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr><asp:Literal runat="server"  Text="<%$ Resources:SaleList, IDS_Field_DateEnd %>"></asp:Literal></nobr>
                                    </td>
                                    <td class="searchTableControlTD" >
                                        <Hishop:Calendar ID="calendarEnd" runat="server" />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr><asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:SaleList, IDS_Field_PageSize %>"></asp:Label></nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server"></Hishop:PageSizeDropDownList>
                                    </td>            
                                    <td>
                                        <asp:Button ID="btnQuery" runat="server" Text="<%$ Resources:Resources, IDS_Button_Search %>" CssClass="inp_L1"/>
                                    </td>
                                    <td style="padding-left:10px;">
                                        <asp:Button ID="btnCreateReport" runat="server" Text="<%$ Resources:Resources ,IDS_Button_CreateReport %>" CssClass="inp_L1"/>                                    
                                    </td>
                                </tr>
                            </table>
                        </fieldset>

                        <div class="grdGroupList">
                            <Hishop:CustomGridView ID="grdOrderLineItem" runat="server" AutoGenerateColumns="false" ShowHeader="true" AllowSorting="true" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >                                                        
                                    <Columns>                                                                                                                                                                                                                                                                                                                                                                  
                                        <asp:BoundField HeaderText="<%$ Resources:SaleList, IDS_Field_ProductName %>" DataField="ProductName" />    
                                        <asp:BoundField HeaderText="<%$ Resources:SaleList, IDS_Field_OrderId %>" DataField="OrderId" ItemStyle-Width="25%" />
                                        <asp:BoundField HeaderText="<%$ Resources:SaleList, IDS_Field_Quantity %>" DataField="Quantity" ItemStyle-Width="25%" />
                                        <asp:TemplateField HeaderText="<%$ Resources:SaleList, IDS_Field_Price %>" >
                                            <ItemTemplate>
                                                <asp:Label ID="lblProductSalePercentage" Text='<%# Convert.ToDecimal(Eval("ItemAdjustedPrice")).ToString("F") %>' runat="Server"/>%
                                            </ItemTemplate>
                                        </asp:TemplateField>    
                                        <asp:TemplateField HeaderText="<%$ Resources:SaleList, IDS_Field_SaleDate %>"  >
                                            <ItemTemplate>
                                                <%# Eval("orderDate") %>
                                            </ItemTemplate>
                                        </asp:TemplateField>    
                                    </Columns>
                            </Hishop:CustomGridView>
                        </div>
                        <div class="grdGroupTabhead">
                           <UI:Pager runat="server" ID="pager" />
                        </div>

                     </div> 
                     
                </SkinTemplate>            
            </Hishop:SaleList>
             </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
 
 