﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ArticleCategories,IDS_PageTitle %>"></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ArticleCategories,IDS_PageDesc %>"></asp:Literal>
            </div>
        </div>
        <Hishop:ArticleCategories ID="ArticleCategories" runat="server">
            <SkinTemplate>
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <div class="grdGroupFormList">
                    <div class="grdGroupList">
                        <Hishop:CustomGridView ID="grdArticleCategories" runat="server" AutoGenerateColumns="false"
                            ShowHeader="true" DataKeyNames="CategoryId" CssClass="GridViewStyle" GridLines="None"
                            RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                            <SelectedRowStyle BackColor="#FBFBF4" />
                            <Columns>
                                <asp:TemplateField ItemStyle-Width="20px">
                                    <ItemTemplate>
                                        <Hishop:Common_Image ID="Common_Image1" EnabledTimestamp="true" runat="server" DataField="IconUrl" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:ArticleCategories,IDS_Header_CategoryId%>"
                                    ItemStyle-Width="20%">
                                    <ItemTemplate>
	                                   <asp:Literal ID="lblCategoryId" runat="server" Text='<%#Eval("CategoryId") %>'></asp:Literal>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:HelpCategories,IDS_Header_CategoryName %>"
                                    ItemStyle-Width="40%">
                                    <ItemTemplate>
                                        <asp:Literal ID="lblCategoryName" runat="server" Text='<%#Eval("Name") %>'></asp:Literal>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <Hishop:SortImageColumn HeaderText="<%$Resources:HelpCategories,IDS_Header_HelpCategoryDisplay  %>"
                                    ReadOnly="true" />
                                 <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="20%">
                                     <ItemStyle/>
                                     <ItemTemplate>
			                           <asp:LinkButton CssClass="SmallCommonTextButton" ID="lkEdit" Text="<%$ Resources:Resources, IDS_Button_Edit %>" CommandName="Edit" runat="server"></asp:LinkButton></li>
			                           <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" ID="lkDelete" Text="<%$ Resources:Resources, IDS_Button_Delete %>"  CommandName="Delete" runat="server" /></li>
                                     </ItemTemplate>
                                 </asp:TemplateField>  
                            </Columns>
                        </Hishop:CustomGridView>
                    </div>
                </div>
                <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
                    <ul>
                        <li class="addArticleClass">
                            <asp:Label ID="lblAddArticleCategoryiesTitle" Text='<%$Resources:ArticleCategories,IDS_Label_AddArticleCategoryiesTitle %>'
                                runat="server"></asp:Label>
                        </li>
                    </ul>
                </div>
                <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList"
                    id="addItemsTable">
                    <tr>
                        <td class="leftTD">
                            <asp:Literal ID="lblArticleCategoryiesName" Text="<%$Resources:ArticleCategories,IDS_FormField_ArticleCategoryiesName %>"
                                runat="server"></asp:Literal>：
                        </td>
                        <td class="rightTD">
                            <asp:TextBox ID="txtArticleCategoryiesName" CssClass="input_short" runat="server"></asp:TextBox>
                        </td>
                        <td class="rightTD">
                            <div id="txtArticleCategoryiesNameTip" runat="server">
                            </div>
                            <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" ContainerId="ValidatorContainer"
                                ControlToValidate="txtArticleCategoryiesName" Description="<%$Resources:ArticleCategories,IDS_ErrorMessage_ArticleCategoryName %>"
                                Nullable="false" FocusMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_ArticleCategoryName %>">
                                <Validators>
                                    <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_ArticleCategoryName %>"
                                        LowerBound="1" UpperBound="100" />
                                </Validators>
                            </Hishop:ValidateTarget>
                        </td>
                    </tr>
                    <tr>
                        <td class="leftTD">
                            <asp:Literal ID="lblArticleCategoryiesImg" Text='<%$Resources:ArticleCategories,IDS_FormField_ArticleCategoryiesImg %>'
                                runat="server"></asp:Literal>：
                        </td>
                        <td class="rightTD">
                            <asp:FileUpload ID="fileUpload" CssClass="input_longest" runat="server" />
                        </td>
                        <td class="rightTD">
                            <div class="msgNormal">
                                <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="leftTD">
                            <asp:Literal ID="lblDisplaySequence" Text='<%$Resources:ArticleCategories,IDS_FormField_ArticleCategoryiesOrder %>'
                                runat="server"></asp:Literal>：
                        </td>
                        <td class="rightTD">
                            <asp:TextBox ID="txtDisplaySequence" Text="1" CssClass="input_short" runat="server"></asp:TextBox>
                        </td>
                        <td class="rightTD">
                            <div id="txtDisplaySequenceTip" runat="server">
                            </div>
                            <Hishop:ValidateTarget ID="ValidateTarget2" runat="server" ControlToValidate="txtDisplaySequence"
                                ContainerId="ValidatorContainer" Description="<%$Resources:ArticleCategories,IDS_ErrorMessage_DisplaySequence %>"
                                Nullable="false" FocusMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_DisplaySequence %>">
                                <Validators>
                                    <Hishop:InputNumberClientValidator ErrorMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_DisplaySequence %>" />
                                    <Hishop:NumberRangeClientValidator ErrorMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_DisplaySequence %>"
                                        MinValue="1" MaxValue="65535" />
                                </Validators>
                            </Hishop:ValidateTarget>
                        </td>
                    </tr>
                    <tr>
                        <td class="leftTD">
                            <asp:Literal ID="lblArticleCategoryiesDesc" Text='<%$Resources:ArticleCategories,IDS_FormField_ArticleCategoryiesDesc %>'
                                runat="server"></asp:Literal>：
                        </td>
                        <td class="rightTD">
                            <asp:TextBox ID="txtArticleCategoryiesDesc" TextMode="MultiLine" CssClass="input_longest"
                                Height="70px" runat="server"></asp:TextBox>
                        </td>
                        <td class="rightTD">
                            <div id="txtArticleCategoryiesDescTip" runat="server">
                            </div>
                            <Hishop:ValidateTarget ID="ValidateTarget3" runat="server" ControlToValidate="txtArticleCategoryiesDesc"
                                ContainerId="ValidatorContainer" Description="<%$Resources:ArticleCategories,IDS_ErrorMessage_ArticleCategoryDesc %>"
                                Nullable="true" FocusMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_ArticleCategoryDesc %>">
                                <Validators>
                                    <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:ArticleCategories,IDS_ErrorMessage_ArticleCategoryDesc %>"
                                        LowerBound="1" UpperBound="1000" />
                                </Validators>
                            </Hishop:ValidateTarget>
                        </td>
                    </tr>
                    <tr>
                        <td class="bottonLeftTD">
                            &nbsp;
                        </td>
                        <td class="rightTD">
                            <asp:Button ID="btnSubmitArticleCategory" runat="server" OnClientClick="return PageIsValid();"
                                Text="<%$ Resources:ArticleCategories, IDS_Button_AddArticleCategory%>" CssClass="inp_L1" />
                            <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:Resources, IDS_Button_Cancel%>"
                                CssClass="inp_L1" />
                        </td>
                    </tr>
                </table>
            </SkinTemplate>
        </Hishop:ArticleCategories>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
</asp:content>