﻿<%@ Page Language="C#" AutoEventWireup="false" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>  
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:EditManager,IDS_PageTitle %>"></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:EditManager,IDS_PageDesc %>" />
            </div>
        </div>
        <Hishop:EditManager ID="EditManager" runat="server">
            <SkinTemplate>
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <UI:TabStrip runat="server" ID="tabStrip" Width="100%">
            <Tabs>
            <UI:TabStripTab ID="TabStripTab1" runat="server" Title="基本信息">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
                <tr>
                    <!--身份标识编号-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblIdentification" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblIdentification%>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                        <asp:Literal ID="lblIdentificationValue" runat="server"></asp:Literal></td>
                </tr>
                <tr>
                    <!--登录名-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblLoginName" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblLoginName %>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                        <asp:Literal ID="lblLoginNameValue" runat="server"></asp:Literal></td>
                </tr>
                <tr>
                    <!--下次访问时强制登录-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblMandatoryLogin" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblMandatoryLogin %>"></asp:Literal></td>
                    <td class="rightTD">
                        <Hishop:YesNoRadioButtonList ID="radlMandatoryLogin" runat="server" />
                    </td>
                    <td class="rightTD">
                        <div class="msgNormal">
                            <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:EditManager,IDS_Message_MandatoryLogin %>"></asp:Literal>
                        </div>
                    </td>
                </tr>
                <tr>
                    <!--注册日期-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblRegsTime" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblRegsTime %>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                        <Hishop:FormatedTimeLabel ID="lblRegsTimeValue" runat="server"></Hishop:FormatedTimeLabel></td>
                    <!-- 结束-->
                </tr>
                <tr>
                    <!--最后登录日期-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblLastLoginTime" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblLastLoginTime %>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                         <Hishop:FormatedTimeLabel ID="lblLastLoginTimeValue" runat="server"></Hishop:FormatedTimeLabel></td>
                    <!-- 结束-->
                </tr>
                <tr>
                    <!--最后访问日期-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblLastvisitTime" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblLastvisitTime %>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                         <Hishop:FormatedTimeLabel ID="lblLastVisitTimeValue" runat="server"></Hishop:FormatedTimeLabel></td>
                    <!-- 结束-->
                </tr>
                <tr>
                    <td class="bottonLeftTD">
                        &nbsp;</td>
                    <td class="rightTD">
                        <table>
                            <tr>
                                <td valign="top" style="padding-top: 5px;">
                                    <asp:Button ID="btnEditManagerAccount" runat="server" Text="<%$ Resources:EditManager, IDS_Button_EditAccount %>"
                                        OnClientClick="return PageIsValid('validatAccount');" CssClass="inp_L1" /></td>
                                <td>
                                    <div class="return_inp">
                                        <a href='<%= SiteUrls.Instance().UrlData.FormatUrl("admin_Managers")%>'>
                                            <asp:Label ID="Literal3" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblReturn %>"></asp:Label></a>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td class="rightTD">
                        &nbsp;</td>
                </tr>
            </table>
            </UI:TabStripTab>
<UI:TabStripTab ID="TabStripTab2" runat="server" Title="个人资料">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
                <tr>
                    <!--真实姓名-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblRealName" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblRealName %>"></asp:Literal></td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtRealName" runat="server" MaxLength="100"></asp:TextBox></td>
                    <td class="rightTD">
                        <div id="txtRealNameTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="valrRealName" runat="server" ContainerId="ValidatorContainer"
                            ControlToValidate="txtRealName" Description="<%$ Resources:EditManager, IDS_Message_RealName_Desciption %>"
                            Nullable="true" ValidateGroup="validatAccount">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:EditManager, IDS_Message_RealName_Desciption %>"
                                    LowerBound="0" UpperBound="100" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                    <!-- 结束-->
                </tr>
                <tr>
                    <!--生日-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblBirthday" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblBirthday %>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                        <Hishop:Calendar ID="calBirthday" runat="server" CssClass="Wdate" />
                        <!--结束-->
                    </td>
                </tr>
                <tr>
                    <!--性别-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblSex" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblSex %>"></asp:Literal></td>
                    <td colspan="2" class="rightTD">
                        <Hishop:GenderRadioButtonList runat="server" ID="gender" RepeatDirection="Horizontal" />
                    </td>
                    <!--结束-->
                </tr>
                <tr>
                    <!--电子邮件地址-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblprivateEmail" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblPrivateEmail%>"></asp:Literal></td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtprivateEmail" Width="220px" runat="server"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtprivateEmailTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateTarget3" runat="server" ContainerId="ValidatorContainer"
                            ControlToValidate="txtprivateEmail" ValidateGroup="groupProfile" Description="<%$ Resources:AddUserControl,IDS_Message_Email_Description %>">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:AddUserControl,IDS_ErrorMessage_Email_ErrorMessage %>"
                                    Regex="([a-zA-Z\\.0-9_-])+@([a-zA-Z0-9_-])+((\\.[a-zA-Z0-9_-]{2,3}){1,2})" LowerBound="1"
                                    UpperBound="100" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <tr>
                    <!--   操作按钮 -->
                    <td class="bottonLeftTD">
                        &nbsp;</td>
                    <td class="rightTD">
                        <table>
                            <tr>
                                <td valign="top" style="padding-top: 5px;">
                                    <asp:Button ID="btnEditProfile" runat="server" Text="<%$ Resources:EditManager, IDS_Button_EditProfile %>"
                                        OnClientClick="return PageIsValid('groupProfile');" CssClass="inp_L1" /></td>
                                <td>
                                    <div class="return_inp">
                                        <a href='<%= SiteUrls.Instance().UrlData.FormatUrl("admin_Managers")%>'>
                                            <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblReturn %>"></asp:Literal></a>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td class="rightTD">
                        &nbsp;</td>
                </tr>
            </table>
             </UI:TabStripTab>
<UI:TabStripTab ID="TabStripTab3" runat="server" Title="安全设置">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="pageArtInfo">
                <tbody>
                    <tr>
                        <td style="width: 50px">
                            <img src="../images/loginPasswordIcon.gif" alt="" /></td>
                        <td class="pageArtText">
                            <asp:Literal ID="lblUpdatePasssword" runat="server" Text="<%$ Resources:EditManager,IDS_FromField_lblUpdatePassword %>"></asp:Literal></td>
                    </tr>
                </tbody>
            </table>
            <!--旧密码-->
            <asp:Panel ID="panelOld" runat="server">
                <table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
                    <tr>
                        <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                            <asp:Literal ID="lblOldPassWord" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblOldPassWord %>"></asp:Literal></td>
                        <td colspan="2" class="rightTD">
                            <asp:TextBox ID="txtOldPassWord" runat="server" TextMode="Password"></asp:TextBox></td>
                    </tr>
                </table>
            </asp:Panel>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
                <tr>
                    <!--新密码-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblNewPassWord" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblNewPassWord %>"></asp:Literal></td>
                    <td class="rightTD">
                        <asp:TextBox runat="server" ID="txtNewPassWord" TextMode="Password"></asp:TextBox></td>
                    <td class="rightTD">
                        <div id="txtNewPassWordTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validateTargetPassword" runat="server" ContainerId="ValidatorContainer"
                            ControlToValidate="txtNewPassWord" Description="<%$ Resources:EditManager, IDS_Message_Password_Description %>"
                            ValidateGroup="groupPassword">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:EditManager, IDS_Message_Password_Description %>"
                                    LowerBound="6" UpperBound="20" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <tr>
                    <!--重复密码-->
                    <td align="right" class="leftTD" style="height: 40px; width: 141px;">
                        <asp:Literal ID="lblPassWordCompare" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblPassWordCompare %>"></asp:Literal></td>
                    <td class="rightTD">
                        <asp:TextBox runat="server" ID="txtPassWordCompare" TextMode="Password"></asp:TextBox></td>
                    <td class="rightTD">
                        <div id="txtPassWordCompareTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateTargetPassWordCompar" runat="server" ContainerId="ValidatorContainer"
                            ControlToValidate="txtPassWordCompare" Description="<%$ Resources:EditManager, IDS_Message_PasswordAgain_Description %>"
                            Nullable="false" ValidateGroup="groupPassword">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:EditManager, IDS_Message_PasswordAgain_ErrorMessage %>"
                                    LowerBound="6" UpperBound="20" />
                                <Hishop:CompareClientValidator DestinationId="txtNewPassWord" ErrorMessage="<%$ Resources:EditManager, IDS_Message_PasswordAgain_ErrorMessage %>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <tr>
                    <!--修改确定-->
                    <td class="bottonLeftTD">
                        &nbsp;</td>
                    <td class="rightTD">
                        <table>
                            <tr>
                                <td valign="top" style="padding-top: 5px;">
                                    <asp:Button ID="btnEditPassWordOK" runat="server" Text="<%$ Resources:EditManager, IDS_Button_EditPassword%>"
                                        OnClientClick="return PageIsValid('groupPassword');" CssClass="inp_L1" /></td>
                                <td>
                                    <div class="return_inp">
                                        <a href='<%= SiteUrls.Instance().UrlData.FormatUrl("admin_Managers")%>'>
                                            <asp:Literal ID="litlReturn" runat="server" Text="<%$ Resources:EditManager, IDS_FromField_lblReturn %>"></asp:Literal></a>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td class="rightTD">
                        &nbsp;</td>
                </tr>
            </table>
             </UI:TabStripTab>
</Tabs>
        </UI:TabStrip>
            </SkinTemplate>
        </Hishop:EditManager>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
