﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:HelpCategories,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:HelpCategories,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:HelpCategories ID="HelpCategories" runat="server">
            <SkinTemplate>
<Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdGroupFormList">    
   <div class="grdHeaderStyle">
	     <ul>
	           <li class="addHelpCategories">
	             <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_CreateHelp")%>'><asp:Literal ID="lblAddHelpCategory" runat="server" Text="<%$ Resources:HelpCategories, IDS_Label_AddHelp %>"></asp:Literal></a></li>
	           <li class="spirtLines">|</li>
	           <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
	           <li class="spirtLines">|</li>
	           <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
	           <li class="spirtLines">|</li>
	           <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
	     </ul>
    </div>
    <div class="grdGroupList">
        <div class="grdGroupListLi">
               <Hishop:CustomGridView ID="grdHelpCategories" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="CategoryId" CssClass="GridViewStyle" GridLines="None" 
                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >                                    
                    <SelectedRowStyle BackColor="#FBFBF4" />
                    <Columns>
                        <Hishop:CheckBoxColumn ReadOnly="true"/>
                        <asp:TemplateField HeaderText="<%$ Resources:HelpCategories,IDS_Header_CategoryName %>" ItemStyle-Width="40%">
                           <ItemTemplate>
                              <div>
                                 <Hishop:Common_Image runat="server" EnabledTimestamp="true" DataField="IconUrl"  />
                              </div>
	                          <asp:Literal id="lblCategoryName" runat="server" Text='<%#Eval("Name") %>'></asp:Literal>
                           </ItemTemplate>
                        </asp:TemplateField>
                        <Hishop:SortImageColumn  HeaderText="<%$Resources:HelpCategories,IDS_Header_HelpCategoryDisplay  %>" ReadOnly="true"/>
                        <Hishop:YesNoImageColumn DataField="IsShowFooter" HeaderText="<%$ Resources:HelpCategories,IDS_FormField_ShowFooter %>"></Hishop:YesNoImageColumn>
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                <ItemStyle/>
                                <ItemTemplate>
			                       <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_addhelp",Eval("CategoryId")) %>' class="SmallCommonTextButton"><asp:Literal ID="lblAddArticle" Text="<%$ Resources:HelpCategories, IDS_Label_AddHelp %>" runat="server"></asp:Literal></a>
			                       <asp:LinkButton ID="lkEdit" CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Edit %>" CommandName="Edit" runat="server"></asp:LinkButton>
			                       <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" ID="lkDelete" Text="<%$ Resources:Resources, IDS_Button_Delete %>"  CommandName="Delete" runat="server" />
                                </ItemTemplate>
                            </asp:TemplateField>
                    </Columns>
                </Hishop:CustomGridView>
      </div>
    </div>
 </div>

      <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
        <ul>
            <li class="addHelpCategories">
                <asp:Label ID="lblHelpCategoryTitle" Text='<%$Resources:HelpCategories,IDS_Label_AddHelpCategoryTitle %>' runat="server"></asp:Label>
            </li>
        </ul>
  </div>
          <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
	         <tr>
		        <td class="leftTD">
			         <asp:Label ID="lblArticleCategoryId" runat="server" style="display:none"></asp:Label>
			        <asp:Literal ID="lblArticleCategoryName" Text='<%$Resources:HelpCategories,IDS_FormField_HelpCategoryName %>' runat="server"></asp:Literal>：
		        </td>
		        <td class="rightTD"><asp:TextBox ID="txtHelpCategoryName" CssClass="input_short" runat="server"></asp:TextBox></td>
		        <td class="rightTD">
			        <div id="txtHelpCategoryNameTip" runat="server"></div>
                    <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtHelpCategoryName" Description="<%$Resources:HelpCategories,IDS_ErrorMessage_HelpCategoryName %>" Nullable="false" FocusMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_HelpCategoryName %>">
                          <Validators>
                              <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_HelpCategoryName%>" LowerBound="1" UpperBound="100" />
                          </Validators>
                    </Hishop:ValidateTarget>
		        </td>
	          </tr>
               <tr>
                  <td class="leftTD"><asp:Literal ID="lblHelpCategoryIcon" Text='<%$Resources:HelpCategories,IDS_FormField_HelpCategoryImg %>' runat="server"></asp:Literal>：</td>
                  <td class="rightTD"><asp:FileUpload ID="fileUpload" CssClass="input_longest" runat="server" /></td>
                    <td class="rightTD">
                      <div class="msgNormal">
                        <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
                      </div>
                     </td>
               </tr>
               <tr>
                  <td class="leftTD"><asp:Literal ID="lblDisplaySequence" Text='<%$Resources:HelpCategories,IDS_FormField_HelpCategoryOrder %>' runat="server"></asp:Literal>：</td>
                  <td class="rightTD"><asp:TextBox ID="txtDisplaySequence" Text="1" CssClass="input_short" runat="server"></asp:TextBox></td>
                  <td class="rightTD">
                       <div id="txtDisplaySequenceTip" runat="server"></div>
                       <Hishop:ValidateTarget runat="server" ControlToValidate="txtDisplaySequence" ContainerId="ValidatorContainer" Description="<%$Resources:HelpCategories,IDS_ErrorMessage_DisplaySequence %>" Nullable="false" FocusMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_DisplaySequence %>">
                            <Validators>
                                 <Hishop:InputNumberClientValidator ErrorMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_DisplaySequence %>" />
                                 <Hishop:NumberRangeClientValidator ErrorMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_DisplaySequence %>" MinValue="1" MaxValue="65535" />
                            </Validators>
                       </Hishop:ValidateTarget>
                   </td>
                </tr>
                 <tr>
                  <td class="leftTD"><asp:Literal ID="lblIsShowFooter" Text='<%$Resources:HelpCategories,IDS_FormField_ShowFooter %>' runat="server"></asp:Literal>：</td>
                  <td class="rightTD"><Hishop:YesNoRadioButtonList id="radioShowFooter" runat="server"></Hishop:YesNoRadioButtonList></td>
                  <td class="rightTD">
                       <label class="msgNormal"><asp:Literal ID="lblShowFooter" Text="<%$Resources:HelpCategories,IDS_ErrorMessage_ShowFooter %>" runat="server"></asp:Literal></label>
                   </td>
                </tr>
                <tr>
                   <td class="leftTD"><asp:Literal ID="lblHelpCategoryiesDesc" Text='<%$Resources:HelpCategories,IDS_FormField_HelpCategoryDesc %>' runat="server"></asp:Literal>：</td>
                   <td class="rightTD"><asp:TextBox ID="txtHelpCategoryDesc" TextMode="MultiLine" CssClass="input_longest" Height="70px" runat="server"></asp:TextBox></td>
                   <td class="rightTD">
                        <div id="txtHelpCategoryDescTip" runat="server"></div>
                        <Hishop:ValidateTarget runat="server" ControlToValidate="txtHelpCategoryDesc" ContainerId="ValidatorContainer" Description="<%$Resources:HelpCategories,IDS_ErrorMessage_HelpCategoryDesc %>" Nullable="true" FocusMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_HelpCategoryDesc %>">
                              <Validators>
                                   <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:HelpCategories,IDS_ErrorMessage_HelpCategoryDesc %>" LowerBound="1" UpperBound="1000" />
                              </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <tr>
                    <td class="bottonLeftTD">&nbsp;</td>
                    <td class="rightTD">
                          <asp:Button ID="btnSubmitHelpCategory" runat="server" OnClientClick="return PageIsValid();" Text="<%$ Resources:Resources, IDS_Button_Add%>" CssClass="inp_L1"/>
                        <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1"/>
                    </td>
                 </tr>           
 </table>
            </SkinTemplate>
            </Hishop:HelpCategories>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>