﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
                <form id="form1" runat="server">
                    <div>
                        <div class="PageTitleArea">
                            <div class="PageTitle">
                                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:HelpList,IDS_PageTitle %>"></asp:Literal>
                            </div>
                            <div style="width: 80%;">
                                <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:HelpList,IDS_PageDesc %>"></asp:Literal>
                            </div>
                        </div>
                        <Hishop:HelpList ID="HelpList" runat="server">
                        <SkinTemplate>
                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
            <fieldset class="AdminSearchform">       
                <legend>
                    <asp:Literal ID="lblSearchTitle" Text="<%$Resources:HelpList,IDS_Label_SearChTitle %>" runat="server"></asp:Literal>
                </legend>                
                <table width="50%" border="0" cellspacing="0" cellpadding="0" style="margin-left:10px">
                    <tr>
                        <td class="searchTableLeftTD">
                            <nobr><asp:Literal ID="lblHelpKeyWords" Text="<%$Resources:HelpList,IDS_Label_SearChKeyWords %>" runat="server"></asp:Literal>：</nobr>
                        </td>
                        <td class="searchTableControlTD">
                            <Hishop:DefaultButtonTextBox ID="txtkeyWords" runat="server" Button="btnQueryProductTemplet"></Hishop:DefaultButtonTextBox>
                        </td>
                        <td class="searchTableLeftTD">
                            <nobr><asp:Literal ID="lblHelpCategorys" Text="<%$Resources:HelpList,IDS_Label_HelpCategory %>" runat="server"></asp:Literal>：</nobr>
                        </td>
                        <td class="searchTableControlTD">
                            <Hishop:HelpCategoryDropDownList ID="dropHelpCategory" runat="server" Width="158px"></Hishop:HelpCategoryDropDownList>
                        </td>
                        <td class="searchTableLeftTD"><nobr><asp:Literal ID="lblPageSize" Text="<%$Resources:HelpList,IDS_Label_PageSize %>" runat="server"></asp:Literal>：</nobr></td>
                       <td class="searchTableControlTD"><Hishop:PageSizeDropDownList ID="dropPageSize" runat="server"></Hishop:PageSizeDropDownList></td>
                    </tr>
                    <tr>
                       <td class="searchTableLeftTD"><nobr><asp:Literal ID="lblhelpTime" Text="<%$Resources:HelpList,IDS_Label_HelpStartTime %>" runat="server"></asp:Literal></nobr>：</td>
                       <td class="searchTableControlTD"><Hishop:Calendar CssClass="Wdate" runat="server" ID="calendarStartDataTime" /></td>
                       <td align="center"><nobr><asp:Literal ID="lblTo" Text="<%$Resources:HelpList,IDS_Label_To %>" runat="server"></asp:Literal></nobr></td>
                       <td class="searchTableControlTD"><Hishop:Calendar CssClass="Wdate" runat="server" ID="calendarEndDataTime" /></td>
                       <td></td>
                       <td><asp:Button ID="btnSearch" runat="server" Text="<%$Resources:HelpList,IDS_Button_SearCh %>" CssClass="inp_L1"/></td>
                    </tr>
                </table>
            </fieldset>

            <div class="grdGroupFormList">    
            <div class="grdHeaderStyle">
                 <ul>
                     <li class="addHelpCategories">
                        <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_Createhelp")%>'><asp:Literal runat="server" ID="lblAddHelp" Text="<%$ Resources:HelpList, IDS_Label_AddHelp %>"></asp:Literal></a>
                      </li>
                     <li class="spirtLines">|</li>
                     <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
                     <li class="spirtLines">|</li>
                     <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
                     <li class="spirtLines">|</li>
                     <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server"  Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
                 </ul>
            </div>
            <div class="grdGroupList">			
            <div class="grdGroupListLi">
            <Hishop:CustomGridView ID="grdHelpList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="HelpId" CssClass="GridViewStyle" GridLines="None" 
                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true" SortOrder="DESC" SortOrderBy="AddedDate"> 
                    <SelectedRowStyle BackColor="#FBFBF4" />
                  <Columns>
                     <Hishop:CheckBoxColumn ReadOnly="true"/>
                     <asp:TemplateField HeaderText="<%$ Resources:HelpList,IDS_Header_HelpCategoryName%>">
                           <ItemTemplate>
	                           <Hishop:SubStringLabel id="lblHelpCategory" Text='<%#Eval("Name") %>' StrLength="60" StrReplace="..." runat="server"></Hishop:SubStringLabel>
                            </ItemTemplate>
                     </asp:TemplateField>
                     <asp:TemplateField HeaderText="<%$ Resources:HelpList,IDS_Header_HelpTitle%>" ItemStyle-Width="50%" SortExpression="Title">
                           <ItemTemplate>
                               <div class="infoTitle"><a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("HelpDetails",Eval("HelpId"))%>' target="_blank"><asp:Literal id="lblHelpTitle" Text='<%#Eval("Title") %>' runat="server"></asp:Literal></a>
                               <div class="infoIntro"><asp:Literal id="lblDesc" runat="Server" Text='<%#Eval("Description") %>'></asp:Literal></div>
                            </ItemTemplate>
                     </asp:TemplateField>
                     <asp:TemplateField HeaderText="<%$ Resources:HelpList,IDS_Header_AddedDate%>" ItemStyle-Width="20%" SortExpression="AddedDate">
                           <ItemTemplate>
                               <Hishop:FormatedTimeLabel id="lblAddedDate" Time='<%#Eval("AddedDate") %>' runat="server"></Hishop:FormatedTimeLabel>
                           </ItemTemplate>
                     </asp:TemplateField>
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="20%">
                                 <ItemStyle CssClass="handleRightSelect"/>
                                 <ItemTemplate>
			                         <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_Edithelp",Eval("HelpId"))%>' class="SmallCommonTextButton"><asp:Literal ID="lblEditHelp" Text="<%$Resources:Resources, IDS_Button_Edit %>" runat="server"></asp:Literal></a>
			                         <Hishop:DeleteImageLinkButton ID="lkDelete" CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Delete %>"  CommandName="Delete" runat="server" />
                                 </ItemTemplate>
                             </asp:TemplateField>  
                  </Columns>
              </Hishop:CustomGridView> 
               <!--翻页-->
               <div class="grdGroupTabhead">
                  <UI:Pager runat="server" ListToPaging="grdHelpList" ID="pager" />
               </div>	
            </div>
            </SkinTemplate>
            </Hishop:HelpList>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
