﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    
    <style type="text/css">

body{
  font:lighter 12px/150% Tahoma;
}
form,p{
  margin:0;padding:0;
}
input{
  vertical-align:middle;
}
textarea{
  vertical-align:top;
}
p{
  margin:0px auto;
}
label{
  display:inline-block;width:5em;text-align:right;
}
</style>
    
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:SendMessage,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:SendMessage,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:SendMessage ID="SendMessage" runat="server">
            <SkinTemplate>
            <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />

        <table class="formTableList" width="100%"   >
            <tr>
                <td class="leftTD" >标题：</td>
                <td class="rightTD"><asp:TextBox id="txtTitle" runat="Server" Width="300" ></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtTitleTip" runat="server"></div>
                    <Hishop:ValidateTarget  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtTitle" Description="标题长度限制在1-100个字符内" Nullable="false">
                       <Validators>
                          <Hishop:InputStringClientValidator ErrorMessage="标题长度限制在1-100个字符内" LowerBound="1" UpperBound="50" />
                       </Validators>
                    </Hishop:ValidateTarget>
                 </td>
            </tr>
            <tr>
                <td class="leftTD" style="vertical-align:top;">内容：</td>
                <td class="rightTD"><asp:TextBox id="txtContent" Height="100"  TextMode="MultiLine" runat="Server" Width="300"></asp:TextBox></td>
                <td class="rightTD" style=" vertical-align:top;">
                    <div id="txtContentTip" runat="server"></div>
                    <Hishop:ValidateTarget  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtContent" Description="留言长度限制在1-3000个字符内" Nullable="false">
                       <Validators>
                          <Hishop:InputStringClientValidator ErrorMessage="留言长度限制在1-3000个字符内" LowerBound="1" UpperBound="3000" />
                       </Validators>
                    </Hishop:ValidateTarget>
                 </td>
            </tr>
            <tr>
                <td ></td>
                <td><asp:Button id="btnRefer" width="60" runat="Server" Text="下一步" OnClientClick="return PageIsValid();"></asp:Button></td>
            </tr>
        </table>
            </SkinTemplate>
            </Hishop:SendMessage>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
