﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:SendMessageSelectUser,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:SendMessageSelectUser,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:SendMessageSelectUser ID="SendMessageSelectUser" runat="server">
            <SkinTemplate>
            
            <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
            
<fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:MemberSearch, IDS_FromField_litSelectQuery %>"></asp:Literal>
    </legend>
    <table width="75%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label runat="server" Text="用户名"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSearchUserName" runat="server"></asp:TextBox></td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblMemberRank" runat="server" Text="用户等级"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:UserRankDropDownList ID="dropMemberRank" runat="server" AllowNull="true" NullToDisplay="全部" />
            </td>
        </tr>
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblUserState" runat="server" Text="帐户状态"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:AccountStatusDropDownList ID="AccountStatusDropDownList" runat="server" />
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="页面大小"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
            </td>
            <td class="bottonTD">
                <asp:Button ID="btnSearchButton" runat="server" Text="<%$ Resources:Resources, IDS_Button_Search %>"
                    CssClass="inp_L1" />
            </td>
        </tr>
    </table>
</fieldset>

<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
        </ul>
    </div>

    <div class="grdGroupListLi">
                   
        <UI:Grid  ID="userList" runat="server" AutoGenerateColumns="false"
            ShowHeader="true" DataKeyNames="hi_UserId" CssClass="GridViewStyle" GridLines="None"
            RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true" SortOrderBy="CreateDate" SortOrder="DESC" RunningMode="Server">
            <Columns>
                <Hishop:CheckBoxColumn ItemStyle-Width="100px"/>
                <asp:TemplateField HeaderText="<%$ Resources:ManageMembers, IDS_Header_Name %>" SortExpression="UserName" ItemStyle-Width="200px">                            
                    <itemtemplate>
                        <asp:Label runat="server" id="lblUserId" Text='<%# Eval("HI_UserId") %>' Visible="false"></asp:Label>
                        <asp:Label ID="lblUserName" runat="server" Text='<%# Eval("UserName") %>'></asp:Label>
                     </itemtemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="<%$ Resources:ManageMembers, IDS_Header_CreateDate %>"
                    SortExpression="CreateDate"  >
                    <itemtemplate>
                       <nobr><Hishop:FormatedTimeLabel ID="lblCreateDate" Time='<%# Bind("CreateDate") %>' runat="server"></Hishop:FormatedTimeLabel></nobr>
                    </itemtemplate>
                </asp:TemplateField>
            </Columns>
        </UI:Grid >
    </div>

    <div class="grdGroupTabhead">
        <UI:Pager runat="server" RunningMode="PostBack" ID="pager" />
    </div>
    
    <div>
        <asp:Button runat="server" ID="btnPreviousStep" Text="上一步"></asp:Button>
        <asp:Button runat="server" ID="btnSendSelect" Text="发送消息给选定用户"></asp:Button>
        <asp:Button runat="server" ID="btnSendAll" Text="发送消息给满足查询条件的用户"></asp:Button>
    </div>

</div>

            </SkinTemplate>
            </Hishop:SendMessageSelectUser>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
