﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:UserInRoles,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:UserInRoles,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:UserInRoles ID="UserInRoles" runat="server">
            <SkinTemplate>
<!-- 操作提示 -->
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdGroupFormList">
    <div class="grdHeaderStyle"> 
          <asp:Literal ID="lblRoleName" runat="server"></asp:Literal><asp:Literal ID="lblRolesList" runat="server" Text="<%$Resources:UserInRoles,IDS_Label_RoleList %>"></asp:Literal>
    </div>
    <div class="grdHeaderStyle">
        <ul>
            <li class="_return"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_Roles")%>'><asp:Literal ID="lblBack" Text="<%$Resources:Resources,IDS_Button_Back %>" runat="server"></asp:Literal></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupDelCheck">
                <Hishop:ImageLinkButton ID="lkbDelectCheck" runat="server" OnClientClick="showConfirm(this); return false;"
                    Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:ImageLinkButton></li>
        </ul>
    </div>
   <div class="grdGroupList">
       <div class="grdGroupListLi">   
        <Hishop:CustomGridView ID="grdUserList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="UserID" CssClass="GridViewStyle" GridLines="None" 
                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true"> 
             <Columns> 
                 <Hishop:CheckBoxColumn ReadOnly="true"/>
                 <asp:TemplateField HeaderText="<%$ Resources:UserInRoles, IDS_Header_UserName %>" SortExpression="UserName" ItemStyle-Width="50%">
                     <ItemTemplate>
                         <asp:Label ID="lblUserName" runat="server" Text='<%# Eval("UserName") %>'></asp:Label>
                         <div class="row-actions">
                         <Hishop:ImageLinkButton OnClientClick="showConfirm(this); return false;" runat="server" ID="lkDelete" CommandName="Delete" Text="<%$ Resources:UserInRoles,IDS_Button_Remove %>" />
                         </div>
                      </ItemTemplate>
                 </asp:TemplateField>
                 <asp:BoundField HeaderText="<%$ Resources:UserInRoles, IDS_Header_Email %>" SortExpression="Email" DataField="Email"  />
                 <asp:TemplateField HeaderText="<%$ Resources:UserInRoles, IDS_Header_CreateTime %>" ItemStyle-Width="15%">
                     <ItemTemplate>
                         <Hishop:FormatedTimeLabel id="lblTime" Time='<%#Bind("CreateDate") %>' runat="server"></Hishop:FormatedTimeLabel>
                     </ItemTemplate>
                 </asp:TemplateField>
             </Columns>
         </Hishop:CustomGridView>
       </div>
    </div>
    		 <!--翻页开始-->
	<div class="grdGroupTabhead">
       <UI:Pager runat="server" ListToPaging="grdUserList" ID="pager" />
    </div>	
            <!--添加用户至部门-->
            <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
                <ul>
                    <li class="addAdministrator">
                        <asp:Literal ID="litAddTemple" Text='<%$Resources:UserInRoles,IDS_Title_AddUserToRoles %>' runat="server"></asp:Literal>
                    </li>
                </ul>
            </div>
             <table style="width: 100%" cellspacing="0" cellpadding="0" id="addItemsTable">
	              <tr>
	                 <td>
                          <div class="grdGroupList">
                           <div class="grdGroupListLi">
                               <Hishop:ManagerSearch ID="managerSearch" Width="100%" runat="server">
                               <SkinTemplate>
         <fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ManagerSearch, IDS_FromField_litSelectQuery %>"></asp:Literal></legend>
    <table width="45%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblSearchText" runat="server" CssClass="searchFormText" Text="<%$ Resources:ManagerSearch, IDS_FromField_Keywords %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSearchText" runat="server"></asp:TextBox>&nbsp;</td>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblPageSize" CssClass="searchFormText" runat="server" Text="<%$ Resources:ManagerSearch, IDS_FromField_PageSize %>" />：</nobr>
            </td>
            <td class="searchTableControlTD">
                 <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
            </td>
               <td>
                 &nbsp;<asp:Button ID="btnSearchButton" runat="server" Text="<%$ Resources:ManagerSearch, IDS_Button_Search %>" CssClass="inp_L1" /></td>   
        </tr>
    </table>
</fieldset>
                               </SkinTemplate>
                               </Hishop:ManagerSearch>
                               <Hishop:CustomGridView ID="grdSearChUserList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="UserID" CssClass="GridViewStyle" GridLines="None" 
                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                                       <Columns>
                                          <asp:TemplateField HeaderText="<%$Resources:Resources,IDS_Header_Check %>">
                                              <ItemTemplate>
                                                 <asp:CheckBox ID="chkChoise" runat="server" />
                                              </ItemTemplate>
                                          </asp:TemplateField>
                                          <asp:BoundField DataField="UserName" HeaderText="<%$ Resources:UserInRoles, IDS_Header_UserName %>" />
                                       </Columns>
                                    </Hishop:CustomGridView>
                                  <div class="grdGroupTabhead">
                                   <UI:Pager runat="server" ListToPaging="grdUserList" ID="pager1" />
                                 </div>
                              </div>
                           </div>
                       </td>
                    </tr>
                 </table>
                 <asp:Button ID="btnAddInRoles" Text="<%$ Resources:Resources, IDS_Button_Add%>" CssClass="inp_L1" runat="server"/>
</div>
            </SkinTemplate>
            </Hishop:UserInRoles>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" IsScriptManagerInside="true" ID="ValidatorContainer" />
    </form>
</body>
</html>