﻿-- 系統架構資訊
DELETE FROM aspnet_SchemaVersions

-- 使用者等級
DELETE FROM Hishop_UserRanks

-- 區域劃分
DELETE FROM Hishop_ShippingAreas

-- 配送地區
DELETE FROM Hishop_Regions

-- 郵件範本
DELETE FROM Hishop_EmailTemplet

-- 廣告位
DELETE FROM Hishop_AdvPositions

-- 友情連結
DELETE FROM Hishop_FriendlyLinks

-- 系統架構資訊
INSERT aspnet_SchemaVersions ([Feature], [CompatibleSchemaVersion], [IsCurrentVersion]) VALUES (N'common', N'1', 1)
INSERT aspnet_SchemaVersions ([Feature], [CompatibleSchemaVersion], [IsCurrentVersion]) VALUES (N'health monitoring', N'1', 1)
INSERT aspnet_SchemaVersions ([Feature], [CompatibleSchemaVersion], [IsCurrentVersion]) VALUES (N'membership', N'1', 1)
INSERT aspnet_SchemaVersions ([Feature], [CompatibleSchemaVersion], [IsCurrentVersion]) VALUES (N'personalization', N'1', 1)
INSERT aspnet_SchemaVersions ([Feature], [CompatibleSchemaVersion], [IsCurrentVersion]) VALUES (N'profile', N'1', 1)
INSERT aspnet_SchemaVersions ([Feature], [CompatibleSchemaVersion], [IsCurrentVersion]) VALUES (N'role manager', N'1', 1)

-- 使用者等級
INSERT INTO Hishop_UserRanks([Name], IsDefault, IsAgentRank, NumberOfMemberRanks, IsMemberCreated, CreatorUserId, PriceType, PriceOperations, PriceValue) VALUES(N'金牌代理', 0, 1, 3, 0, NULL, 'SalePrice', '+', 0)
INSERT INTO Hishop_UserRanks([Name], IsDefault, IsAgentRank, NumberOfMemberRanks, IsMemberCreated, CreatorUserId, PriceType, PriceOperations, PriceValue) VALUES(N'銀牌代理', 0, 1, 2, 0, NULL, 'SalePrice', '+', 0)
INSERT INTO Hishop_UserRanks([Name], IsDefault, IsAgentRank, NumberOfMemberRanks, IsMemberCreated, CreatorUserId, PriceType, PriceOperations, PriceValue) VALUES(N'銅牌代理', 0, 1, 1, 0, NULL, 'SalePrice', '+', 0)

INSERT INTO Hishop_UserRanks([Name], IsDefault, IsAgentRank, NumberOfMemberRanks, IsMemberCreated, CreatorUserId, PriceType, PriceOperations, PriceValue) VALUES(N'普通會員', 1, 0, 0, 0, NULL, 'SalePrice', '+', 0)
INSERT INTO Hishop_UserRanks([Name], IsDefault, IsAgentRank, NumberOfMemberRanks, IsMemberCreated, CreatorUserId, PriceType, PriceOperations, PriceValue) VALUES(N'高級會員', 0, 0, 0, 0, NULL, 'SalePrice', '+', 0)
INSERT INTO Hishop_UserRanks([Name], IsDefault, IsAgentRank, NumberOfMemberRanks, IsMemberCreated, CreatorUserId, PriceType, PriceOperations, PriceValue) VALUES(N'VIP會員', 0, 0, 0, 0, NULL, 'SalePrice', '+', 0)

DECLARE @AreaId INT

-- 區域劃分
/********************************************************************************************************************************************************************/
-- 華東 開始
INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'華東')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'浙江省', 1, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'上海', 2, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'江蘇省', 3, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'安徽省', 4, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'江西省', 5, '0,', 1)
-- 華東 結束
/********************************************************************************************************************************************************************/
-- 華北 開始
INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'華北')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'北京', 6, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'天津', 7, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'河北省', 8, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'山西省', 9, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'內蒙古', 10, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'山東省', 11, '0,', 1)
-- 華北 結束
/********************************************************************************************************************************************************************/
-- 華中 開始

INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'華中')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'河南省', 12, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'湖北省', 13, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'湖南省', 14, '0,', 1)
-- 華中 結束
/********************************************************************************************************************************************************************/
-- 華南 開始
INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'華南')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'海南省', 15, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'福建省', 16, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'廣東省', 17, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'廣西', 18, '0,', 1)
-- 華南 結束
/********************************************************************************************************************************************************************/
-- 東北 開始

INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'東北')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'遼寧省', 19, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'吉林省', 20, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'黑龍江省', 21, '0,', 1)
-- 東北 結束
/********************************************************************************************************************************************************************/
-- 西北 開始

INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'西北')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'新疆', 22, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'陝西省', 23, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'甘肅省', 24, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'青海省', 25, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'寧夏', 26, '0,', 1)
-- 西北 結束
/********************************************************************************************************************************************************************/
-- 西南 開始

INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'西南')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'重慶', 27, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'四川省', 28, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'貴州省', 29, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'雲南省', 30, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'西藏', 31, '0,', 1)
-- 西南 結束
/********************************************************************************************************************************************************************/
-- 港澳臺 開始
INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'港澳臺')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'臺灣省', 32, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'香港', 33, '0,', 1)
INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'澳門', 34, '0,', 1)
-- 港澳臺 結束
/********************************************************************************************************************************************************************/
-- 海外 開始
INSERT INTO Hishop_ShippingAreas([Name]) VALUES (N'海外')
SET @AreaId = @@IDENTITY

INSERT INTO Hishop_Regions(AreaId, RegionName, DisplaySequence, Path, Depth) VALUES(@AreaId, N'海外', 35, '0,', 1)
-- 海外 結束
/********************************************************************************************************************************************************************/
 --郵件範本
/********************************************************************************************************************************************************************/ 

INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'ChangedDealPassword', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$Password$:密碼,$LoginUrl$:登錄地址,$ChangePassWordUrl$:修改密碼的位址', N'使用者交易密碼修改以後', N'$UserName$ 您的交易密碼成功修改', N'<div style="border-right: #d3d3d2 1px solid; padding-right: 12px; border-top: #d3d3d2 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #d3d3d2 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #f3f3f3">
<div>
<h2 style="font-size: 16px">親愛的<span style="color: #ad0000">[$UserName$]</span>用戶，您在<span style="color: #ad0000">[$SiteName$]</span>成功更改了您的交易密碼</h2>
</div>
<div>　　如果您沒有提交交易密碼重設的請求或不是$SiteName$的註冊用戶，請立即忽略並刪除這封郵件，也可以回復管理員說明情況。只在您確認需要重置交易密碼的情況下，才繼續閱讀下面的內容。</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">密碼更改說明：</h2>
</div>
<div>　　請在這裡用新的交易密碼登錄：$LoginUrl$ 如果你想再次修改您的交易密碼，請訪問：$ChangePassWordUrl$ 如果你確定自己沒有進行修改交易密碼的操作，請儘快回復管理員說明情況 謝謝，</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'ChangedPassword', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$Password$:密碼,$LoginUrl$:登錄地址,$ChangePassWordUrl$:修改密碼的位址', N'使用者登錄密碼修改以後', N'$UserName$ 您的密碼已成功修改', N'<div style="border-right: #d3d3d2 1px solid; padding-right: 12px; border-top: #d3d3d2 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #d3d3d2 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #f3f3f3">
<div>
<h2 style="font-size: 16px">親愛的<span style="color: #ad0000">[$UserName$]</span>用戶，您在<span style="color: #ad0000">[$SiteName$]</span>成功更改了您的密碼</h2>
</div>
<div>　　如果您沒有提交交易密碼重設的請求或不是$SiteName$的註冊用戶，請立即忽略並刪除這封郵件，也可以回復管理員說明情況。只在您確認需要重置交易密碼的情況下，才繼續閱讀下面的內容。</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">密碼更改說明：</h2>
</div>
<div>　　請在這裡用新的交易密碼登錄：$LoginUrl$ 如果你想再次修改您的交易密碼，請訪問：$ChangePassWordUrl$ 如果你確定自己沒有進行修改交易密碼的操作，請儘快回復管理員說明情況 謝謝，</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'ForgottenDealPassword', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$ChangePassWordSecurityUrl$:生成的修改交易密碼的安全連結位址', N'使用者找回密碼，交易找回密碼的方式僅支援SecureLink', N'$UserName$ 您的找回交易密碼被成功受理', N'<div style="border-right: #d3d3d2 1px solid; padding-right: 12px; border-top: #d3d3d2 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #d3d3d2 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #f3f3f3">
<div>
<h2 style="font-size: 16px">親愛的<span style="color: #ad0000">[$UserName$]</span>使用者，您的交易找回密碼請求已經成功受理</h2>
</div>
<div>　　如果您沒有提交交易密碼重設的請求或不是$SiteName$的註冊用戶，請立即忽略並刪除這封郵件，也可以回復管理員說明情況。只在您確認需要重置交易密碼的情況下，才繼續閱讀下面的內容。</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">密碼更改說明：</h2>
</div>
<div>　　您可以通過點擊下面的安全連結重置您的密碼：$ChangePassWordSecurityUrl$ (如果上面不是連結形式，請將位址手工粘貼到流覽器位址欄再訪問) 上面的頁面打開後，輸入新的交易密碼後提交，之後您即可使用新的交易密碼登錄 $SiteName$了。您也可以在用戶控制台中隨時修改您的交易密碼 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'ForgottenPassword', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$Password$:密碼,$LoginUrl$:登錄地址,$ChangePassWordUrl$:修改密碼的位址', N'使用者找回密碼，找回密碼的方式為Reset或QuestionAndAnswer', N'$UserName$您的找回密碼請求已成功受理', N'<div style="border-right: #d3d3d2 1px solid; padding-right: 12px; border-top: #d3d3d2 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #d3d3d2 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #f3f3f3">
<div>
<h2 style="font-size: 16px">親愛的<span style="color: #ad0000">[$UserName$]</span>使用者，您的找回密碼請求已經成功受理</h2>
</div>
<div>　　如果您沒有提交交易密碼重設的請求或不是$SiteName$的註冊用戶，請立即忽略並刪除這封郵件，也可以回復管理員說明情況。只在您確認需要重置交易密碼的情況下，才繼續閱讀下面的內容。</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">密碼更改說明：</h2>
</div>
<div>　　系統為您自動生成了一個任意的新密碼，說明您更安全地訪問($SiteName$) 您的用戶名和密碼為： 用戶名：<span style="color: #ad0000">$UserName$</span> 密碼：<span style="color: #ad0000">$Password$</span> 請你在這裡登錄：$LoginUrl$ 如果你還想修改密碼，請訪問：$ChangePassWordUrl$ 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'NewUserAccountApproved', 1, N'$SiteName$:店鋪名稱,$LoginUrl$:登錄地址,$ChangePassWordUrl$:修改密碼的位址', N'註冊成功以後，管理員在後臺將帳號的狀態改為Approved', N'($SiteName$)您在$SiteName$已成功註冊', N'<div style="border-right: #a6daff 1px solid; padding-right: 12px; border-top: #a6daff 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #a6daff 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #2e96df 4px solid; background-color: #eef8ff">
<div>
<h2 style="font-size: 16px">親愛的<span style="color: #ad0000">[$UserName$]</span>用戶， 您在$SiteName$註冊了一個新的帳號</h2>
</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">請求狀態：審核通過</h2>
</div>
<div>如果你還想進行其他操作，那麼請先登錄：$LoginUrl$ 如果你想修改您的密碼，請訪問：$ChangePassWordUrl$ 成功登錄後，你應該儘量完善你的使用者資料 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'NewUserAccountCreated', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$Password$:密碼,$LoginUrl$:登錄地址,$ChangePassWordUrl$:修改密碼的位址', N'註冊成功以後，並且帳號啟動的方式是Email或者Automatic', N'($SiteName$)這是您在$SiteName$上的註冊資訊', N'<div style="border-right: #a6daff 1px solid; padding-right: 12px; border-top: #a6daff 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #a6daff 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #2e96df 4px solid; background-color: #eef8ff">
<div>
<h2 style="font-size: 16px">親愛的<span style="color: #ad0000">[$UserName$]</span>感謝您的註冊</h2>
</div>
<div>下面是您的註冊資訊，請妥善保存。</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">用戶名：$UserName$　密碼： $Password$</h2>
</div>
<div>登錄啟動位址請訪問：$LoginUrl$ 登錄後您也可以修改您的密碼： $ChangePassWordUrl$ 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'NewUserAccountPending', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$Password$:密碼', N'註冊成功以後，並且帳號啟動的方式是AdminApproval', N'$UserName$ 你在$SiteName$上的註冊資訊', N'<div style="border-right: #a6daff 1px solid; padding-right: 12px; border-top: #a6daff 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #a6daff 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #2e96df 4px solid; background-color: #eef8ff">
<div>
<h2 style="font-size: 16px">感謝您的註冊，下面是您的註冊資訊，請妥善保存</h2>
</div>
<div style="line-height: 30px">
<h2 style="padding-right: 0px; padding-left: 0px; font-size: 16px; padding-bottom: 0px; margin: 0px; padding-top: 15px">用戶名：$UserName$ 密碼：$Password$</h2>
</div>
<div>但是還需要等待管理員的審核，一旦您的註冊資訊通過審核，您將再次接受一封關於審核結果的郵件，敬請關注 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'NewUserAccountRejected', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名', N'註冊成功以後，管理員在後臺將帳號的狀態改為Disapproved', N'($SiteName$)的註冊用戶審核結果', N'<div style="font-size:12px;line-height:20px;border:1px #a6daff solid;border-bottom:4px #2E96DF solid;background-color:#eef8ff;padding:12px;padding-left:50px;">
    <div><h2 style="font-size:16px;">親愛的$UserName$用戶， 您$在$SiteName$註冊了一個新的帳號</h2></div>
    <div style="line-height:30px;"><h2 style="font-size:16px;padding:0px;margin:0px;padding-top:15px;">請求狀態：很抱歉，審核未通過</h2></div>
    <div style="text-align:right;padding-right:22px;"><h2 style="font-size:16px;">$SiteName$</h2></div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'OrderPay', 1, N'$SiteName$:店鋪名,$UserName$:用戶名,$OrderId$:訂單號,$Amount$:訂單金額', N'', N'$UserName$您的訂單資訊，訂單號：$OrderId$', N'<div style="border-right: #b7c4cd 1px solid; padding-right: 12px; border-top: #b7c4cd 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #b7c4cd 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #e0ebf2">
<div>
<h2 style="font-size: 16px">請查看你的訂單資訊</h2>
</div>
<div>您好! 謝謝您在我們的商城購物，你付款我們已經收到請查看你的訂單資訊 訂單編號: $OrderId$ 訂單金額: $Amount$ 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'OrderSendGoods', 1, N'$SiteName$:店鋪名,$UserName$:用戶名,$OrderId$:訂單號,$Amount$:訂單金額,$ShipOrderNumber$發貨單', N'', N'$UserName$ 您的訂單$OrderId$已經發貨', N'<div style="border-right: #b7c4cd 1px solid; padding-right: 12px; border-top: #b7c4cd 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #b7c4cd 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #e0ebf2">
<div>
<h2 style="font-size: 16px">已經為$UserName$使用者的訂單$OrderId$發貨</h2>
</div>
<div>您好! 謝謝您在我們的商城購物，我們已經為你的訂單發貨，請查看你的訂單資訊</div>
<div>訂單編號: $OrderId$ 訂單金額: $Amount$ 發貨單：$ShipOrderNumber$</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'PrivateMessageNotification', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$ChangePassWordSecurityUrl$:生成的修改交易密碼的安全連結位址', N'站內信，用戶給其他用戶發送站內信', N'($SiteName$)站內信：$Subject$', N'<div style="font-size:12px;line-height:20px;border:1px #D3D3D2 solid;border-bottom:4px #949EA7 solid;background-color:#F3F3F3;padding:12px;">
    <div><h2 style="font-size:16px;">親愛的$UserName$用戶， $UserName$給你發送了一則新的私有消息</h2></div>
    <div>主題：$Subject$ </div>
    <div>短信內容：</div>
    <div>　　$Body$</div>
    <div style="text-align:right;padding-right:22px;"><h2 style="font-size:16px;">$SiteName$</h2></div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'ProductNotify', 1, N'$ProductName$:商品名稱,$Description$:商品簡介,$ProductUrl$:商品詳細資訊,$SiteName$:店鋪名,$UserName$:用戶名', N'', N'親愛的$UserName$，$productName$ 已經到啦！', N'<div style="border-right: #b7c4cd 1px solid; padding-right: 12px; border-top: #b7c4cd 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #b7c4cd 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #e0ebf2">
<div>
<h2 style="font-size: 16px">最新到貨通知</h2>
</div>
<div>商品名稱：$ProductName$</div>
<div>商品簡介：</div>
<div>$Description$</div>
<div>想瞭解更多該商品的詳細資訊請訪問: $ProductUrl$ 謝謝</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'SendCoupon', 1, N'$SiteName$:店鋪名,$CouponName$:優惠券名稱,$CouponCode$:優惠券號,$Amount$:滿足金額,$Discount$:折扣金額,
$CouponTime$:有效期,$Times$:可使用次數', N'', N'$SiteName$的優惠券', N'<div style="border-right: #b7c4cd 1px solid; padding-right: 12px; border-top: #b7c4cd 1px solid; padding-left: 50px; font-size: 12px; padding-bottom: 12px; border-left: #b7c4cd 1px solid; line-height: 20px; padding-top: 12px; border-bottom: #949ea7 4px solid; background-color: #e0ebf2">
<div>
<h2 style="font-size: 16px">優惠券</h2>
</div>
<div>您好! 謝謝您在我們的商城購物,這是我們發送給你的一張優惠券</div>
<div>優惠券名稱：$CouponName$ 優惠券號：$CouponCode$ 滿足金額：$Amount$</div>
<div>抵扣金額：$Discount$ 有效期至：$CouponTime$ 可使用次數：$Times$</div>
<div style="padding-right: 22px; text-align: right">
<h2 style="font-size: 16px">$SiteName$</h2>
</div>
</div>')
INSERT Hishop_EmailTemplet ([EmailType], [EmailPriority], [TagDescription], [EmailDescription], [EmailSubject], [EmailBody]) VALUES (N'SendEmail', 1, N'$SiteName$:店鋪名稱,$UserName$:用戶名,$Subject$:使用者發送的郵件主題,$Body$：使用者發送的郵件內容', N'使用者在店鋪內通過店鋪提供的郵件功能給其他用戶發送郵件', N' $UserName$的$Subject$', N'<div style="font-size:12px;line-height:20px;border:1px #D3D3D2 solid;border-bottom:4px #949EA7 solid;background-color:#fff;padding:12px;padding-left:50px;">
    <div>親愛的$UserName$用戶， 這是在$SiteName$的用戶發送的郵件，回復這封郵件將會直接發送到用戶的郵箱裡</div>
    <div>發送人 ：$SiteName$</div>
    <div>主題：$Subject$</div>
    <div>郵件內容：</div>
    <div>　　$Body$</div>
</div>')

INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (1, N'AD1', 1, NULL, 960, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (2, N'AD2', 5, NULL, 0, 0, N'<p><embed src="/Storage/FCKPro/Files/837.swf" width="545" height="188" type="application/x-shockwave-flash" play="true" loop="true" menu="true"></embed></p>')
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (3, N'AD3', 1, NULL, 764, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (4, N'AD4', 1, NULL, 191, 184, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (5, N'AD5', 2, 3, 545, 97, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (6, N'AD6', 1, NULL, 211, 97, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (7, N'AD7', 2, NULL, 191, 185, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (8, N'AD8', 1, NULL, 545, 97, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (9, N'AD9', 2, 3, 191, 185, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (10, N'AD10', 3, NULL, 209, 82, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (11, N'AD11', 1, NULL, 545, 188, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (12, N'AD12', 3, NULL, 500, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (13, N'AD13', 3, NULL, 500, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (14, N'AD14', 3, NULL, 500, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (15, N'AD15', 3, NULL, 500, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (16, N'AD16', 4, NULL, 500, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (17, N'AD17', 4, NULL, 500, 100, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (18, N'AD18', 2, NULL, 960, 75, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (19, N'AD19', 4, NULL, 214, 147, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (20, N'AD20', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (21, N'AD21', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (22, N'AD22', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (23, N'AD23', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (24, N'AD24', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (25, N'AD25', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (26, N'AD26', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (27, N'AD27', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (28, N'AD28', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (29, N'AD29', 5, NULL, 0, 0, NULL)
INSERT [dbo].[Hishop_AdvPositions] ([AdvPositionId], [AdvPositionName], [ShowType], [RepeatColumns], [Width], [Height], [AdvHtml]) VALUES (30, N'AD30', 5, NULL, 0, 0, NULL)

INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/l-logo01.gif', N'http://www.phpwind.net', N'PHPWIND', 1, 28, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/linklogo.gif', N'http://www.17maihuo.com', N'货源信息网', 1, 25, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/l-logo06.gif', N'http://www.tq.cn', N'TQ客服', 1, 32, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/68design_logo.gif', N'http://www.68design.net', N'68DESIGN', 1, 30, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/zzw.gif', N'http://www.admin5.com', N'站长网', 1, 31, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/logozhi.jpg', N'http://www.alipay.com', N'支付宝', 1, 29, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/2.jpg', N'http://www.yeepay.com', N'易宝支付', 1, 4, 0, 0)
INSERT [dbo].[Hishop_FriendlyLinks] ([ImageUrl], [LinkUrl], [Title], [Visible], [DisplaySequence], [UserId], [IsMemberCreated]) VALUES (N'/Storage/Links/logohi.jpg', N'http://www.92hi.com', N'Hishop网店代理分销系统', 1, 2, 0, 0)