﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Message 的摘要说明
/// </summary>
namespace BLL
{
    public class Message
    {
        #region 增

        /// <summary>
        /// 添加新留言
        /// </summary>
        /// <param name="MsgName"></param>
        /// <param name="MsgContent"></param>
        /// <param name="IsDelete"></param>
        public int createmessage(string MsgName, string MsgContent, bool IsDelete)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("Insert into Messages (MsgName,MsgContent,IsDelete) values (@MsgName,@MsgContent,@IsDelete)");
            SqlParameter[] param = 
                                   {
                                      DBHelper.GetParameter("@MsgName",SqlDbType.NVarChar,50,"[MsgName]",MsgName),
                                      DBHelper.GetParameter("@MsgContent",SqlDbType.NText,16,"[MsgContent]",MsgContent),
                                      DBHelper.GetParameter("@IsDelete",SqlDbType.Bit,1,"[IsDelete]",IsDelete)
                                   };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion
        #region 删

        /// <summary>
        /// 删除一条留言
        /// </summary>
        /// <param name="MsgID"></param>
        public int deletemessage(int MsgID)
        {
            SqlParameter[] param = { DBHelper.GetParameter("@MsgID", SqlDbType.Int, 4, "MsgID", MsgID) };
            String sql = "Update Messages set IsDelete=1 where MsgID=@MsgID";
            return DBHelper.ExecuteSql(sql, param);
        }

        #endregion
        #region 改
        #endregion
        #region 查

        /// <summary>
        /// 获得一条留言
        /// </summary>
        /// <param name="MsgID"></param>
        /// <returns></returns>
        public DataRow getonemessage(int MsgID)
        {
            SqlParameter[] param = { DBHelper.GetParameter("@MsgID", SqlDbType.Int, 4, "MsgID", MsgID) };
            String sql = "Select MsgID, MsgName,MsgContent,MsgTime from Messages where IsDelete=0 and MsgID=@MsgID";
            DataTable dt = DBHelper.ExecuteDt(sql, param);
            return dt.Rows[0];
        }
        /// <summary>
        /// 获得全部留言和回复
        /// </summary>
        /// <returns></returns>
        public DataTable GetMessageList()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("Select a.MsgID,a.MsgName,a.MsgContent,a.MsgTime,b.RelayID,b.RelayContent,b.RelayTime ");
            sb.Append("from Messages as a left outer join Relay as b on a.MsgID=b.MsgID where a.IsDelete=0 order by a.MsgTime desc");
            DataTable dt = DBHelper.ExecuteDt(sb.ToString());
            return dt;
        }

        /// <summary>
        /// 获得全部留言
        /// </summary>
        /// <returns></returns>
        public DataTable messagelist()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select MsgID,MsgName,MsgContent,MsgTime from Messages where IsDelete=0 order by MsgID desc");
            DataTable dt = DBHelper.ExecuteDt(sb.ToString());
            return dt;
        }

        #endregion
        public Message()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
    }
}