﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;

/// <summary>
/// News 的摘要说明
/// </summary>
namespace BLL
{
    public class News
    {
        #region 增

        /// <summary>
        /// 创建一条新闻
        /// </summary>
        /// <param name="Keywords">关键字</param>
        /// <param name="ClassID_1">新闻一级分类</param>
        /// <param name="ClassID_2">新闻二级分类</param>
        /// <param name="ImagePath">新闻图片</param>
        /// <param name="Click">点击率</param>
        /// <param name="Title">新闻标题</param>
        /// <param name="Source">来源</param>
        /// <param name="Author">作者</param>
        /// <param name="Content">内容</param>
        /// <param name="UpdateTime">更新时间</param>
        /// <param name="Summary">概要</param>
        /// <returns></returns>
        public int createNews(string Keywords, int ClassID_1, int ClassID_2, string ImagePath, int Click, 
            string Title, string Source, string Author, string Content, DateTime UpdateTime, string Summary)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into News ([Keywords],[ClassID_1],[ClassID_2],[ImagePath],[Click],[Title],");
            sb.Append("[Source],[Author],[Content],[UpdateTime],[Summary]) values (");
            sb.Append("@Keywords,@ClassID_1,@ClassID_2,@ImagePath,@Click,@Title,@Source,");
            sb.Append("@Author,@Content,@UpdateTime,@Summary)");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@Keywords",SqlDbType.NVarChar,50,"[Keywords]",Keywords),
                                        DBHelper.GetParameter("@ClassID_1",SqlDbType.Int,4,"[ClassID_1]",ClassID_1),
                                        DBHelper.GetParameter("@ClassID_2",SqlDbType.Int,4,"[ClassID_2]",ClassID_2),
                                        DBHelper.GetParameter("@ImagePath",SqlDbType.NVarChar,50,"[ImagePath]",ImagePath),
                                        DBHelper.GetParameter("@Click",SqlDbType.Int,4,"[Click]",Click),
                                        DBHelper.GetParameter("@Title",SqlDbType.NVarChar,50,"[Title]",Title),
                                        DBHelper.GetParameter("@Source",SqlDbType.NVarChar,50,"[Source]",Source),
                                        DBHelper.GetParameter("@Author",SqlDbType.NVarChar,50,"[Author]",Author),
                                        DBHelper.GetParameter("@Content",SqlDbType.NText,16,"[Content]",Content),
                                        DBHelper.GetParameter("@UpdateTime",SqlDbType.DateTime,8,"[UpdateTime]",UpdateTime),
                                        DBHelper.GetParameter("@Summary",SqlDbType.NVarChar,255,"[Summary]",Summary)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 删

        /// <summary>
        /// 删除一条新闻
        /// </summary>
        /// <param name="NewID"></param>
        /// <returns></returns>
        public int deleteNews(int NewID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from News where NewID=@NewID");
            SqlParameter[] param = { DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 改

        /// <summary>
        /// 更新图片
        /// </summary>
        /// <param name="path"></param>
        public int updatepic(string ImagePath, int NewID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update News set ImagePath=@ImagePath where NewID=@NewID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ImagePath",SqlDbType.NVarChar,50,"ImagePath",ImagePath),
                                        DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }
        /// <summary>
        /// 更新一条新闻
        /// </summary>
        /// <param name="Keywords">关键字</param>
        /// <param name="ClassID_1">新闻一级分类</param>
        /// <param name="ClassID_2">新闻二级分类</param>
        /// <param name="ImagePath">新闻图片</param>
        /// <param name="Click">点击率</param>
        /// <param name="Title">新闻标题</param>
        /// <param name="Source">来源</param>
        /// <param name="Author">作者</param>
        /// <param name="Content">内容</param>
        /// <param name="UpdateTime">更新时间</param>
        /// <param name="Summary">概要</param>
        /// <returns></returns>
        public int updateNews(int NewID, string Keywords, int ClassID_1, int ClassID_2, string ImagePath, int Click,
            string Title, string Source, string Author, string Content, DateTime UpdateTime, string Summary)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update News set Keywords=@Keywords,ClassID_1=@ClassID_1,ClassID_2=@ClassID_2,Click=@Click,");
            sb.Append("Title=@Title,Source=@Source,Author=@Author,Content=@Content,");
            sb.Append("UpdateTime=@UpdateTime,Summary=@Summary where NewID=@NewID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@Keywords",SqlDbType.NVarChar,50,"[Keywords]",Keywords),
                                        DBHelper.GetParameter("@ClassID_1",SqlDbType.Int,4,"[ClassID_1]",ClassID_1),
                                        DBHelper.GetParameter("@ClassID_2",SqlDbType.Int,4,"[ClassID_2]",ClassID_2),
                                        DBHelper.GetParameter("@ImagePath",SqlDbType.NVarChar,50,"[ImagePath]",ImagePath),
                                        DBHelper.GetParameter("@Click",SqlDbType.Int,4,"[Click]",Click),
                                        DBHelper.GetParameter("@Title",SqlDbType.NVarChar,50,"[Title]",Title),
                                        DBHelper.GetParameter("@Source",SqlDbType.NVarChar,50,"[Source]",Source),
                                        DBHelper.GetParameter("@Author",SqlDbType.NVarChar,50,"[Author]",Author),
                                        DBHelper.GetParameter("@Content",SqlDbType.NVarChar,3000,"[Content]",Content),//大奇怪的问题.这里用NText,16居然很短.
                                        DBHelper.GetParameter("@UpdateTime",SqlDbType.DateTime,8,"[UpdateTime]",UpdateTime),
                                        DBHelper.GetParameter("@Summary",SqlDbType.NVarChar,255,"[Summary]",Summary),
                                        DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 查

        #region 首条,前一条,后一条,尾条
        public string getnextNews(int NewID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top 1 * from News ");
            sb.Append("where NewID<@NewID order by NewID desc");
            SqlParameter[] param = { DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            if (table.Rows.Count > 0)
                return table.Rows[0]["NewID"].ToString();
            else
                return "";
        }
        public string getpreNews(int NewID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top 1 * from News ");
            sb.Append("where NewID>@NewID");
            SqlParameter[] param = { DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            if (table.Rows.Count>0)
                return table.Rows[0]["NewID"].ToString();
            else
                return "";
        }
        #endregion

        /// <summary>
        /// 查询top n
        /// </summary>
        /// <param name="num"></param>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassID_2"></param>
        /// <param name="Title"></param>
        /// <returns></returns>
        public DataTable getNewslisttop(int num,int ClassID_1, int ClassID_2, string Title)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select top " + num + " * from News where 1=@index");
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (ClassID_1 != 0)
            {
                sb.Append(" and ClassID_1=@ClassID_1 ");
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "ClassID_1", ClassID_1));
            }
            if (ClassID_2 != 0)
            {
                sb.Append(" and ClassID_2=@ClassID_2");
                list.Add(DBHelper.GetParameter("@ClassID_2", SqlDbType.Int, 4, "ClassID_2", ClassID_2));
            }
            if (Title != "")
            {
                sb.Append(" and Title like '%' + @Title + '%'");
                list.Add(DBHelper.GetParameter("@Title", SqlDbType.NVarChar, 50, "Title", Title));
            }
            sb.Append(" order by NewID desc");

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 根据参数查询新闻
        /// </summary>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassID_2"></param>
        /// <param name="Title"></param>
        /// <returns></returns>
        public DataTable getNewslist(int ClassID_1, int ClassID_2, string Title)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select * from News where 1=@index");
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (ClassID_1 != 0)
            {
                sb.Append(" and ClassID_1=@ClassID_1 ");
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "ClassID_1", ClassID_1));
            }
            if (ClassID_2 != 0)
            {
                sb.Append(" and ClassID_2=@ClassID_2");
                list.Add(DBHelper.GetParameter("@ClassID_2", SqlDbType.Int, 4, "ClassID_2", ClassID_2));
            }
            if (Title != "")
            {
                sb.Append(" and Title like '%' + @Title + '%'");
                list.Add(DBHelper.GetParameter("@Title", SqlDbType.NVarChar, 50, "Title", Title));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 根据参数查询新闻
        /// </summary>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassID_2"></param>
        /// <param name="Keywords"></param>
        /// <returns></returns>
        public DataTable Newslist(int ClassID_1, int ClassID_2, string Keywords)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select * from News where 1=@index");
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (ClassID_1 != 0)
            {
                sb.Append(" and ClassID_1=@ClassID_1 ");
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "ClassID_1", ClassID_1));
            }
            if (ClassID_2 != 0)
            {
                sb.Append(" and ClassID_2=@ClassID_2");
                list.Add(DBHelper.GetParameter("@ClassID_2", SqlDbType.Int, 4, "ClassID_2", ClassID_2));
            }
            if (Keywords != "")
            {
                sb.Append(" and Keywords like '%' + @Keywords + '%'");
                list.Add(DBHelper.GetParameter("@Keywords", SqlDbType.NVarChar, 50, "Keywords", Keywords));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        public DataTable selectNews(int ClassID_1, int ClassID_2, string Keywords)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("SELECT News.*, Class_2.ClassName AS ClassName_2, Class_1.ClassName AS ClassName_1 ");
            sb.Append("FROM News, Class_2, Class_1 ");
            sb.Append("WHERE News.ClassID_2=Class_2.ClassID_2 and Class_2.ClassID_1=Class_1.ClassID_1");
            if (ClassID_1 != 0)
            {
                sb.Append(" and Class_2.ClassID_1=@ClassID_1 ");
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "Class_2.ClassID_1", ClassID_1));
            }
            if (ClassID_2 != 0)
            {
                sb.Append(" and Class_2.ClassID_2=@ClassID_2");
                list.Add(DBHelper.GetParameter("@ClassID_2", SqlDbType.Int, 4, "Class_2.ClassID_2", ClassID_2));
            }
            if (Keywords != "")
            {
                sb.Append(" and News.Keywords like '%' + @Keywords + '%'");
                list.Add(DBHelper.GetParameter("@Keywords", SqlDbType.NVarChar, 50, "News.Keywords", Keywords));
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        ///获得一条新闻纪录 
        /// </summary>
        /// <param name="NewID"></param>
        /// <returns></returns>
        public DataRow getoneNews(int NewID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select * from News ");
            sb.Append("where NewID=@NewID");
            SqlParameter[] param = { DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows[0];
        }

        /// <summary>
        /// 获得若干数量的最新新闻
        /// </summary>
        /// <returns></returns>
        public DataTable getnewNewslist(int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " * from News order by NewID desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得若干数量的热点新闻
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable gethotNewslist(ref int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " *");
            sb.Append(" from News order by [Click] desc,[NewID] desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        ///更新新闻的浏览数量 
        /// </summary>
        /// <param name="NewID"></param>
        public void updatepointnum(int NewID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update News set Click=Click+1 where NewID=@NewID");
            SqlParameter[] param = { DBHelper.GetParameter("@NewID", SqlDbType.Int, 4, "NewID", NewID) };
            DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 获得新新闻
        /// </summary>
        /// <returns></returns>
        public DataTable getnewNews()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select * from News order by NewID desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 查询新闻
        /// </summary>
        /// <param name="Class_1"></param>
        /// <param name="Class_2"></param>
        /// <param name="Keywords"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public DataTable searchNewslist(int Class_1, int Class_2, string Keywords, string start, string end)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("SELECT News.*, Class_2.ClassName AS ClassName_2, Class_1.ClassName AS ClassName_1 ");
            sb.Append("FROM News, Class_2, Class_1 ");
            sb.Append("WHERE News.ClassID_2=Class_2.ClassID_2 and Class_2.ClassID_1=Class_1.ClassID_1");
            if (Class_1 != 0)
            {
                sb.Append(" and Class_2.ClassID_1=@ClassID_1 ");
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "Class_2.ClassID_1", Class_1));
            }
            if (Class_2 != 0)
            {
                sb.Append(" and Class_2.ClassID_2=@ClassID_2");
                list.Add(DBHelper.GetParameter("@ClassID_2", SqlDbType.Int, 4, "Class_2.ClassID_2", Class_2));
            }
            if (Keywords != "")
            {
                sb.Append(" and News.Keywords like '%' + @Keywords + '%'");
                list.Add(DBHelper.GetParameter("@Keywords", SqlDbType.NVarChar, 50, "News.Keywords", Keywords));
            }
            if (start != "" && end != "")
            {
                sb.Append(" and News.UpdateTime between @start and @end");
                list.Add(DBHelper.GetParameter("@start", SqlDbType.DateTime, 8, "News.UpdateTime", Convert.ToDateTime(start)));
                list.Add(DBHelper.GetParameter("@end", SqlDbType.DateTime, 8, "News.UpdateTime", Convert.ToDateTime(end)));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        #endregion
        public News()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
    }
}