﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Type_2 的摘要说明
/// </summary>
namespace BLL
{
    public class Type_2
    {
        #region 增

        /// <summary>
        /// 创建一个商品二级分类
        /// </summary>
        /// <param name="typeid_1"></param>
        /// <param name="typename"></param>
        /// <returns></returns>
        public int createtype_2(int typeid_1, string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Type_2 ([TypeID_1],[TypeName]) values (@TypeID_1,@TypeName)");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@TypeID_1",SqlDbType.Int,4,"[TypeID_1]",typeid_1),
                                        DBHelper.GetParameter("@TypeName",SqlDbType.NVarChar,50,"[TypeName]",typename)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 删

        /// <summary>
        /// 删除一个商品二级分类
        /// </summary>
        /// <param name="typeid_2"></param>
        /// <returns></returns>
        public int deletetype_2(int typeid_2)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Type_2 where [TypeID_2]=@TypeID_2");
            SqlParameter[] param = { DBHelper.GetParameter("@TypeID_2", SqlDbType.Int, 4, "[TypeID_2]", typeid_2) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 改

        /// <summary>
        /// 修改一个商品二级分类
        /// </summary>
        /// <param name="typeid_1"></param>
        /// <param name="typename"></param>
        /// <returns></returns>
        public int updatetype_2(int typeid_2, int typeid_1, string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Type_2 set [TypeID_1]=@TypeID_1,[TypeName]=@TypeName where [TypeID_2]=@TypeID_2");
            SqlParameter[] param = 
                                   { 
                                        DBHelper.GetParameter("@TypeID_1",SqlDbType.Int,4,"[TypeID_1]",typeid_1),
                                        DBHelper.GetParameter("@TypeName",SqlDbType.NVarChar,50,"[TypeName]",typename),
                                        DBHelper.GetParameter("@TypeID_2",SqlDbType.Int,4,"[TypeID_2]",typeid_2)
                                   };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 查

        /// <summary>
        /// 连接查询,top n
        /// </summary>
        /// <param name="typeid_1"></param>
        /// <param name="typename"></param>
        /// <returns></returns>
        public DataTable type_2listtop(int num,int typeid_1, string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT top " + num + " Type_1.TypeName as type_1name, Type_2.TypeID_1, Type_2.TypeID_2 as TypeID2 , Type_2.TypeName as type_2name ");
            sb.Append("FROM Type_1 INNER JOIN Type_2 ON Type_1.TypeID_1 = Type_2.TypeID_1 where 1 = @index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (typeid_1 != 0)
            {
                list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "[TypeID_1]", typeid_1));
                sb.Append(" and Type_2.TypeID_1=@TypeID_1");
            }
            if (typename != "")
            {
                list.Add(DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "TypeName", typename));
                sb.Append(" and Type_2.TypeName like '%' + @TypeName + '%'");
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 查找某一大类下的前n条.
        /// </summary>
        /// <param name="num"></param>
        /// <param name="TypeID_1"></param>
        /// <returns></returns>
        public DataTable toplist(int num, int TypeID_1)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select top " + num + " * from Type_2 where TypeID_1 = @TypeID_1 order by TypeID_2");
            list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int,4,"[TypeID_1]", TypeID_1));
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 查询商品二级分类
        /// </summary>
        /// <param name="typeid_1"></param>
        /// <param name="typename"></param>
        /// <returns></returns>
        public DataTable type_2list(int typeid_1, string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT Type_1.TypeName as type_1name, Type_2.TypeID_1, Type_2.TypeID_2 as TypeID2 , Type_2.TypeName as type_2name ");
            sb.Append("FROM Type_1 INNER JOIN Type_2 ON Type_1.TypeID_1 = Type_2.TypeID_1 where 1 = @index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (typeid_1 != 0)
            {
                list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "[TypeID_1]", typeid_1));
                sb.Append(" and Type_2.TypeID_1=@TypeID_1");
            }
            if (typename != "")
            {
                list.Add(DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "TypeName", typename));
                sb.Append(" and Type_2.TypeName like '%' + @TypeName + '%'");
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        /// 分类是否存在
        /// </summary>
        /// <param name="typename"></param>
        /// <returns></returns>
        public bool IsExite(string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select TypeName from Type_2 where TypeName=@TypeName");
            SqlParameter[] param = 
                                   { DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "[TypeName]", typename) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? true : false;
        }

        /// <summary>
        /// 根据类型ID获得类型名称
        /// </summary>
        /// <param name="typeid"></param>
        /// <returns></returns>
        public string gettypename(int typeid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select TypeName from Type_2 where TypeID_2=@TypeID_1");
            SqlParameter[] param = { DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "TypeID_1", typeid) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? table.Rows[0]["TypeName"].ToString() : "";
        }

        #endregion

        public Type_2()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }   
    }
}