﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Collections.Generic;

public partial class Cart : System.Web.UI.Page
{
    BLL.Cart ocart = new BLL.Cart();
    BLL.UserInfo user = new BLL.UserInfo();
    int num = 0;
    double price = 0.0;
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "购物车";
        if (user.IsLogin() == true)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Member_Login.aspx");
        }
    }

    private void Bind()
    {
        DataTable table = ocart.getcartlist(user.getUserID());
        this.cartrepeater.DataSource = table.DefaultView;
        this.cartrepeater.DataBind();

        this.counttypelieteral.Text = this.cartrepeater.Items.Count.ToString();

        this.countnumlieteral.Text = num.ToString();
        this.countpricelieral.Text = price.ToString();
    }

    protected void cartrepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Label pricelabel = e.Item.FindControl("pricelabel") as Label;
            Label countpricelabel = e.Item.FindControl("countpricelabel") as Label;
            TextBox counttb = e.Item.FindControl("counttb") as TextBox;
            DataRowView drv = e.Item.DataItem as DataRowView;
            if (drv["specials"].ToString().ToLower() == "true")
            {
                pricelabel.Text = drv["specialsprice"].ToString();
            }
            else
            {
                pricelabel.Text = drv["userprice"].ToString();
            }
            counttb.Text = drv["count"].ToString();
            countpricelabel.Text = (double.Parse(pricelabel.Text) * int.Parse(counttb.Text.Trim())).ToString();

            num += int.Parse(counttb.Text.Trim());
            price += double.Parse(countpricelabel.Text.Trim());
        }
    }

    /// <summary>
    /// 修改数量
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void updatecount_Click(object sender, EventArgs e)
    {
        List<int> ids = new List<int>();
        List<int> counts = new List<int>();
        foreach (RepeaterItem item in this.cartrepeater.Items)
        {
            Label label = item.FindControl("productidlabel") as Label;
            TextBox textbox = item.FindControl("counttb") as TextBox;
            ids.Add(int.Parse(label.Text.Trim()));
            counts.Add(int.Parse(textbox.Text.Trim()));
        }
        for (int i = 0; i < ids.Count; i++)
        {
            ocart.updatecart(ids[i], user.getUserID(), counts[i]);
        }
        this.Bind();
    }

    /// <summary>
    /// 清空购物车
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void clearcount_Click(object sender, EventArgs e)
    {
        foreach (RepeaterItem item in this.cartrepeater.Items)
        {
            Label label = item.FindControl("cartidlabel") as Label;

            ocart.deletecart(int.Parse(label.Text.Trim()));
        }
        this.Bind();

    }

    protected void cartrepeater_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "deletecart")
        {
            Label label = e.Item.FindControl("cartidlabel") as Label;
            int id = int.Parse(label.Text);
            ocart.deletecart(id);
            this.Bind();
        }
    }

    protected void cartrepeater_ItemCreated(object sender, RepeaterItemEventArgs e)
    {
        //if (e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.Item)
        //{
        //    Label label = item.FindControl("producteid") as Label;

        //}
    }

    protected void orderbt_Click(object sender, EventArgs e)
    {
        if (this.cartrepeater.Items.Count > 0)
        {
            StringBuilder productidsb = new StringBuilder();
            StringBuilder countsb = new StringBuilder();
            foreach (RepeaterItem item in this.cartrepeater.Items)
            {
                Label productidlabel = item.FindControl("productidlabel") as Label;
                productidsb.Append(",");
                productidsb.Append(productidlabel.Text);
                TextBox counttb = item.FindControl("counttb") as TextBox;
                countsb.Append(",");
                countsb.Append(counttb.Text.Trim());
            }
            Session["count"] = countsb.ToString();
            Session["productids"] = productidsb.ToString();
            Session["price"] = this.countpricelieral.Text;
            this.Response.Redirect("checkout.aspx");
            //Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<srcipt>alert('" + Session["productids"].ToString() + "')</script>", false);
        }
    }
}