﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Includes_Main_Top : System.Web.UI.UserControl
{
    BLL.UserInfo user = new BLL.UserInfo();
    int pID = 0;
    int pIDnext = 0;
    int nID = 0;
    int nIDnext = 0;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindType();
            BindLogin();
            BindNextType();
            BindNextClass();
        }
    }
    /// <summary>
    /// 绑定一级类别,商品top4,新闻top5
    /// </summary>
    protected void BindType()
    {
        //绑定商品
        BLL.Type_1 t_1 = new BLL.Type_1();
        DataTable dt = t_1.toplist(5);
        if (Request.Params["type1"] != null)
            pID = Int32.Parse(Request.Params["type1"].ToString());
        foreach (DataRow row in dt.Rows)
        {
            if (int.Parse(row["TypeID_1"].ToString()) != pID)
            {
                this.Ltl_class_1.Text += "&nbsp;<a class='lianjie_3' href='Product_List.aspx?type1=";
            }
            else
            {
                this.Ltl_class_1.Text += "&nbsp;<a href='Product_List.aspx?type1="; ;
            }
            this.Ltl_class_1.Text += row["TypeID_1"].ToString() + "'>";
            this.Ltl_class_1.Text += row["TypeName"].ToString() + "</a>&nbsp;";
            this.Ltl_class_1.Text += "<span class='style2'>|</span>";
        }
        //绑定新闻
        BLL.Class_1 c_1 = new BLL.Class_1();
        DataTable table = c_1.toplist(4);
        if((Request.Params["class1"] != null)&&(Request.Params["class1"]!=""))
            nID = Int32.Parse(Request.Params["class1"].ToString());
        string url = "&nbsp;<a href='New_List.aspx?class1=";
        string url_add_style = "&nbsp;<a class='lianjie_3' href='New_List.aspx?class1=";
        for (int i = 0; i < (table.Rows.Count-1); i++)
        {
            if (int.Parse(table.Rows[i]["ClassID_1"].ToString()) != nID)
            {
                this.Ltl_class_1.Text += url_add_style;
            }
            else
            {
                this.Ltl_class_1.Text += url;
            }
            this.Ltl_class_1.Text += table.Rows[i]["ClassID_1"].ToString() + "'>";
            this.Ltl_class_1.Text += table.Rows[i]["ClassName"].ToString() + "</a>&nbsp;";
            this.Ltl_class_1.Text += "<span class='style2'>|</span>";
        }
        //绑定最后一条
        if (int.Parse(table.Rows[table.Rows.Count - 1]["ClassID_1"].ToString()) != nID)
        {
            this.Ltl_class_1.Text += url_add_style;
        }
        else
        {
            this.Ltl_class_1.Text += url;
        }
        this.Ltl_class_1.Text += table.Rows[table.Rows.Count-1]["ClassID_1"].ToString() + "'>";
        this.Ltl_class_1.Text += table.Rows[table.Rows.Count-1]["ClassName"].ToString() + "</a>";
    }
    /// <summary>
    /// 判断是否登录
    /// </summary>
    protected void BindLogin()
    {
        if (user.IsLogin() == true)
        {
            this.loginpanel.Visible = false;
            this.logoutpanel.Visible = true;
            this.usernamelabel.Text = "欢迎 :" + "<font style='color:red'>" + user.getUserName() + "</font>" + "进入大气象学习园地";
        }
        else
        {
            this.logoutpanel.Visible = false;
            this.loginpanel.Visible = true;
        }
    }
    /// <summary>
    /// 提交登录
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn_submit_Click(object sender, EventArgs e)
    {
        if ((this.logname.Text.Trim() != "") && (this.logpwd.Text.Trim()!=""))
        {
            if (user.validateUser(this.logname.Text.Trim(), this.logpwd.Text.Trim(), 1))
            {
                int day = int.Parse(this.cook.SelectedValue.ToString());
                user.SetCookie(this.logname.Text.Trim(), day);
                this.Response.Redirect("Default.aspx");
            }
            else
            {
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('用户名和密码不一致!')</script>", false);
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('用户名或密码为空!')</script>", false);
        }
    }
    /// <summary>
    /// 绑定商品二级分类
    /// </summary>
    protected void BindNextType()
    {
        if (pID > 0)
        {
            this.Ltl_Class_2.Text = "";
            BLL.Type_2 t_2 = new BLL.Type_2();
            DataTable table = t_2.toplist(9, pID);
            if (Request.Params["type2"] != null)
                pIDnext = Int32.Parse(Request.Params["type2"].ToString());
            string url = "&nbsp;<a href='Product_List.aspx?type1=" + pID + "&type2=";
            string url_add_style = "&nbsp;<a class='top_type2' href='Product_List.aspx?type1=" + pID + "&type2=";
            for (int i = 0; i < (table.Rows.Count - 1); i++)
            {
                if (int.Parse(table.Rows[i]["TypeID_2"].ToString()) != pIDnext)
                {
                    this.Ltl_Class_2.Text += url;
                }
                else
                {
                    this.Ltl_Class_2.Text += url_add_style;
                }
                this.Ltl_Class_2.Text += table.Rows[i]["TypeID_2"].ToString() + "'>";
                this.Ltl_Class_2.Text += table.Rows[i]["TypeName"].ToString() + "</a>&nbsp;|";
            }
            //绑定最后一条
            if (int.Parse(table.Rows[table.Rows.Count - 1]["TypeID_2"].ToString()) != pIDnext)
            {
                this.Ltl_Class_2.Text += url;
            }
            else
            {
                this.Ltl_Class_2.Text += url_add_style;
            }
            this.Ltl_Class_2.Text += table.Rows[table.Rows.Count - 1]["TypeID_2"].ToString() + "'>";
            this.Ltl_Class_2.Text += table.Rows[table.Rows.Count - 1]["TypeName"].ToString() + "</a>";
        }
    }
    /// <summary>
    /// 绑定新闻二级分类
    /// </summary>
    protected void BindNextClass()
    {
        if (nID > 0)
        {
            this.Ltl_Class_2.Text = "";
            BLL.Class_2 c_2 = new BLL.Class_2();
            DataTable table = c_2.toplist(9, nID);
            if (Request.Params["class2"] != null)
                nIDnext = Int32.Parse(Request.Params["class2"].ToString());
            //被选中加样式
            string url = "&nbsp;<a href='New_List.aspx?class1=" + nID + "&class2=";
            string url_add_style = "&nbsp;<a class='top_type2' href='New_List.aspx?class1=" + nID + "&class2=";
            for (int i = 0; i < (table.Rows.Count - 1); i++)
            {
                if (int.Parse(table.Rows[i]["ClassID_2"].ToString()) != nIDnext)
                {
                    this.Ltl_Class_2.Text += url;
                }
                else
                {
                    this.Ltl_Class_2.Text += url_add_style;
                }
                this.Ltl_Class_2.Text += table.Rows[i]["ClassID_2"].ToString() + "'>";
                this.Ltl_Class_2.Text += table.Rows[i]["ClassName"].ToString() + "</a>&nbsp;|";
            }
            //绑定最后一条
            if (int.Parse(table.Rows[table.Rows.Count - 1]["ClassID_2"].ToString()) != nIDnext)
            {
                this.Ltl_Class_2.Text += url;
            }
            else
            {
                this.Ltl_Class_2.Text += url_add_style;
            }
            this.Ltl_Class_2.Text += table.Rows[table.Rows.Count - 1]["ClassID_2"].ToString() + "'>";
            this.Ltl_Class_2.Text += table.Rows[table.Rows.Count - 1]["ClassName"].ToString() + "</a>";
        }
    }
}
