﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Member_Info : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "用户中心";
        if (user.IsLogin() == true)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Member_Login.aspx");
        }
    }
    /// <summary>
    /// 获得用户的信息
    /// </summary>
    private void Bind()
    {
        DataTable tabel = user.getUser(user.getUserID());
        if (tabel.Rows.Count > 0)
        {
            this.usernamelb.Text = tabel.Rows[0]["username"].ToString();
            this.emailTb.Text = tabel.Rows[0]["email"].ToString();
            this.questionTb.Text = tabel.Rows[0]["question"].ToString();
            this.answerTb.Text = tabel.Rows[0]["answer"].ToString();
            this.HiddenField1.Value = tabel.Rows[0]["password"].ToString();
        }
    }

    /// <summary>
    /// 修改用户资料
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void updateBt_Click(object sender, EventArgs e)
    {
        if (user.updateUser(user.getUserID(), this.HiddenField1.Value.ToString(), this.emailTb.Text.Trim(), this.questionTb.Text.Trim(), this.answerTb.Text.Trim()) == 1)
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('修改成功!')</script>", false);
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('修改失败!')</script>", false);
        }
    }
}
