﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Order_Detail : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Order ord = new BLL.Order();
    BLL.Cart ocart = new BLL.Cart();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (user.IsLogin() == true)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Member_Login.aspx");
        }
    }

    private void Bind()
    {
        string oid = this.Request.QueryString["oid"].ToString();
        DataRow row = ord.getoneorder(oid);
        this.orderidlabel.Text = row["orderid"].ToString();
        this.ordertime.Text = row["ordertime"].ToString();
        this.acceptnamelabel.Text = row["acceptname"].ToString();
        this.addresslabel.Text = row["address"].ToString();
        this.postalcodelabel.Text = row["postalcode"].ToString();
        this.phonelabel.Text = row["phone"].ToString();
        this.deliverylabel.Text = row["delivery"].ToString();
        this.paymentlabel.Text = row["payment"].ToString();

        string[] productids = row["productid"].ToString().Split(',');

        for (int i = 1; i < productids.Length; i++)
        {
            TableRow tr = new TableRow();
            tr.Width = new Unit(this.productlisttable.Width.Value);
            DataRow dr = ocart.getonecartbyproductid(int.Parse(productids[i]));

            TableCell tc_1 = new TableCell();
            tc_1.Width = new Unit(500);
            tc_1.HorizontalAlign = HorizontalAlign.Center;
            tc_1.Text = dr["productname"].ToString();
            TableCell tc_2 = new TableCell();
            tc_2.Width = new Unit(150);
            tc_2.HorizontalAlign = HorizontalAlign.Center;
            tc_2.Text = dr["count"].ToString();
            TableCell tc_5 = new TableCell();
            tc_5.Width = new Unit(150);
            tc_5.HorizontalAlign = HorizontalAlign.Center;
            tc_5.Text = dr["price"].ToString();
            TableCell tc_3 = new TableCell();
            tc_3.Width = new Unit(150);
            tc_3.HorizontalAlign = HorizontalAlign.Center;
            tc_3.Text = dr["specials"].ToString().ToLower() == "true" ? dr["specialsprice"].ToString() : dr["userprice"].ToString();
            TableCell tc_4 = new TableCell();
            tc_4.Width = new Unit(150);
            tc_4.HorizontalAlign = HorizontalAlign.Center;
            tc_4.Text = (int.Parse(tc_2.Text) * double.Parse(tc_3.Text)).ToString();
            tr.Cells.Add(tc_1);
            tr.Cells.Add(tc_2);
            tr.Cells.Add(tc_5);
            tr.Cells.Add(tc_3);
            tr.Cells.Add(tc_4);
            this.productlisttable.Rows.Add(tr);
        }
    }
}
