﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Add_New : System.Web.UI.Page
{
    BLL.Class_1 c_1 = new BLL.Class_1();
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.News news = new BLL.News();
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(AjaxServer.GetNextClass));
        Title = "添加新闻";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }
    protected void Bind()
    {
        DataTable dt = c_1.Class_1list("");
        ddl1.Items.Add(new ListItem("选择一级类别", ""));
        ddl2.Items.Add(new ListItem("选择二级类别", ""));
        foreach (DataRow dr in dt.Rows)
        {
            ddl1.Items.Add(new ListItem(dr["ClassName"].ToString(), dr["ClassID_1"].ToString()));
        }
        ddl1.Attributes.Add("onchange", "showNewNext(this.options[selectedIndex].value,'ddl2');");
        ddl2.Attributes.Add("onchange", "setClass(this.options[selectedIndex].value,'HF1');");
        HF1.Value = "";
    }

    private void ResetValue()
    {
        foreach (ListItem item in ddl1.Items)
        {
            if (item.Value == ViewState["ddl1"].ToString())
                item.Selected = true;
            else
                item.Selected = false;
        }
    }

    /// <summary>
    /// 提交保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void submitBt_Click(object sender, EventArgs e)
    {
        if (ddl1.SelectedIndex != 0)
        {
            if ((HF1.Value != "") && (HF1.Value != "0"))
            {
                string savePath = @"../images/uploadfiles/";
                string savePath1 = @"../images/uploadfiles/smallPic/";
                string fileName = Server.HtmlEncode(this.getimagepath());
                string extension = System.IO.Path.GetExtension(fileName);
                string ImageName = null;
                if (fileName != "nopic.gif")
                {
                    if ((extension == ".jpg") | (extension == ".gif"))
                    {
                        ImageName = DateTime.Now.ToString("yyyyMMddhhmmssfff") + extension;
                        savePath += ImageName;
                        savePath1 += ImageName;
                        savePath = Server.MapPath(savePath);
                        savePath1 = Server.MapPath(savePath1);
                    }
                    else
                    {
                        Response.Write("<script>alert('文件上传格式错误');history.back(1);</script>");
                        Response.End();
                    }
                }
                else
                {
                    ImageName = fileName;
                }
                string keywords = this.Tb_keywords.Text.Trim();
                int Classid_1 = int.Parse(this.ddl1.SelectedValue.ToString());
                int Classid_2 = int.Parse(this.HF1.Value);
                string imagepath = ImageName;
                int click = int.Parse(this.Tb_click.Text.Trim());
                string newtitle = this.Tb_title.Text.Trim();
                string source = this.Tb_source.Text.Trim();
                string author = this.Tb_author.Text.Trim();
                string content = this.FreeTextBox1.Text;
                DateTime updatetime = DateTime.Now;
                string summary = this.FreeTextBox2.Text;
                if (news.createNews(keywords,Classid_1,Classid_2,imagepath,click,newtitle,source,
                    author,content,updatetime,summary)== 1)
                {
                    if (fileName != "nopic.gif")
                    {
                        picupload.SaveAs(savePath);
                        //生成小图
                        Tools.ImageClass imageClass = new Tools.ImageClass();
                        imageClass.ShowThumbnail(savePath, savePath1, 200, 153);
                    }
                    Response.Write("<script>alert('添加成功');location.href='Add_new.aspx';</script>");
                }
                else
                {
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('添加新产品失败!')</script>", false);
                }
            }
            else
            {
                Response.Write("<script>alert('请选择二级类别!');location.href='Add_New.aspx';</script>");
                //用下面的方法会保存状态.
                //Page.ClientScript.RegisterClientScriptBlock(this.GetClass(), "alert", "<script>alert('请选择二级类别!')</script>", false);
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('请选择一级类别!')</script>", false);
        }
    }

    private string getimagepath()
    {
        try
        {
            return this.picupload.HasFile ? picupload.FileName : "nopic.gif";
        }
        catch
        {
            return "nopic.gif";
        }
    }
}
