﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Admin_Type1List : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Type_1 t_1 = new BLL.Type_1();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "一级类别管理";
        BLL.UserInfo user = new BLL.UserInfo();
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }

    /// <summary>
    /// 商品一级分类数据绑定
    /// </summary>
    private void Bind()
    {
        DataTable table = t_1.type_1list(this.keywordTb.Text.Trim());
        this.type_1Gv.DataSource = table.DefaultView;
        this.type_1Gv.DataBind();
    }

    protected void type_1Gv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.type_1Gv.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void type_1Gv_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int typeid = int.Parse(type_1Gv.DataKeys[0].Value.ToString());
        t_1.deletetype_1(typeid);
        Bind();
    }

    protected void type_1Gv_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.type_1Gv.EditIndex = e.NewEditIndex;
        Bind();
    }

    protected void type_1Gv_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int typeid = int.Parse(type_1Gv.DataKeys[e.RowIndex].Value.ToString());
        TextBox txt = this.type_1Gv.Rows[e.RowIndex].Cells[1].Controls[0] as TextBox;
        t_1.updatetype_1(typeid, txt.Text.Trim());
        this.type_1Gv.EditIndex = -1;
        Bind();

    }

    protected void type_1Gv_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.type_1Gv.EditIndex = -1;
        Bind();
    }

    /// <summary>
    /// 查找
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void searchBt_Click(object sender, EventArgs e)
    {
        Bind();
    }

    /// <summary>
    /// 添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void addnameBt_Click(object sender, EventArgs e)
    {
        if (t_1.IsExite(this.addnameTb.Text.Trim()) == false)
        {
            t_1.createtype_1(this.addnameTb.Text.Trim());
            Bind();
            Page.RegisterStartupScript("alert", "<script>alert('添加新分类成功!')</script>");
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('该分类已经存在')</script>", false);
        }
    }
    protected void type_1Gv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
    }
}
