﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
/*说明
 *1.查询的时候,只应该查询出来一级类别所包含的二级类别.
 */
public partial class admin_Admin_Type2List : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Type_1 t_1 = new BLL.Type_1();
    BLL.Type_2 t_2 = new BLL.Type_2();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "二级类别管理";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                Bindtype_1(this.addtypeddl);
                Bindtype_1(this.type_1ddl);
                Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }

    /// <summary>
    /// 绑定一级分类
    /// </summary>
    private void Bindtype_1(DropDownList ddl)
    {
        DataTable table = t_1.type_1list("");

        foreach (DataRow row in table.Rows)
        {
            ListItem li = new ListItem(row["TypeName"].ToString(), row["TypeID_1"].ToString());

            ddl.Items.Add(li);
        }
        ddl.Items.Insert(0, new ListItem("选择一级分类", "0"));
    }

    /// <summary>
    /// 二级分类绑定
    /// </summary>
    private void Bind()
    {
        DataTable tabel = t_2.type_2list(int.Parse(this.type_1ddl.SelectedValue.ToString()), this.typenameTb.Text.Trim());
        this.type_2Gv.DataSource = tabel.DefaultView;
        this.type_2Gv.DataBind();
    }

    protected void type_2Gv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.type_2Gv.PageIndex = e.NewPageIndex;
        this.Bind();
    }

    protected void type_2Gv_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.type_2Gv.EditIndex = -1;
        this.Bind();
    }

    protected void type_2Gv_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int typeid = int.Parse(this.type_2Gv.DataKeys[e.RowIndex].Value.ToString());
        t_2.deletetype_2(typeid);
        this.Bind();
    }

    protected void type_2Gv_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.type_2Gv.EditIndex = e.NewEditIndex;
        this.Bind();

        DropDownList ddl = this.type_2Gv.Rows[e.NewEditIndex].Cells[1].FindControl("type_1ddl") as DropDownList;
        DataTable table = t_1.type_1list("");

        foreach (DataRow row in table.Rows)
        {
            ListItem li = new ListItem(row["TypeName"].ToString(), row["TypeID_1"].ToString());
            ddl.Items.Add(li);
        }

        Label label = this.type_2Gv.Rows[e.NewEditIndex].Cells[1].FindControl("label") as Label;
        ListItem item = ddl.Items.FindByText(label.Text.Trim());
        item.Selected = true;
    }

    protected void type_2Gv_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int typeid = int.Parse(this.type_2Gv.DataKeys[e.RowIndex].Value.ToString());
        DropDownList ddl = this.type_2Gv.Rows[e.RowIndex].Cells[1].FindControl("type_1ddl") as DropDownList;
        TextBox txt = this.type_2Gv.Rows[e.RowIndex].Cells[1].FindControl("TextBox1") as TextBox;
        t_2.updatetype_2(typeid, int.Parse(ddl.SelectedValue.ToString()), txt.Text.Trim());

        this.type_2Gv.EditIndex = -1;

        Bind();
    }

    protected void type_2Gv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowIndex != -1)
        {
            e.Row.Cells[0].Text = (e.Row.RowIndex + 1).ToString();
        }
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
    }

    /// <summary>
    /// 添加新分类
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void addtypeBt_Click(object sender, EventArgs e)
    {
        int typeid_1 = int.Parse(this.addtypeddl.SelectedValue.ToString());
        string typename = this.addtypeTb.Text.Trim();
        if (t_2.IsExite(typename) == false)
        {
            if (t_2.createtype_2(typeid_1, typename) == 1)
            {
                this.Bind();
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('添加分类成功')</script>", false);
            }
            else
            {
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('添加分类失败')</script>", false);
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('分类名称已经存在')</script>", false);
        }
    }

    /// <summary>
    ///  查找
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void searchBt_Click(object sender, EventArgs e)
    {
        Bind();
    }

    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
        args.IsValid = this.addtypeddl.SelectedIndex == 0 ? false : true;
    }
}
