﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Edit_New : System.Web.UI.Page
{
    BLL.News news = new BLL.News();
    BLL.Class_1 c_1 = new BLL.Class_1();
    BLL.Class_2 c_2 = new BLL.Class_2();
    BLL.UserInfo user = new BLL.UserInfo();
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(AjaxServer.GetNextClass));
        Title = "产品修改";
        if (user.IsLogin() == true && user.getUserRole() == 2)//应该是这种判断.如果没有登录就不绑定了.
        {
            if (!this.IsPostBack)
            {
                Bindtype();
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }


    /// <summary>
    /// 一件商品信息的绑定
    /// </summary>
    private void Bind()
    {
        int pid = int.Parse(this.Request.QueryString["pid"].ToString());
        DataRow row = news.getoneNews(pid);
        this.Tb_keywords.Text = row["Keywords"].ToString();
        this.newpic.ImageUrl = "../images/uploadfiles/" + row["ImagePath"].ToString();
        this.Tb_click.Text = row["Click"].ToString();
        this.Tb_Title.Text = row["Title"].ToString();
        this.Tb_source.Text = row["Source"].ToString();
        this.Tb_author.Text = row["Author"].ToString();
        this.FreeTextBox1.Text = row["Content"].ToString();
        this.FreeTextBox2.Text = row["Summary"].ToString();

        this.ddl1.Items.FindByValue(row["ClassID_1"].ToString()).Selected = true;
        this.imagepath.Value = row["ImagePath"].ToString();
        DataTable table = c_2.Class_2list(int.Parse(row["ClassID_1"].ToString()), "");
        foreach (DataRow dr in table.Rows)
        {
            this.ddl2.Items.Add(new ListItem(dr["Class_2name"].ToString(), dr["ClassID_2"].ToString()));
        }
        this.ddl2.Items.FindByValue(row["ClassID_2"].ToString()).Selected = true;
        HF1.Value = row["ClassID_2"].ToString();
        this.uppic.NavigateUrl = "Edit_New_Pic.aspx?pid=" + this.Request.QueryString["pid"].ToString() + "&path=" + row["ImagePath"].ToString();
    }


    /// <summary>
    /// 绑定商品类别
    /// </summary>
    private void Bindtype()
    {
        DataTable dt = c_1.Class_1list("");
        ddl1.Items.Insert(0, new ListItem("一级类别", "0"));
        ddl2.Items.Insert(0, new ListItem("二级类别", "0"));
        foreach (DataRow dr in dt.Rows)
        {
            ddl1.Items.Add(new ListItem(dr["ClassName"].ToString(), dr["ClassID_1"].ToString()));
        }
        ddl1.Attributes.Add("onchange", "showNewNext(this.options[selectedIndex].value,'ddl2');");
        ddl2.Attributes.Add("onchange", "setClass(this.options[selectedIndex].value,'HF1');");
    }

    /// <summary>
    /// 提交保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void submitBt_Click(object sender, EventArgs e)
    {
        if (ddl1.SelectedIndex != 0)
        {
            if (HF1.Value != "0")
            {
                int pid = int.Parse(this.Request.QueryString["pid"].ToString());
                string state = this.HF1.Value;
                if(news.updateNews(pid,Tb_keywords.Text.Trim(),int.Parse(this.ddl1.SelectedValue.ToString()),
                     int.Parse(state),imagepath.Value,int.Parse(Tb_click.Text.Trim()),Tb_Title.Text.Trim(),
                     Tb_source.Text.Trim(), Tb_author.Text.Trim(), FreeTextBox1.Text, DateTime.Now, FreeTextBox2.Text) == 1)
                {
                    this.ddl2.Items.Clear();
                    this.Bind();
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('更新成功')</script>", false);
                }
                else
                {
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('更新失败')</script>", false);
                }
            }
            else
            {
                //这里应该有更好的办法,可以保持状态.
                this.ddl1.Items.Clear();
                this.ddl2.Items.Clear();
                this.Bindtype();
                this.Bind();
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('请选择二级类别!')</script>", false);
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('请选择一级类别!')</script>", false);
        }
    }
}
