﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Edit_Product : System.Web.UI.Page
{
    BLL.Products pro = new BLL.Products();
    BLL.Type_1 t_1 = new BLL.Type_1();
    BLL.Type_2 t_2 = new BLL.Type_2();
    BLL.UserInfo user = new BLL.UserInfo();
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(AjaxServer.GetNextClass));
        Title = "产品修改";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                Bindtype();
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }


    /// <summary>
    /// 一件商品信息的绑定
    /// </summary>
    private void Bind()
    {
        int pid = int.Parse(this.Request.QueryString["pid"].ToString());
        DataRow row = pro.getoneproduct(pid);
        this.productnameTb.Text = row["productname"].ToString();
        this.priceTb.Text = row["price"].ToString();
        this.userpriceTb.Text = row["userprice"].ToString();
        this.specialspriceTb.Text = row["specialsprice"].ToString();
        this.countTb.Text = row["count"].ToString();
        this.sellcountTb.Text = row["sellcount"].ToString();
        this.descriptionTb.Text = row["description"].ToString();
        this.recommendedCB.Checked = bool.Parse(row["recommended"].ToString());
        this.specialsCB.Checked = bool.Parse(row["specials"].ToString());

        this.pointcount.Value = row["pointcount"].ToString();

        this.ddl1.Items.FindByValue(row["typeid_1"].ToString()).Selected = true;
        this.productpic.ImageUrl = "../images/uploadfiles/" + row["imagepath"].ToString();
        this.imagepath.Value = row["imagepath"].ToString();
        DataTable table = t_2.type_2list(int.Parse(row["typeid_1"].ToString()), "");
        foreach (DataRow dr in table.Rows)
        {
            this.ddl2.Items.Add(new ListItem(dr["type_2name"].ToString(), dr["TypeID2"].ToString()));
        }
        this.ddl2.Items.FindByValue(row["TypeID_2"].ToString()).Selected = true;
        HF1.Value = row["TypeID_2"].ToString();
        this.uppic.NavigateUrl = "Edit_Product_Pic.aspx?pid=" + this.Request.QueryString["pid"].ToString() + "&path=" + row["imagepath"].ToString();
    }


    /// <summary>
    /// 绑定商品类别
    /// </summary>
    private void Bindtype()
    {
        DataTable dt = t_1.type_1list("");
        ddl1.Items.Insert(0, new ListItem("一级类别", "0"));
        ddl2.Items.Insert(0, new ListItem("二级类别", "0"));
        foreach (DataRow dr in dt.Rows)
        {
            ddl1.Items.Add(new ListItem(dr["TypeName"].ToString(), dr["TypeID_1"].ToString()));
        }
        ddl1.Attributes.Add("onchange", "showNext(this.options[selectedIndex].value,'ddl2');");
        ddl2.Attributes.Add("onchange", "setClass(this.options[selectedIndex].value,'HF1');");   
    }

    /// <summary>
    /// 提交保持
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void submitBt_Click(object sender, EventArgs e)
    {
        if (ddl1.SelectedIndex != 0)
        {
            if (HF1.Value != "0")
            {
                int pid = int.Parse(this.Request.QueryString["pid"].ToString());
                string state = this.HF1.Value;
                if (pro.updateproduct(pid, this.productnameTb.Text.Trim(), int.Parse(this.ddl1.SelectedValue.ToString()),
                     int.Parse(state), this.recommendedCB.Checked, this.specialsCB.Checked,
                     double.Parse(this.priceTb.Text.Trim()), double.Parse(this.userpriceTb.Text.Trim()), double.Parse(this.specialspriceTb.Text.Trim())
                     , int.Parse(this.pointcount.Value.ToString()), this.imagepath.Value, int.Parse(this.countTb.Text.Trim()), int.Parse(this.sellcountTb.Text.Trim())
                     , this.descriptionTb.Text) == 1)
                {
                    this.ddl2.Items.Clear();
                    this.Bind();
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('更新成功')</script>", false);
                }
                else
                {
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('更新失败')</script>", false);
                }
            }
            else
            {
                //这里应该有更好的办法,可以保持状态.
                this.ddl1.Items.Clear();
                this.ddl2.Items.Clear();
                this.Bindtype();
                this.Bind();
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('请选择二级类别!')</script>", false);
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('请选择一级类别!')</script>", false);
        }
    }
}
