﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Get_News : System.Web.UI.Page
{
    BLL.Class_1 c_1 = new BLL.Class_1();
    BLL.Class_2 c_2 = new BLL.Class_2();
    BLL.News news = new BLL.News();
    BLL.UserInfo user = new BLL.UserInfo();
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(AjaxServer.GetNextClass));
        Title = "产品列表";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                Bindtype();
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }
    /// <summary>
    /// 绑定新闻类别
    /// </summary>
    private void Bindtype()
    {
        DataTable dt = c_1.Class_1list("");
        ddl1.Items.Insert(0, new ListItem("一级类别", "0"));
        ddl2.Items.Insert(0, new ListItem("二级类别", "0"));
        foreach (DataRow dr in dt.Rows)
        {
            ddl1.Items.Add(new ListItem(dr["ClassName"].ToString(), dr["ClassID_1"].ToString()));
        }
        ddl1.Attributes.Add("onchange", "showNewNext(this.options[selectedIndex].value,'ddl2');");
        ddl2.Attributes.Add("onchange", "setClass(this.options[selectedIndex].value,'HF1');");
        HF1.Value = "0";
    }

    /// <summary>
    /// 新闻数据绑定
    /// </summary>
    private void Bind()
    {
        DataTable table = news.selectNews(int.Parse(this.ddl1.SelectedValue.ToString()),
            int.Parse(this.HF1.Value.ToString()), this.Tb_keywords.Text.Trim());
        this.Gv_newlist.DataSource = table.DefaultView;
        this.Gv_newlist.DataBind();
    }

    protected void searchBt_Click(object sender, EventArgs e)
    {
        Bind();
        ddl1.Items.Clear();
        ddl2.Items.Clear();
        Bindtype();
    }

    protected void NewlistGv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.Gv_newlist.PageIndex = e.NewPageIndex;
        this.Bind();
    }

    protected void NewlistGv_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.Gv_newlist.EditIndex = e.NewEditIndex;
        this.Bind();
    }

    protected void NewlistGv_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.Gv_newlist.EditIndex = -1;
        this.Bind();
    }

    protected void NewlistGv_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(this.Gv_newlist.DataKeys[e.RowIndex].Value.ToString());
        news.deleteNews(id);
        this.Bind();
        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('删除成功!')</script>", false);
    }

    protected void NewlistGv_SelectedIndexChanged(object sender, EventArgs e)
    {

    }
    protected void NewlistGv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
    }
}
