﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Get_Products : System.Web.UI.Page
{
    BLL.Type_1 t_1 = new BLL.Type_1();
    BLL.Type_2 t_2 = new BLL.Type_2();
    BLL.Products pro = new BLL.Products();
    BLL.UserInfo user=new BLL.UserInfo();
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(AjaxServer.GetNextClass));
        Title = "产品列表";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                Bindtype();
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }
    /// <summary>
    /// 绑定商品类别
    /// </summary>
    private void Bindtype()
    {
        DataTable dt = t_1.type_1list("");
        ddl1.Items.Insert(0, new ListItem("一级类别", "0"));
        ddl2.Items.Insert(0, new ListItem("二级类别", "0"));
        foreach (DataRow dr in dt.Rows)
        {
            ddl1.Items.Add(new ListItem(dr["TypeName"].ToString(), dr["TypeID_1"].ToString()));
        }
        ddl1.Attributes.Add("onchange", "showNext(this.options[selectedIndex].value,'ddl2');");
        ddl2.Attributes.Add("onchange", "setClass(this.options[selectedIndex].value,'HF1');");
        HF1.Value = "0";
    }

    /// <summary>
    /// 商品数据绑定
    /// </summary>
    private void Bind()
    {
        DataTable table = pro.selectproduct(int.Parse(this.ddl1.SelectedValue.ToString()),
            int.Parse(this.HF1.Value.ToString()), this.productnameTb.Text.Trim(),
            int.Parse(this.recommendedddl.SelectedValue.ToString()), int.Parse(this.specialsddl.SelectedValue.ToString()));
        this.productlistGv.DataSource = table.DefaultView;
        this.productlistGv.DataBind();
    }

    protected void searchBt_Click(object sender, EventArgs e)
    {
        Bind();
    }

    protected void productlistGv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.productlistGv.PageIndex = e.NewPageIndex;
        this.Bind();
    }

    protected void productlistGv_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.productlistGv.EditIndex = e.NewEditIndex;
        this.Bind();
    }

    protected void productlistGv_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.productlistGv.EditIndex = -1;
        this.Bind();
    }

    protected void productlistGv_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(this.productlistGv.DataKeys[e.RowIndex].Value.ToString());
        pro.deleteproduct(id);
        this.Bind();
        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('删除成功!')</script>", false);
    }

    protected void productlistGv_SelectedIndexChanged(object sender, EventArgs e)
    {

    }
    protected void productlistGv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
    }
}
