﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_NewsClass_1_List : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Class_1 c_1 = new BLL.Class_1();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "一级类别管理";
        BLL.UserInfo user = new BLL.UserInfo();
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }

    /// <summary>
    /// 商品一级分类数据绑定
    /// </summary>
    private void Bind()
    {
        DataTable table = c_1.Class_1list(this.keywordTb.Text.Trim());
        this.Class_1Gv.DataSource = table.DefaultView;
        this.Class_1Gv.DataBind();
    }

    protected void Class_1Gv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.Class_1Gv.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void Class_1Gv_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int classid = int.Parse(Class_1Gv.DataKeys[0].Value.ToString());
        c_1.deleteClass_1(classid);
        Bind();
    }

    protected void Class_1Gv_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.Class_1Gv.EditIndex = e.NewEditIndex;
        Bind();
    }

    protected void Class_1Gv_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int classid = int.Parse(Class_1Gv.DataKeys[e.RowIndex].Value.ToString());
        TextBox txt = this.Class_1Gv.Rows[e.RowIndex].Cells[1].Controls[0] as TextBox;
        c_1.updateClass_1(classid, txt.Text.Trim());
        this.Class_1Gv.EditIndex = -1;
        Bind();

    }

    protected void Class_1Gv_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.Class_1Gv.EditIndex = -1;
        Bind();
    }

    /// <summary>
    /// 查找
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void searchBt_Click(object sender, EventArgs e)
    {
        Bind();
    }

    /// <summary>
    /// 添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void addnameBt_Click(object sender, EventArgs e)
    {
        if (c_1.IsExite(this.addnameTb.Text.Trim()) == false)
        {
            c_1.createClass_1(this.addnameTb.Text.Trim());
            Bind();
            Page.RegisterStartupScript("alert", "<script>alert('添加新分类成功!')</script>");
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('该分类已经存在')</script>", false);
        }
    }
    protected void Class_1Gv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
    }
}
