﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_NewsClass_2_List : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Class_1 c_1 = new BLL.Class_1();
    BLL.Class_2 c_2 = new BLL.Class_2();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "二级类别管理";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                BindClass_1(this.addtypeddl);
                BindClass_1(this.Class_1ddl);
                Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }

    /// <summary>
    /// 绑定一级分类
    /// </summary>
    private void BindClass_1(DropDownList ddl)
    {
        DataTable table = c_1.Class_1list("");

        foreach (DataRow row in table.Rows)
        {
            ListItem li = new ListItem(row["ClassName"].ToString(), row["ClassID_1"].ToString());

            ddl.Items.Add(li);
        }
        ddl.Items.Insert(0, new ListItem("选择一级分类", "0"));
    }

    /// <summary>
    /// 绑定
    /// </summary>
    private void Bind()
    {
        DataTable tabel = c_2.Class_2list(int.Parse(this.Class_1ddl.SelectedValue.ToString()), this.ClassNameTb.Text.Trim());
        this.Class_2Gv.DataSource = tabel.DefaultView;
        this.Class_2Gv.DataBind();
    }

    protected void Class_2Gv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.Class_2Gv.PageIndex = e.NewPageIndex;
        this.Bind();
    }

    protected void Class_2Gv_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.Class_2Gv.EditIndex = -1;
        this.Bind();
    }

    protected void Class_2Gv_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int ClassID = int.Parse(this.Class_2Gv.DataKeys[e.RowIndex].Value.ToString());
        c_2.deleteClass_2(ClassID);
        this.Bind();
    }

    protected void Class_2Gv_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.Class_2Gv.EditIndex = e.NewEditIndex;
        this.Bind();

        DropDownList ddl = this.Class_2Gv.Rows[e.NewEditIndex].Cells[1].FindControl("Class_1ddl") as DropDownList;
        DataTable table = c_1.Class_1list("");

        foreach (DataRow row in table.Rows)
        {
            ListItem li = new ListItem(row["ClassName"].ToString(), row["ClassID_1"].ToString());
            ddl.Items.Add(li);
        }

        Label label = this.Class_2Gv.Rows[e.NewEditIndex].Cells[1].FindControl("label") as Label;//?
        ListItem item = ddl.Items.FindByText(label.Text.Trim());
        item.Selected = true;
    }

    protected void Class_2Gv_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int ClassID = int.Parse(this.Class_2Gv.DataKeys[e.RowIndex].Value.ToString());
        DropDownList ddl = this.Class_2Gv.Rows[e.RowIndex].Cells[1].FindControl("Class_1ddl") as DropDownList;
        TextBox txt = this.Class_2Gv.Rows[e.RowIndex].Cells[1].FindControl("TextBox1") as TextBox;
        c_2.updateClass_2(ClassID, int.Parse(ddl.SelectedValue.ToString()), txt.Text.Trim());

        this.Class_2Gv.EditIndex = -1;

        Bind();
    }

    protected void Class_2Gv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowIndex != -1)
        {
            e.Row.Cells[0].Text = (e.Row.RowIndex + 1).ToString();
        }
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
    }

    /// <summary>
    /// 添加新分类
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void addtypeBt_Click(object sender, EventArgs e)
    {
        int ClassID_1 = int.Parse(this.addtypeddl.SelectedValue.ToString());
        string ClassName = this.addtypeTb.Text.Trim();
        if (c_2.IsExite(ClassName) == false)
        {
            if (c_2.createClass_2(ClassID_1, ClassName) == 1)
            {
                this.Bind();
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('添加分类成功')</script>", false);
            }
            else
            {
                Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('添加分类失败')</script>", false);
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('分类名称已经存在')</script>", false);
        }
    }

    /// <summary>
    ///  查找
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void searchBt_Click(object sender, EventArgs e)
    {
        Bind();
    }

    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
        args.IsValid = this.addtypeddl.SelectedIndex == 0 ? false : true;
    }
}
