﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Order_List : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Order ord = new BLL.Order();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "订单列表";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }

    private void Bind()
    {
        DataTable table = ord.selectorderlist(this.usernametb.Text.Trim(), int.Parse(this.stateddl.SelectedValue.ToString()));
        this.orderlistgv.DataSource = table.DefaultView;
        this.orderlistgv.DataBind();
    }

    protected void orderlistgv_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            DataRowView drv = e.Row.DataItem as DataRowView;
            Label label = e.Row.Cells[4].FindControl("statelabel") as Label;

            LinkButton lb = e.Row.Cells[8].FindControl("operatelinkbutton") as LinkButton;
            switch (drv["state"].ToString())
            {
                case "0":
                    {
                        label.Text = "取消订单";
                        lb.Text = "恢复订单";
                        break;
                    }
                case "1":
                    {
                        label.Text = "等待发货";
                        lb.Text = "商家发货";
                        break;
                    }
                case "2":
                    {
                        label.Text = "商家已发货";
                        lb.Text = "收货确认";
                        break;
                    }
                case "3":
                    {
                        label.Text = "确认收货";
                        lb.Text = "完成交易";
                        break;
                    }
                case "4":
                    {
                        label.Text = "完成交易";
                        lb.Text = "交易完成";
                        lb.Enabled = false;
                        break;
                    }
            }
        }
    }

    protected void stateddl_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.Bind();
    }

    protected void orderlistgv_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "operate")
        {

            GridViewRow row = (GridViewRow)((Control)e.CommandSource).Parent.Parent;

            string orderid = (row.Cells[0].FindControl("orderidlabel") as Label).Text;
            int statecode = int.Parse((row.Cells[0].FindControl("statecodelabel") as Label).Text);

            if (statecode == 0)
            {
                ord.updatestate(orderid, 1);
                this.Bind();
            }
            if (statecode == 1)
            {
                ord.updatestate(orderid, 2);
                this.Bind();
            }
            //if (statecode == 2)
            //{
            //    ord.updatestate(orderid, 3);
            //    this.Bind();
            //}
            if (statecode == 3)
            {
                ord.updatestate(orderid, 4);
                this.Bind();
            }
        }
    }

    protected void orderlistgv_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.orderlistgv.PageIndex = e.NewPageIndex;
        this.Bind();
    }

    protected void searchTb_Click(object sender, EventArgs e)
    {
        this.Bind();
    }
}
