﻿// JScript 文件
/**
* 用JS实现的仿windows进度条的类。
*
*
* @package 		MallZ.com
* @author		林子
* @nickname		lfow
* @version		$Revision: 1.0.5 Bulid 1217 $
* @date 		$Date: 2008/11/08 $
* @copyright 	http://www.MallZ.com/
*
*/
function GuageBar($width, $height)
{
	if (!GuageBar.PoolID)
	{
		GuageBar.PoolID = new Array();
	}
	this.$_width = $width + '';
	this.$_height = $height + '';
	this.$_htmlCode = '';
	this.$_docID1 = null;
	this.$_docID2 = null;
}

/**
 * Description 分析字符串，并返回一个数组。比如，以2px作为参数传递给此函数，将返回一个有两个元素的数组new Array(2, 'px')
 * @author 林子
 * @param string 要分析的字符串
 * @return array 返回一个有两个元素的数组；其中，第一个元素为整数，第二个元素为字符。失败返回 FALSE
 */
GuageBar.prototype._parseWidthHeight = function($widthheight) {
	$widthheight += '';
	if ('auto' == $widthheight) {
		return false;
	} else if ('' !== $widthheight && $widthheight.match(/(\d+)([a-zA-z]*)/i)) {
		return new Array(RegExp.$1, RegExp.$2 ? RegExp.$2 : '');
	}
	return new Array(0, 'px');
}


/**
 * Description 将进度条输出为HTML并在浏览器中显示；无返回值
 * @author 林子
 */
GuageBar.prototype.showUI = function() {
	if (this.$_htmlCode) {
		return;
	}
	GuageBar.PoolID[GuageBar.PoolID.length] = 1;
	this.$_htmlCode = '<div id="GuageBar_ID1_'+GuageBar.PoolID.length+'" style="position:absolute;width:'+this.$_width+';height:'+this.$_height+';background-color:white;text-align:center;line-height:26px;font-size:12px;color:white;border-style:inset;border-width:2px;color:black;">0%</div><div id="GuageBar_ID2_'+GuageBar.PoolID.length+'" style="margin:4px 0px 0px 4px;position:absolute;width:'+this.$_width+';height:'+this.$_height+';background-color:blue;text-align:center;line-height:22px;font-size:12px;color:white;clip:rect(auto 0px auto auto);border:0px solid red;">0%</div><div style="clear:both;"></div>';
	document.write(this.$_htmlCode);
	this.$_docID1 = document.getElementById('GuageBar_ID1_'+GuageBar.PoolID.length);
	this.$_docID2 = document.getElementById('GuageBar_ID2_'+GuageBar.PoolID.length);
	var $arrtmp1 = false, $arrtmp2 = false;
	if (this.$_docID1.currentStyle) {
		if ('' === this.$_width) {
			$arrtmp1 = this._parseWidthHeight(this.$_docID1.currentStyle.width);
			(false === $arrtmp1) && ($arrtmp1 = this._parseWidthHeight(this.$_docID1.parentNode.currentStyle.width));
			(false === $arrtmp1) && ($arrtmp1 = this._parseWidthHeight(document.body.clientWidth));
		} else {
			$arrtmp1 = this._parseWidthHeight(this.$_width);
		}

		if ('' === this.$_height) {
			$arrtmp2 = this._parseWidthHeight(this.$_docID1.currentStyle.height);
			(false === $arrtmp2) && ($arrtmp2 = this._parseWidthHeight(this.$_docID1.parentNode.currentStyle.height));
			(false === $arrtmp2) && ($arrtmp2 = new Array('20', 'px'));
		} else {
			$arrtmp2 = this._parseWidthHeight(this.$_height);
		}
	} else if (window.getComputedStyle) {
		if ('' === this.$_width) {
			var $tmpwidth = null;
			if ('' === this.$_docID1.style.width) {
				$tmpwidth = window.getComputedStyle(this.$_docID1.parentNode, null).getPropertyValue('width');
			} else {
				$tmpwidth = window.getComputedStyle(this.$_docID1, null).getPropertyValue('width');
			}
			if (0 === parseInt($tmpwidth)) {
				$tmpwidth = document.body.clientWidth;
			}
			$arrtmp1 = this._parseWidthHeight($tmpwidth);
			(false === $arrtmp1) && ($arrtmp1 = this._parseWidthHeight(window.getComputedStyle(this.$_docID1.parentNode, null).getPropertyValue('width')));
			(false === $arrtmp1) && ($arrtmp1 = this._parseWidthHeight(document.body.clientWidth));
		} else {
			$arrtmp1 = this._parseWidthHeight(this.$_width);
		}
		
		if ('' === this.$_height) {
			var $tmpheight = null;
			if ('' === this.$_docID1.style.height) {
				$tmpheight = window.getComputedStyle(this.$_docID1.parentNode, null).getPropertyValue('height');
			} else {
				$tmpheight = window.getComputedStyle(this.$_docID1, null).getPropertyValue('height');
			}
			if (0 === parseInt($tmpheight)) {
				$tmpheight = '20px';
			}
			$arrtmp2 = this._parseWidthHeight($tmpheight);
			(false === $arrtmp2) && ($arrtmp2 = this._parseWidthHeight(window.getComputedStyle(this.$_docID1.parentNode, null).getPropertyValue('height')));
			(false === $arrtmp2) && ($arrtmp2 = new Array('20', 'px'));
		} else {
			$arrtmp2 = this._parseWidthHeight(this.$_height);
		}
	}
	(false !== $arrtmp1) && (this.$_docID1.style.width = $arrtmp1[0]+''+$arrtmp1[1]) && (this.$_docID2.style.width = $arrtmp1[0]+''+$arrtmp1[1]);
	(false !== $arrtmp2) && (this.$_docID1.style.height = $arrtmp2[0]+''+$arrtmp2[1]) && (this.$_docID2.style.height = $arrtmp2[0]+''+$arrtmp2[1]);
};


/**
 * Description 设置进度条的百分比值
 * @author 林子
 * @param int 要设置的百分比值
 * @return bool 成功返回 TRUE ，否则返回 FALSE
 */
GuageBar.prototype.setPercent = function($ipercent) {
	$ipercent = parseInt($ipercent);
	if (isNaN($ipercent)) {
		return false;
	}
	var $arr = null;
	if (this.$_docID2.currentStyle) {
		$arr = this._parseWidthHeight(this.$_docID2.currentStyle.width);
	} else if (window.getComputedStyle) {
		$arr = this._parseWidthHeight(window.getComputedStyle(this.$_docID2, null).getPropertyValue('width'));
	}
	if (!$arr) {
		return false;
	}
	this.$_docID1.innerHTML = $ipercent+'%';
	this.$_docID2.innerHTML = $ipercent+'%';
	this.$_docID2.style.clip = 'rect(auto '+($ipercent*($arr[0]-3)/100)+''+$arr[1]+' auto auto)';
	return true;
};
