﻿<%@ page language="C#" validaterequest="false" masterpagefile="MyShop.master" enableeventvalidation="False" autoeventwireup="true" inherits="Shop_Manage_Shop_ViewProductByShopProductClassID, mallz" title="商品分类" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<div class="pageTitle">查看商品分类列表</div>
    <table class="SearchTableStyle">
        <tr>
            <td width="200px" >
               条件一：输入标题标题搜索</td>
            <td width="200px">
                <asp:TextBox ID="TxtSreachClassName" runat="server" AutoPostBack="True" />
            </td>
        </tr>
    </table>
       <asp:GridView ID="GVProduct" runat="server" AllowPaging="True" AutoGenerateColumns="False"                       
                DataSourceID="ProductDataSource" CssClass="tableHead" DataKeyNames="ProductID">
                <Columns>
                    <asp:TemplateField HeaderText="编号">                               
                        <ItemTemplate>
                            <asp:CheckBox ID="CheckElite" runat="server" Text='<%# Bind("ProductID") %>'/>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="商品类型">                               
                        <ItemTemplate>
                            <asp:Literal ID="LabProductType" runat="server" Text='<%# MallZ.Web.Shop.TextFormat.GetProductType(Eval("ProductType").ToString()) %>'  />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="名称">                               
                        <ItemTemplate>
                            <asp:HyperLink ID="HyperLink1" runat="server" Text='<%# Eval("ProductName") %>'  NavigateUrl='<%# "../ShowProduct.aspx?ProductID="+Eval("ProductID") %>' Target="_blank"/>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="图片">
                        <ItemTemplate>
                           <img  src='<%# (Convert.ToString(Eval("ProductSmallImageUrl"))==""?"../Images/show_nopic.gif":Eval("ProductSmallImageUrl")) %>'
                                style="border-right: white 4px solid; border-top: white 4px solid; border-left: white 4px solid;
                                border-bottom: white 4px solid; width:100px; height:100px;" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <ItemTemplate>
                            <asp:HyperLink ID="EditProduct" runat="server" Text="编辑" NavigateUrl='<%#"../Auction/ProductEdit.aspx?ProductID="+Eval("ProductID") %>' Target="_blank" />
                        </ItemTemplate>
                    </asp:TemplateField>                  
                </Columns> 
               <PagerStyle Width="100%" Font-Size="13px" />
           <EmptyDataTemplate>
               <div style="text-align:center">暂无商品</div>
           </EmptyDataTemplate>
            </asp:GridView>
       <table  class="SearchTableStyle">
         <tr>
             <td  colspan="2">
                <input id="chkAll" onclick="SelectAllCheckboxes(this);" runat="server" type="checkbox" />全选  
                 &nbsp;放到新的类别： &nbsp;&nbsp;
                 <asp:DropDownList ID="DropNewClass" runat="server" Width="200px"/>
                 <asp:Button ID="ButElite" runat="server" OnClick="ButElite_Click" Text="加入该分类" />&nbsp;&nbsp;&nbsp;
                 <asp:Button ID="ButBack" runat="server" OnClick="ButBack_Click" Text="返回" /></td>
            </tr>
        </table>
                <asp:ObjectDataSource ID="ProductDataSource" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="GetProductByShopCategoryIDKeyWord" TypeName="MallZ.Data.Shop_Product" UpdateMethod="GetProductByCategoryIDShopIDKeywords">
                    <SelectParameters>
                    <asp:Parameter
                        DefaultValue="-1" Name="ShopID" Type="Int32" />
                        <asp:QueryStringParameter  Name="ShopProductClassID" QueryStringField="ShopProductClassID"
                            Type="Int32"  DefaultValue="-1"/>
                        <asp:ControlParameter ControlID="TxtSreachClassName" Name="KeyWord" PropertyName="Text"
                            Type="String"  DefaultValue="" />
                    </SelectParameters>
                    <UpdateParameters>
                        <asp:Parameter Name="CateGoryID" Type="Int32" />
                        <asp:Parameter Name="ShopID" Type="Int32" />
                        <asp:Parameter Name="KeyWords" Type="String" />
                        <asp:Parameter Name="DateTimeSect" Type="String" />
                    </UpdateParameters>
                </asp:ObjectDataSource>
               <br />
 

</asp:Content>

